/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.IOException;
import java.util.LinkedList;
import progress.message.broker.Broker;
import progress.message.ft.DynamicSyncManager;
import progress.message.ft.RBRegistrySyncOp;
import progress.message.ft.ReplicationManager;
import progress.message.zclient.DebugThread;

public class RBRegistryDynSyncer
extends DebugThread {
    private DynamicSyncManager m_dsm;
    private ReplicationManager m_rm;
    private int m_role = -1;
    private LinkedList m_todoList = null;

    public RBRegistryDynSyncer(ReplicationManager rm, DynamicSyncManager dsm, int role) {
        super("RBRegistryDynSyncer");
        this.m_dsm = dsm;
        this.m_rm = rm;
        this.m_role = role;
        if (this.m_role == 2) {
            this.m_todoList = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkItem(RBRegistrySyncOp rbRegistrySyncOp) {
        LinkedList linkedList = this.m_todoList;
        synchronized (linkedList) {
            this.m_todoList.add(rbRegistrySyncOp);
            this.m_todoList.notifyAll();
        }
    }

    @Override
    public void threadMain() {
        try {
            if (this.DEBUG) {
                this.debug("RBRegistryDynSyncer running...m_role: " + this.m_role);
            }
            if (this.m_role == 1) {
                if (this.DEBUG) {
                    this.debug("get and send remote broker registry info to be replicated on the standby");
                }
                this.doActiveSync();
            } else if (this.m_role == 2) {
                if (this.DEBUG) {
                    this.debug("receive and process remote broker registry info replicated from active");
                }
                this.doStandbySync();
            }
            if (this.DEBUG) {
                this.debug("RBRegistryDynSyncer exiting...");
            }
            this.m_dsm.setStatus(8);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException io) {
            if (!this.isShuttingDown()) {
                io.printStackTrace();
            }
        }
        finally {
            if (this.DEBUG) {
                this.debug("Thread Exiting; Broker.exiting= " + Broker.exiting);
            }
        }
    }

    private void doActiveSync() throws InterruptedException {
        try {
            this.m_dsm.replicateRBRegistry();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStandbySync() throws InterruptedException, IOException {
        boolean firstChunk = true;
        while (!this.isShuttingDown()) {
            RBRegistrySyncOp rbRegistryOp = null;
            LinkedList linkedList = this.m_todoList;
            synchronized (linkedList) {
                while (this.m_todoList.isEmpty()) {
                    this.m_todoList.wait();
                }
                rbRegistryOp = (RBRegistrySyncOp)this.m_todoList.removeFirst();
            }
            if (firstChunk) {
                firstChunk = false;
                this.m_rm.deleteRBRegistryDbData();
            }
            rbRegistryOp.execute();
            this.m_dsm.acknowledge(rbRegistryOp.getGuarTrackingNum());
            if (!rbRegistryOp.isLastChunk()) continue;
            if (!this.DEBUG) break;
            this.debug("Received last replication chunk RBRegistrySyncOp");
            break;
        }
    }
}

