/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import progress.message.msg.IErrorHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.Mgram;
import progress.message.msg.v25.Payload;
import progress.message.util.ArrayUtil;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.SessionConfig;

final class ErrorPayload
extends Payload
implements IErrorHandle {
    private static final int ERROR_PAYLOAD_LEN = 8;
    private int m_errCode;
    private int m_errInfo;
    static final int s_errPayloadMemSize = MemoryUtil.estimateBaseSize(ErrorPayload.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.println("Error Code: " + this.getErrCode());
            log.println("Error Info: " + this.getErrInfo());
        }
    }

    public ErrorPayload(Mgram m) {
        super(m);
    }

    @Override
    protected boolean isDirty() {
        return false;
    }

    @Override
    protected int memoryLength() {
        return s_errPayloadMemSize;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        this.m_errCode = StreamUtil.readInt(is);
        this.m_errInfo = StreamUtil.readInt(is);
    }

    @Override
    protected byte[] toByteArray() {
        byte[] result = new byte[8];
        ArrayUtil.writeInt(result, 0, this.m_errCode);
        ArrayUtil.writeInt(result, 4, this.m_errInfo);
        return result;
    }

    @Override
    protected void sync() {
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeInt(this.m_errCode, os);
        StreamUtil.writeInt(this.m_errInfo, os);
    }

    @Override
    public int length() {
        return 8;
    }

    @Override
    public void setErrInfo(int errInfo) {
        this.m_errInfo = errInfo;
    }

    @Override
    public int getErrInfo() {
        return this.m_errInfo;
    }

    @Override
    public void setErrCode(int errCode) {
        this.m_errCode = errCode;
    }

    @Override
    public int getErrCode() {
        return this.m_errCode;
    }

    @Override
    public IErrorHandle getErrorHandle() {
        return this;
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("ERR_CODE", new Integer(this.m_errCode));
        result.put("ERR_INFO", new Integer(this.m_errInfo));
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_errCode = (Integer)map.get("ERR_CODE");
        this.m_errInfo = (Integer)map.get("ERR_INFO");
    }
}

