/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime;

import com.sonicsw.mf.common.MFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class MFDurableOperationException
extends MFException {
    static final long serialVersionUID = -1921687787552457778L;
    static short serialVersion = 0;
    public static final int NO_ERROR = 0;
    public static final int ERR_UNABLE_TO_COMPLETE = 1;
    public static final int ERR_SUBSCRIBER_ACTIVE = 2;
    public static final int ERR_MESSAGE_NOT_FOUND = 3;
    public static final int ERR_SUBSCRIBER_NOT_FOUND = 4;
    public static final int ERR_BROWSER_NOT_FOUND = 5;
    private static final String[] ERROR_CODE_STRINGS = new String[]{"NO_ERROR", "ERR_UNABLE_TO_COMPLETE", "ERR_SUBSCRIBER_ACTIVE", "ERR_MESSAGE_NOT_FOUND", "ERR_SUBSCRIBER_NOT_FOUND", "ERR_BROWSER_NOT_FOUND"};
    private static final String s_errorKey = "MFDurableOpErrorKey";
    private int m_errorCode;

    public MFDurableOperationException(int errorcode, String msg) {
        super(msg);
        this.m_errorCode = errorcode;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String origMsg = super.getMessage();
        if (origMsg != null && origMsg.length() > 0) {
            sb.append(origMsg).append(" (");
        }
        sb.append("Durable operation error code: ").append(this.m_errorCode);
        if (this.m_errorCode >= 0 && this.m_errorCode < ERROR_CODE_STRINGS.length) {
            sb.append(" - ").append(ERROR_CODE_STRINGS[this.m_errorCode]);
        }
        if (origMsg != null && origMsg.length() > 0) {
            sb.append(')');
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(2);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(serialVersion));
        stream.writeUTF(s_errorKey);
        stream.writeObject(new Integer(this.m_errorCode));
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_errorCode = (Integer)map.get(s_errorKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

