/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mq.common.runtime.IAcceptorData;
import com.sonicsw.mq.common.runtime.IBrowseToken;
import com.sonicsw.mq.common.runtime.IConnectionData;
import com.sonicsw.mq.common.runtime.IConnectionMemberDetails;
import com.sonicsw.mq.common.runtime.IConnectionMemberInfo;
import com.sonicsw.mq.common.runtime.IConnectionTreeNode;
import com.sonicsw.mq.common.runtime.IDestination;
import com.sonicsw.mq.common.runtime.IDurableSubscriptionData;
import com.sonicsw.mq.common.runtime.IGlobalQueueRouteData;
import com.sonicsw.mq.common.runtime.IMessage;
import com.sonicsw.mq.common.runtime.IMessageHeader;
import com.sonicsw.mq.common.runtime.IMessageHeaderToken;
import com.sonicsw.mq.common.runtime.IPreparedXABranchData;
import com.sonicsw.mq.common.runtime.IQueueData;
import com.sonicsw.mq.common.runtime.IReliableSequenceData;
import com.sonicsw.mq.common.runtime.IRemoteSubscriptionSummary;
import com.sonicsw.mq.common.runtime.ISubscriberData;
import com.sonicsw.mq.common.runtime.impl.AcceptorData;
import com.sonicsw.mq.common.runtime.impl.BrowseMessage;
import com.sonicsw.mq.common.runtime.impl.BrowseToken;
import com.sonicsw.mq.common.runtime.impl.ConnectionData;
import com.sonicsw.mq.common.runtime.impl.ConnectionMemberDetails;
import com.sonicsw.mq.common.runtime.impl.ConnectionMemberInfo;
import com.sonicsw.mq.common.runtime.impl.ConnectionTreeNode;
import com.sonicsw.mq.common.runtime.impl.Destination;
import com.sonicsw.mq.common.runtime.impl.DurableSubscriptionData;
import com.sonicsw.mq.common.runtime.impl.GlobalQueueRouteData;
import com.sonicsw.mq.common.runtime.impl.MessageHeader;
import com.sonicsw.mq.common.runtime.impl.MessageHeaderToken;
import com.sonicsw.mq.common.runtime.impl.PreparedXABranchData;
import com.sonicsw.mq.common.runtime.impl.QueueData;
import com.sonicsw.mq.common.runtime.impl.ReliableSequenceData;
import com.sonicsw.mq.common.runtime.impl.RemoteSubscriptionSummary;
import com.sonicsw.mq.common.runtime.impl.RoutingStatistic;
import com.sonicsw.mq.common.runtime.impl.SubscriberData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import progress.message.broker.Config;
import progress.message.broker.durable.IDurableHeaderInfo;
import progress.message.jimpl.Message;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISidebandData;

public class RuntimeDataFactory {
    public static final short VERSION_6_1_0 = 0;
    public static final short VERSION_7_0_0 = 1;
    public static final short CURRENT_VERSION = 1;

    public static IQueueData createQueueData(String queueName, int queueTypeMask, int messageCount, long messagesSize) {
        return new QueueData(queueName, queueTypeMask, messageCount, messagesSize);
    }

    public static IConnectionData createConnectionData(String user, String[] id, String host, int connectionTypeMask, long connectionMemberRef) {
        return new ConnectionData(user, id, host, connectionTypeMask, connectionMemberRef);
    }

    public static IConnectionMemberInfo createConnectionMemberInfo(String name, short type, Long ref, Long parentRef, ArrayList childRefs) {
        return new ConnectionMemberInfo(name, type, ref, parentRef, childRefs);
    }

    public static IConnectionMemberDetails createConnectionMemberDetails(IConnectionMemberInfo info, int ccState, long timeConnected, long timeOfLastStateChange, IDestination destination) {
        return new ConnectionMemberDetails(info, ccState, timeConnected, timeOfLastStateChange, destination);
    }

    public static IConnectionTreeNode createConnectionTreeNode(IConnectionMemberInfo info, IConnectionTreeNode parent) {
        return new ConnectionTreeNode(info, parent);
    }

    public static IAcceptorData createAcceptorData(Properties acceptorData) {
        return new AcceptorData(acceptorData);
    }

    public static IAcceptorData createAcceptorData(String acceptorName, String protocol, String URL2, String externalURL, int port, int state, int connectionCount) {
        return new AcceptorData(acceptorName, protocol, URL2, externalURL, port, state, connectionCount);
    }

    public static IDurableSubscriptionData createDurableSubscriptionData(String user, String clientID, String subscriptionName, byte[] subject, String selector, boolean selectorAtBroker, boolean isConnectionConsumer, long messageCount, long messageSize, long lastConnectedTime) {
        return new DurableSubscriptionData(user, clientID, subscriptionName, subject, selector, selectorAtBroker, isConnectionConsumer, messageCount, messageSize, lastConnectedTime);
    }

    public static ISubscriberData createSubscriberData(String clientID, String subscriptionName, byte[] subject, boolean isDurable, boolean isConnectionConsumer, long messageCount, long messageSize, long connectionMemberRef) {
        return new SubscriberData(clientID, subscriptionName, subject, isDurable, isConnectionConsumer, messageCount, messageSize, connectionMemberRef);
    }

    public static IRemoteSubscriptionSummary createRemoteSubscriptionSummary(String nodeName, long messageCount, long messageSize) {
        return new RemoteSubscriptionSummary(nodeName, messageCount, messageSize);
    }

    public static IRemoteSubscriptionSummary createRemoteSubscriptionSummary(String nodeName, long messageCount, long messageSize, boolean hasRemoteSubscription) {
        return new RemoteSubscriptionSummary(nodeName, messageCount, messageSize, hasRemoteSubscription);
    }

    public static IPreparedXABranchData createPreparedXABranchData(String user, String appID, String branchXID, int TID) {
        return new PreparedXABranchData(user, appID, branchXID, TID);
    }

    public static IGlobalQueueRouteData createGlobalQueueRouteData(String routingNode, String globalQueueName) {
        return new GlobalQueueRouteData(routingNode, globalQueueName);
    }

    public static IMessageHeader createMessageHeader(IMessageHeaderToken token, Hashtable properties) {
        return new MessageHeader((MessageHeaderToken)token, properties);
    }

    public static IMessageHeaderToken createMessageHeaderToken(String jmsMessageID, long clientId, String originationBroker) {
        return new MessageHeaderToken(jmsMessageID, clientId, originationBroker);
    }

    public static String getMHTJMSMessageID(IMessageHeaderToken mht) {
        return ((MessageHeaderToken)mht).getJMSMessageID();
    }

    public static long getMHTClientId(IMessageHeaderToken mht) {
        return ((MessageHeaderToken)mht).getClientId();
    }

    public static String getMHTOriginationBroker(IMessageHeaderToken mht) {
        return ((MessageHeaderToken)mht).getOriginationBroker();
    }

    public static IBrowseToken createBrowseToken(long clientId, String tracking) {
        return new BrowseToken(clientId, tracking);
    }

    public static long getBrowseTokenClientId(IBrowseToken bt) {
        return ((BrowseToken)bt).getClientId();
    }

    public static String getBrowseTokenTracking(IBrowseToken bt) {
        return ((BrowseToken)bt).getTracking();
    }

    public static IMessage createBrowseMessage(byte[] mgram) {
        return new BrowseMessage(mgram);
    }

    public static IMessageHeader createMessageHeaderFromDurableHeader(IDurableHeaderInfo info) {
        MessageHeader result = new MessageHeader(new MessageHeaderToken(info.getJMSMessageID(), info.getClientId(), info.getOriginationBroker()), info.getUserProperties());
        result.setJMSDeliveryMode(Message.getJMSDeliveryMode(info.isJMSPersistent(), info.isDiscardable(), info.isNonPersistentReplicated()));
        result.setJMSCorrelationID(info.getCorrelationID());
        result.setJMSMessageID(info.getJMSMessageID());
        result.setBrokerName(info.getOriginationBroker());
        result.setJMSDestination(new Destination(info.getRouting(), info.getSubject().toByteArray()));
        String replyTo = info.getReplyToSubject();
        if (replyTo != null) {
            Vector v = info.getAllRouting();
            replyTo = Message.getJMSReplyToInternal(replyTo, v);
            result.setJMSReplyTo(new Destination(replyTo));
        }
        result.setJMSTimestamp(info.getJMSTimeStamp());
        result.setJMSType(info.getJMSType());
        result.setJMSExpiration(info.getJMSExpiration());
        return result;
    }

    public static IMessageHeader createMessageHeader(IMgram m, long clientId) {
        ISidebandData sideband = m.getSidebandDataReadOnly();
        if (sideband == null) {
            sideband = MgramFactory.getMgramFactory().buildSidebandData();
        }
        String jmsMessageID = Envelope.getMessageID(m);
        MessageHeader result = new MessageHeader(new MessageHeaderToken(jmsMessageID, clientId, null), sideband.getProperties());
        result.setEnqueuedSize(m.getEnqueuedSize());
        result.setJMSDeliveryMode(Message.getJMSDeliveryMode(m.isJMSPersistent(), m.isDiscardable(), m.isNonPersistentReplicated()));
        result.setJMSCorrelationID(sideband.getCorrelationID());
        result.setJMSMessageID(jmsMessageID);
        result.setBrokerName(Config.BROKER_NAME);
        result.setJMSDestination(new Destination(m.getRouting(), m.getSubject().toByteArray()));
        String replyTo = sideband.getReplyTo();
        if (replyTo != null) {
            Vector v = m.getRoutingHandle().getAllRouting();
            replyTo = Message.getJMSReplyToInternal(replyTo, v);
            result.setJMSReplyTo(new Destination(replyTo));
        }
        result.setJMSTimestamp(sideband.getTimestamp());
        result.setJMSType(sideband.getType());
        result.setJMSExpiration(m.getTTE());
        result.setJMSPriority(m.getPriority());
        return result;
    }

    public static RoutingStatistic createRoutingStat(String nodeName) {
        return new RoutingStatistic(nodeName);
    }

    public static IReliableSequenceData createReliableSequenceData(String id, long outstandingMessageCount) {
        return new ReliableSequenceData(id, outstandingMessageCount);
    }
}

