/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.receiver.fsm;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.rm.common.RMSequence;
import com.sonicsw.ws.rm.common.RMSequenceSupport;
import com.sonicsw.ws.rm.common.ReliableMessageWrapper;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.protocol.AcksTo;
import com.sonicsw.ws.rm.protocol.ElementCreator;
import com.sonicsw.ws.rm.protocol.SequenceFault;
import com.sonicsw.ws.rm.receiver.fsm.InboundExpiresEvent;
import com.sonicsw.ws.rm.receiver.fsm.InboundInactivityTimeoutEvent;
import com.sonicsw.ws.rm.receiver.fsm.InitialReceiveState;
import com.sonicsw.ws.rm.receiver.fsm.ReceiverClient;
import com.sonicsw.ws.rm.receiver.fsm.RequestAckEvent;
import java.io.IOException;
import java.net.SocketException;
import java.util.Date;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.From;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import progress.message.broker.Config;
import progress.message.util.server.ReOrderBuffer;

public class RMReceiveSequence
extends RMSequenceSupport
implements ReOrderBuffer.BufferConditionListener {
    private static final int MAX_BACKOFF = 10;
    private long m_lastAcksSentTime;
    private long m_acksTransmissionCount;
    private MessageID m_requestMessageID;
    private EndpointReference m_requestReplyTo;
    private boolean m_flowControlBlocked = false;
    private boolean m_flowControlReorderBufferFull = false;
    private String m_blockedUser;

    public RMReceiveSequence() {
        this.changeState(new InitialReceiveState());
    }

    @Override
    public boolean isOutbound() {
        return false;
    }

    @Override
    public void faultSequence(AxisFault f) {
        this.faultSequence(f, true);
    }

    public void faultSequence(AxisFault f, boolean alwaysFault) {
        try {
            HttpOutboundHandler handler;
            this.uncirculateSequence();
            AddressingHeaders headers = new AddressingHeaders();
            SOAPEnvelope envelope = ElementCreator.createSimpleEnvelope(AddressingUtils.getFaultActionURI(), null, this.getSOAPConstants(), this.getConstants());
            SOAPBody sb = (SOAPBody)envelope.getBody();
            SOAPFault ft = (SOAPFault)sb.addFault();
            ft.setFault(f);
            AcksTo a2 = this.getSequenceState().getAcksTo();
            String toUrl = a2.getAddress().getAddress().toString();
            if (com.sonicsw.ws.addressing.AddressingUtils.isAnonymousURI(toUrl)) {
                BrokerComponent.getComponentContext().logMessage("Unable to send sequence fault for reliable SOAP receive sequence - the sequence fault address is anonymous:" + this.getId(), BrokerComponent.getLevelWarning().intValue());
                return;
            }
            Message m = new Message((Object)envelope);
            From from = new From((EndpointReferenceType)this.getSequenceState().getEndpointReference());
            Address toAddress = new Address(toUrl);
            To to = new To((URI)toAddress);
            headers.setTo(to);
            headers.setReferenceProperties(a2.getAddress().getProperties());
            headers.setReferenceParameters(a2.getAddress().getParameters());
            headers.setFrom((EndpointReference)from);
            headers.setAction(AddressingUtils.getFaultActionURI());
            ReceiverClient rc = ReceiverClient.getReceiverClient();
            MessageContext mc = new MessageContext((AxisEngine)rc.getAxisClient());
            QName[] sc = f.getFaultSubCodes();
            String scode = "";
            if (sc.length > 0) {
                scode = sc[0].getLocalPart();
            }
            SequenceFault.toSequenceFaultHeader(this.getConstants(), envelope, this.getId(), scode);
            mc.setPastPivot(false);
            mc.setResponseMessage(null);
            mc.setRequestMessage(m);
            HttpLock lock = new HttpLock(610L);
            mc.setProperty("com.sonicsw.net.http.HttpLock", (Object)lock);
            mc.setSOAPConstants(this.getSOAPConstants());
            mc.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)headers);
            String transportURL = a2.getAddress().getAddress().toString();
            mc.setProperty("transport.url", (Object)transportURL);
            mc.setProperty("addressing.setMustUnderstand", (Object)Boolean.toString(false));
            String wsaNS = this.getWSANS();
            if (wsaNS != null) {
                mc.setProperty("addressing.namespace.URI", (Object)wsaNS);
            }
            if ((handler = HandlerUtils.locateHttpRoutingHandler(transportURL)) != null) {
                mc.setProperty("com.sonicsw.net.http.HttpOutboundHandler", (Object)handler);
            }
            mc.setMessage((SOAPMessage)m);
            rc.sendAxis(mc);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof SocketException) {
                BrokerComponent.getComponentContext().logMessage("Network failure attempting to fault inbound reliable sequence:" + this.getId(), BrokerComponent.getLevelWarning().intValue());
            }
            BrokerComponent.getComponentContext().logMessage("Failure attempting to fault inbound reliable sequence:" + this.getId(), (Throwable)e, BrokerComponent.getLevelWarning().intValue());
        }
    }

    public void uncirculateSequence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service() {
        Date now;
        long now2;
        long delta;
        Object messages = null;
        if (this.isMarkedForTermination()) {
            return;
        }
        long inact = 0L;
        long last = 0L;
        RMSequence res = this.getSequenceState();
        RMPolicy p = res.getPolicy();
        if (p != null) {
            inact = this.getSequenceState().getPolicy().getInactivityTimeout();
        }
        if (inact > 0L) {
            last = this.getSequenceState().getLastActivity();
        }
        if (inact > 0L && last > 0L && (delta = (now2 = System.currentTimeMillis()) - last) > inact) {
            InboundInactivityTimeoutEvent evt = new InboundInactivityTimeoutEvent();
            evt.setSequence(this);
            this.markForTermination(evt);
            return;
        }
        Date expiryDate = this.getSequenceState().getExpires();
        if (expiryDate != null && (now = new Date()).after(expiryDate)) {
            InboundExpiresEvent evt = new InboundExpiresEvent();
            evt.setSequence(this);
            this.markForTermination(evt);
            return;
        }
        RMSequence rMSequence = res;
        synchronized (rMSequence) {
            long backoffs;
            if (res.isAllAcknowledged() || res.getMaxReceivedMessageNumber() <= 0L) {
                return;
            }
            AcksTo a2 = res.getAcksTo();
            if (a2 == null || com.sonicsw.ws.addressing.AddressingUtils.isAnonymousURI(a2.getAddress().getAddress().toString())) {
                return;
            }
            long now3 = System.currentTimeMillis();
            long basic = p != null ? p.getAcknowledgementInterval() : 0L;
            boolean useBackoff = false;
            long l = backoffs = useBackoff ? 10L : -1L;
            if (this.getLastAcksSentTime() < now3 - RMReceiveSequence.evaluateBinaryExponentialInterval(basic, backoffs, this.getAcksTransmissionCount() - 1L)) {
                RequestAckEvent evt = new RequestAckEvent();
                evt.setSequence(this);
                this.enqueue(evt, 12);
            }
        }
    }

    public long getLastAcksSentTime() {
        return this.m_lastAcksSentTime;
    }

    public synchronized long getAcksTransmissionCount() {
        return this.m_acksTransmissionCount;
    }

    public void setLastAcksSentTime(long t) {
        this.m_lastAcksSentTime = t;
    }

    public synchronized void setAcksTransmissionCount(long c) {
        this.m_acksTransmissionCount = c;
    }

    public synchronized long incrementAcksTransmissionCount() {
        return ++this.m_acksTransmissionCount;
    }

    public void setRequestMessageID(MessageID mid) {
        this.m_requestMessageID = mid;
    }

    public MessageID getRequestMessageID() {
        return this.m_requestMessageID;
    }

    public void setRequestReplyTo(EndpointReference requestReplyTo) {
        this.m_requestReplyTo = requestReplyTo;
    }

    public EndpointReference getRequestReplyTo() {
        return this.m_requestReplyTo;
    }

    public void messageBlocked(MessageContext mctx) throws IOException, JMSException {
        if (!this.m_flowControlBlocked) {
            this.generateBlockedNotification(mctx);
        }
        this.m_flowControlBlocked = true;
    }

    public void messageSent(MessageContext mctx) throws IOException, JMSException {
        if (this.m_flowControlBlocked) {
            this.generateResumedNotification(mctx);
        }
        this.m_flowControlBlocked = false;
    }

    @Override
    public void bufferFull(Object o) {
        if (!this.m_flowControlReorderBufferFull) {
            this.generateBufferFullNotification(((ReliableMessageWrapper)o).getMsgContext());
        }
        this.m_flowControlReorderBufferFull = true;
    }

    @Override
    public void bufferAvailable() {
        if (this.m_flowControlReorderBufferFull) {
            this.generateBufferAvailableNotification();
        }
        this.m_flowControlReorderBufferFull = false;
    }

    private void generateBlockedNotification(MessageContext mctx) throws IOException, JMSException {
        System.err.println("PBM: RMReceiveSequence.generateBlockedNotification() called");
        if (!Config.ENABLE_WSRM_FLOW_CONTROL_NOTIFICATION) {
            return;
        }
        HttpClientContext hctx = (HttpClientContext)mctx.getProperty("com.sonicsw.net.http.HttpClientContext");
        String cnxID = this.getSequenceState().getSequenceIdentifier().getIdentifier();
        String destName = null;
        boolean isQueue = true;
        if (mctx.getProperty("DEST") != null) {
            Object d = mctx.getProperty("DEST");
            Destination dest = (Destination)d;
            if (dest instanceof Queue) {
                destName = ((Queue)dest).getQueueName();
                isQueue = true;
            } else {
                destName = ((Topic)dest).getTopicName();
                isQueue = false;
            }
        }
        if (isQueue) {
            BrokerManagementNotificationsHelper.sendFlowControlSendPauseNotification(Config.BROKER_NAME, hctx, cnxID, new String[]{destName});
            System.err.println("PBM:   -- sent PTP pause notification");
        } else {
            hctx.getPublishLimiter().generateBlockedEvent(hctx.getMinTopicPriority(), cnxID);
            System.err.println("PBM:   -- sent PubSub pause notification");
        }
    }

    private void generateResumedNotification(MessageContext mctx) throws IOException, JMSException {
        System.err.println("PBM: generateResumedNotification() called");
        if (!Config.ENABLE_WSRM_FLOW_CONTROL_NOTIFICATION) {
            return;
        }
        HttpClientContext hctx = (HttpClientContext)mctx.getProperty("com.sonicsw.net.http.HttpClientContext");
        String cnxID = this.getSequenceState().getSequenceIdentifier().getIdentifier();
        String destName = null;
        boolean isQueue = true;
        if (mctx.getProperty("DEST") != null) {
            Object d = mctx.getProperty("DEST");
            Destination dest = (Destination)d;
            if (dest instanceof Queue) {
                destName = ((Queue)dest).getQueueName();
                isQueue = true;
            } else {
                destName = ((Topic)dest).getTopicName();
                isQueue = false;
            }
        }
        if (isQueue) {
            BrokerManagementNotificationsHelper.sendFlowControlSendResumeNotification(Config.BROKER_NAME, hctx, cnxID);
            System.err.println("PBM:   -- sent PTP resume notification");
        } else {
            hctx.getPublishLimiter().generateUnblockedEvent(cnxID);
            System.err.println("PBM:   -- sent PubSub resume notification");
        }
    }

    private void generateBufferFullNotification(MessageContext mctx) {
        if (!Config.ENABLE_WSRM_FLOW_CONTROL_NOTIFICATION) {
            return;
        }
        HttpClientContext hctx = (HttpClientContext)mctx.getProperty("com.sonicsw.net.http.HttpClientContext");
        String cnxID = this.getSequenceState().getSequenceIdentifier().getIdentifier();
        this.m_blockedUser = hctx.getUid();
        BrokerManagementNotificationsHelper.sendRMBufferFullNotification(Config.BROKER_NAME, hctx.getUid(), cnxID);
    }

    private void generateBufferAvailableNotification() {
        if (!Config.ENABLE_WSRM_FLOW_CONTROL_NOTIFICATION) {
            return;
        }
        String cnxID = this.getSequenceState().getSequenceIdentifier().getIdentifier();
        BrokerManagementNotificationsHelper.sendRMBufferAvailableNotification(Config.BROKER_NAME, this.m_blockedUser, cnxID);
    }
}

