/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.receiver.fsm;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.ws.addressing.AddressingUtils;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.protocol.AcksTo;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.ElementCreator;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.protocol.SequenceAcknowledgement;
import com.sonicsw.ws.rm.receiver.fsm.RMReceiveSequence;
import com.sonicsw.ws.rm.receiver.fsm.ReceiverClient;
import java.net.SocketException;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.From;
import org.apache.axis.message.addressing.To;
import org.apache.axis.types.URI;

public class RequestAckEvent
extends RMEvent {
    @Override
    public void execute() {
        block5: {
            RMReceiveSequence sequence = (RMReceiveSequence)this.getSequence();
            try {
                Constants RMConstants = sequence.getConstants();
                SequenceAcknowledgement seqAck = sequence.getSequenceState().getSequenceAcknowledgement();
                AcksTo a2 = sequence.getSequenceState().getAcksTo();
                String transportURL = a2.getAddress().getAddress().toString();
                if (AddressingUtils.isAnonymousURI(transportURL)) {
                    return;
                }
                From from = new From((EndpointReferenceType)sequence.getSequenceState().getEndpointReference());
                To to = new To((URI)a2.getAddress().getAddress());
                org.apache.axis.message.SOAPEnvelope se = ElementCreator.createAcknowledgementEnvelope(RMConstants, sequence.getSOAPConstants(), seqAck, from, to);
                AddressingHeaders ah = new AddressingHeaders((SOAPEnvelope)se);
                ah.setReferenceProperties(a2.getAddress().getProperties());
                ah.setReferenceParameters(a2.getAddress().getParameters());
                Message m = new Message((Object)se);
                ReceiverClient rc = ReceiverClient.getReceiverClient();
                MessageContext mc = new MessageContext((AxisEngine)rc.getAxisClient());
                ReliableHeaders rh = new ReliableHeaders();
                rh.fromSOAPEnvelope(se);
                mc.setPastPivot(false);
                mc.setResponseMessage(null);
                mc.setRequestMessage(m);
                mc.setProperty("COM_SONIC_RM_REQUEST_HEADERS", (Object)rh);
                String wsaNS = sequence.getWSANS();
                if (wsaNS != null) {
                    mc.setProperty("addressing.namespace.URI", (Object)wsaNS);
                }
                HttpLock lock = new HttpLock(610L);
                mc.setProperty("com.sonicsw.net.http.HttpLock", (Object)lock);
                mc.setSOAPConstants(sequence.getSOAPConstants());
                mc.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)ah);
                mc.setProperty("transport.url", (Object)transportURL);
                mc.setProperty("addressing.setMustUnderstand", (Object)"true");
                mc.setMessage((SOAPMessage)m);
                HttpOutboundHandler handler = HandlerUtils.locateHttpRoutingHandler(transportURL);
                if (handler != null) {
                    mc.setProperty("com.sonicsw.net.http.HttpOutboundHandler", (Object)handler);
                }
                rc.sendAxis(mc);
                sequence.setLastAcksSentTime(System.currentTimeMillis());
                sequence.incrementAcksTransmissionCount();
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof SocketException) break block5;
                BrokerComponent.getComponentContext().logMessage("Failure attempting to send ack for reliable sequence:" + sequence.getId(), (Throwable)e, BrokerComponent.getLevelWarning().intValue());
            }
        }
    }

    public String toString() {
        return "RequestAckEvent";
    }
}

