/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.sender.fsm;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.ws.WSHttpOutResponse;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.rm.common.AddressBinder;
import com.sonicsw.ws.rm.common.IRMAckListener;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.RMSequence;
import com.sonicsw.ws.rm.common.RMSequenceSupport;
import com.sonicsw.ws.rm.common.ReliableMessageWrapper;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.protocol.ElementCreator;
import com.sonicsw.ws.rm.protocol.SequenceFault;
import com.sonicsw.ws.rm.protocol.prAccessor;
import com.sonicsw.ws.rm.sender.fsm.ExpiresEvent;
import com.sonicsw.ws.rm.sender.fsm.InactivityTimeoutEvent;
import com.sonicsw.ws.rm.sender.fsm.InitialSendState;
import com.sonicsw.ws.rm.sender.fsm.RequestResendEvent;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedMap;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.addressing.util.AddressingUtils;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;

public class RMSendSequence
extends RMSequenceSupport
implements IRMAckListener {
    private static final int MAX_BACKOFF = 10;

    public RMSendSequence() {
        this.changeState(new InitialSendState());
    }

    @Override
    public boolean isOutbound() {
        return true;
    }

    @Override
    public void faultSequence(AxisFault f) {
        this.faultSequence(f, true, true);
    }

    public void faultSequence(Message f) {
        this.faultSequence(f, true, true);
    }

    public void faultSequence(AxisFault f, boolean postFault, boolean shareFault) {
        HttpOutboundHandler hndlr = this.chooseSequenceHandler();
        boolean normal = f == null;
        this.uncirculateSequence(normal);
        if (!normal) {
            boolean executePost;
            boolean bl = executePost = postFault && this.getSequenceState().getInternalFaultDestination() != null && this.isLocallyHomed();
            if (executePost || shareFault) {
                try {
                    Message m = this.axisFaultToMessage(f);
                    if (executePost) {
                        this.postFaultInternally(m, hndlr);
                    }
                    this.invokeOnSequenceFault(shareFault, m);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (shareFault) {
            RMManager.getRMManager().onSequenceFault(this.getId());
        }
    }

    private Message axisFaultToMessage(AxisFault f) throws Exception {
        SOAPEnvelope envelope = ElementCreator.createSimpleEnvelope(AddressingUtils.getFaultActionURI(), null, this.getSOAPConstants(), this.getConstants());
        SOAPBody sb = (SOAPBody)envelope.getBody();
        SOAPFault ft = (SOAPFault)sb.addFault();
        ft.setFault(f);
        QName[] sc = f.getFaultSubCodes();
        String scode = "";
        if (sc.length > 0) {
            scode = sc[0].getLocalPart();
        }
        SequenceFault.toSequenceFaultHeader(this.getConstants(), envelope, this.getId(), scode);
        Message m = new Message((Object)envelope);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncirculateSequence(boolean normal) {
        int dmqReason = 10;
        String msg = prAccessor.getString("REASON_TERMINATED");
        SortedMap sm = this.getSequenceState().getMessageList();
        Collection se = sm.values();
        SortedMap sortedMap = sm;
        synchronized (sortedMap) {
            for (ReliableMessageWrapper rmc : se) {
                HttpOutboundHandler h = (HttpOutboundHandler)rmc.getMsgContext().getProperty("com.sonicsw.net.http.HttpOutboundHandler");
                IMgram m = this.retrieveIMgram(rmc);
                if (!rmc.getAcknowledged() && normal) {
                    this.ack(m);
                    continue;
                }
                Hashtable<String, String> errorInfo = new Hashtable<String, String>();
                errorInfo.put("JMS_SonicMQ_undeliveredExplanationText", msg);
                try {
                    AgentRegistrar.getAgentRegistrar().getQueueProc().processUndelivered(m, dmqReason, true, errorInfo);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void faultSequence(Message flt, boolean postFault, boolean shareFault) {
        HttpOutboundHandler hndlr = this.chooseSequenceHandler();
        this.uncirculateSequence(false);
        if (postFault && this.getSequenceState().getInternalFaultDestination() != null && this.isLocallyHomed()) {
            this.postFaultInternally(flt, hndlr);
        }
        this.invokeOnSequenceFault(shareFault, flt);
    }

    private void invokeOnSequenceFault(boolean shareFault, Message flt) {
        if (shareFault) {
            RMManager.getRMManager().onSequenceFault(this.getId(), flt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpOutboundHandler chooseSequenceHandler() {
        HttpOutboundHandler hndlr = null;
        SortedMap sm = this.getSequenceState().getMessageList();
        Collection se = sm.values();
        SortedMap sortedMap = sm;
        synchronized (sortedMap) {
            Iterator it = se.iterator();
            if (it.hasNext()) {
                ReliableMessageWrapper rmc = (ReliableMessageWrapper)it.next();
                hndlr = (HttpOutboundHandler)rmc.getMsgContext().getProperty("com.sonicsw.net.http.HttpOutboundHandler");
            }
        }
        return hndlr;
    }

    public void postFaultInternally(Message flt, HttpOutboundHandler prefHndlrParam) {
        HttpOutboundHandler prefHndlr = prefHndlrParam;
        try {
            if (prefHndlr == null) {
                prefHndlr = HandlerUtils.locateHttpRoutingHandler(this.getSequenceState().getEndpointReference().getAddress().toString());
            }
            if (prefHndlr == null) {
                BrokerComponent.getComponentContext().logMessage("Unable to locate a routing definition to fault.", BrokerComponent.getLevelWarning().intValue());
                return;
            }
            WSHttpOutResponse response = new WSHttpOutResponse();
            MessageContext mc = new MessageContext((AxisEngine)new AxisClient());
            mc.setSOAPConstants(this.getSOAPConstants());
            mc.setProperty("addressing.namespace.URI", (Object)this.getWSANS());
            flt.setMessageContext(mc);
            response.setAxisResponse(flt);
            response.setResponseCode(200);
            response.buildResponse(response, null, prefHndlr);
            prefHndlr.processContentReply(response, AddressBinder.destinationToReplyToStr(this.getSequenceState().getInternalFaultDestination()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onAck(ReliableMessageWrapper rmw) {
        IMgram m = this.retrieveIMgram(rmw);
        this.ack(m);
    }

    private IMgram retrieveIMgram(ReliableMessageWrapper rmw) {
        IMgram m = (IMgram)rmw.getMsgContext().getProperty("progress.message.msg.IMgram");
        if (m == null) {
            m = (IMgram)rmw.getMsgContext().getProperty("COM_SONIC_RESPONSEMGRAM");
        }
        return m;
    }

    public void ack(IMgram mgram) {
        IMgram ack = MgramFactory.getMgramFactory().buildAck(0L, (short)0, 0);
        ack.getBrokerHandle().setAckNoReply(true);
        AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(mgram.getGuarenteedTrackingNum());
        if (tracker != null) {
            tracker.acknowledged(ack, true);
        } else {
            boolean deleted = AgentRegistrar.getAgentRegistrar().getQueueMsgSaver().deleteMsg(mgram.getGuarenteedTrackingNum(), mgram.isJMSPersistent());
            if (mgram.isJMSPersistent()) {
                QueueMsgAckedEvt evt = new QueueMsgAckedEvt(mgram.getGuarenteedTrackingNum(), ack, deleted);
                AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service() {
        Iterator messages = null;
        if (this.isMarkedForTermination()) {
            return;
        }
        long inact = 0L;
        long last = 0L;
        RMSequence res = this.getSequenceState();
        RMPolicy p = res.getPolicy();
        if (this.isLocallyHomed()) {
            Date now;
            long now2;
            long delta;
            if (p != null) {
                inact = this.getSequenceState().getPolicy().getInactivityTimeout();
            }
            if (inact > 0L) {
                last = this.getSequenceState().getLastActivity();
            }
            if (inact > 0L && last > 0L && (delta = (now2 = System.currentTimeMillis()) - last) > inact) {
                InactivityTimeoutEvent evt = new InactivityTimeoutEvent();
                evt.setSequence(this);
                this.markForTermination(evt);
                return;
            }
            Date expiryDate = this.getSequenceState().getExpires();
            if (expiryDate != null && (now = new Date()).after(expiryDate)) {
                ExpiresEvent evt = new ExpiresEvent();
                evt.setSequence(this);
                this.markForTermination(evt);
                return;
            }
        }
        if (p == null) {
            return;
        }
        if (com.sonicsw.ws.addressing.AddressingUtils.isAnonymousURI(this.getSequenceState().getEndpointReference().getAddress().toString())) {
            return;
        }
        RMSequence rMSequence = res;
        synchronized (rMSequence) {
            if (res.isAllAcknowledged()) {
                return;
            }
            long now = System.currentTimeMillis();
            long basic = p.getBaseRetransmissionInterval();
            boolean useBackoff = p.getExponentialBackoff();
            long backoffs = useBackoff ? 10L : -1L;
            SortedMap sm = res.getMessageList();
            Collection se = sm.values();
            SortedMap sortedMap = sm;
            synchronized (sortedMap) {
                for (ReliableMessageWrapper rmc : se) {
                    if (rmc.getAcknowledged() || rmc.getEnqueuedForResend() || rmc.getLastSentTime() >= now - RMSendSequence.evaluateBinaryExponentialInterval(basic, backoffs, rmc.getTransmissionCount() - 1L)) continue;
                    RequestResendEvent evt = new RequestResendEvent();
                    evt.setSequence(this);
                    evt.setContext(rmc.getMsgContext());
                    rmc.setEnqueuedForResend(true);
                    this.enqueue(evt, 12);
                }
            }
        }
    }
}

