/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.IClientContext;

public class DurableSubscriptionUtil {
    public static String getJMSClientID(String durAppID) {
        if (!durAppID.startsWith("$DURABLE$")) {
            return null;
        }
        String str = durAppID.substring(9);
        if (str.startsWith("$CC$")) {
            str = str.substring("$CC$".length());
        }
        String jmsClientID = str.substring(0, str.indexOf("$"));
        return jmsClientID;
    }

    public static String getSubscriptionName(String durAppID) {
        if (!durAppID.startsWith("$DURABLE$")) {
            return null;
        }
        String str = durAppID.substring(9);
        if (str.startsWith("$CC$")) {
            str = str.substring("$CC$".length());
        }
        String jmsClientID = str.substring(0, str.indexOf("$"));
        String subNm = str.substring(str.indexOf("$") + 1);
        return subNm;
    }

    public static boolean isConnectionConsumer(String durAppID) {
        return durAppID.startsWith("$DURABLE$$CC$");
    }

    public static String getConnectID(String appID, IClientContext cc) {
        String chan0AppID;
        AgentListener al;
        if (appID == null || appID.indexOf("$DURABLE$") < 0) {
            throw new IllegalArgumentException(appID + " not a durable subscriber appid");
        }
        if (cc == null) {
            throw new IllegalArgumentException("not a valid durable subscriber client context");
        }
        String connectID = null;
        AgentConnection ac = cc.getConnection();
        if (ac != null && (al = ac.getAgentListener()) != null && (chan0AppID = al.getChan0Appid()) != null) {
            connectID = chan0AppID.substring(0, chan0AppID.indexOf("$CONNECTION$"));
        }
        return connectID;
    }
}

