/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

class ReportPublisherBlocked
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    ReportPublisherBlocked(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ReportPublisherBlocked" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session context, Envelope env) {
        try {
            Message msg = env.getMessage();
            long cid = msg.readLong();
            IClientContext client = this.m_reg.getClient(cid);
            int minSendPrio = msg.readInt();
            if (this.DEBUG) {
                this.debug("Processing event from " + cid + " on priority " + minSendPrio);
            }
            client.getPublishLimiter().generateBlockedEvent(minSendPrio);
        }
        catch (EClientNotRegistered msg) {
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }
}

