/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.SubscribeEvt;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Subject;

public class SubscribeEvtForSelector
extends SubscribeEvt {
    private String[] m_messageSelectors;
    private boolean m_isSelectorAtBroker;
    private byte m_durableModification = 0;
    private transient ISubject m_addedSubject;
    private transient ISubject m_removedSubject;
    protected short m_type = (short)113;

    protected SubscribeEvtForSelector(Envelope req, long id, ISubject subject, Label label, String[] messageSelectors, boolean isSelectorAtBroker) {
        super(req, id, subject, label);
        this.m_messageSelectors = messageSelectors;
        this.m_isSelectorAtBroker = isSelectorAtBroker;
    }

    protected SubscribeEvtForSelector(short type) {
        super(type);
    }

    protected String[] getMessageSelectors() {
        return this.m_messageSelectors;
    }

    @Override
    public String getMessageSelector() {
        if (this.m_messageSelectors == null) {
            return "";
        }
        return this.m_messageSelectors[0];
    }

    public void setDurableModification(byte modification) {
        this.m_durableModification = modification;
    }

    public void setAddedSubject(ISubject added) {
        this.m_addedSubject = added;
    }

    public void setRemovedSubject(ISubject removed) {
        this.m_removedSubject = removed;
    }

    @Override
    public ISubject getAddedSubject() {
        return this.m_addedSubject;
    }

    @Override
    public ISubject getRemovedSubject() {
        return this.m_removedSubject;
    }

    @Override
    public byte getDurableModification() {
        return this.m_durableModification;
    }

    protected boolean getSelectorAtBroker() {
        return this.m_isSelectorAtBroker;
    }

    @Override
    public short type() {
        return 113;
    }

    @Override
    protected int memSizeBody() {
        int selectorsLen = 0;
        if (this.m_messageSelectors != null) {
            for (int ii = 0; ii < this.m_messageSelectors.length; ++ii) {
                selectorsLen += this.m_messageSelectors[ii].length();
            }
        }
        return super.memSizeBody() + selectorsLen << 3;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        byte[] utfSelector = null;
        int selectorsLen = 0;
        if (this.m_messageSelectors != null) {
            for (int ii = 0; ii < this.m_messageSelectors.length; ++ii) {
                block4: {
                    try {
                        utfSelector = StringUtil.stringToUTF(this.m_messageSelectors[ii]);
                    }
                    catch (UTFDataFormatException e) {
                        if (!this.DEBUG) break block4;
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                }
                selectorsLen += utfSelector.length;
            }
        }
        int n = 8 + this.getSubject().getSerializedLength();
        this.getLabel();
        return n + Label.length() + 8 + 8 + 8 + 1 + selectorsLen + 1 + 1;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out, false);
    }

    private void writeBody(OutputStream os, boolean tteTTLConvert) throws IOException {
        byte[] utfSelector = null;
        StreamUtil.writeLong(this.getClientId(), os);
        this.getSubject().writeToStream(os);
        if (this.m_messageSelectors != null) {
            StreamUtil.writeInt(this.m_messageSelectors.length, os);
            for (int ii = 0; ii < this.m_messageSelectors.length; ++ii) {
                utfSelector = StringUtil.stringToUTF(this.m_messageSelectors[ii]);
                os.write(utfSelector, 0, utfSelector.length);
            }
        } else {
            StreamUtil.writeInt(0, os);
        }
        StreamUtil.writeBoolean(this.m_isSelectorAtBroker, os);
        this.getLabel().serialize(os, tteTTLConvert);
        StreamUtil.writeLong(this.getCreationTime(), os);
        StreamUtil.writeLong(this.getPreviousBrokerCID(), os);
        StreamUtil.writeLong(this.getRestoreToBrokerCID(), os);
        StreamUtil.writeBoolean(this.getDurableStrictMessageOrder(), os);
        StreamUtil.writeLong(this.getTTE(), os);
        StreamUtil.writeByte(this.m_durableModification, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os, tteTTLConvert);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.setClientId(StreamUtil.readLong(in));
        if (this.m_eventType <= 108) {
            this.setSubject(new Subject(StreamUtil.readUTF(in)));
        } else {
            this.setSubject(Subject.createFromStream(in));
        }
        if (this.m_eventType == 42) {
            this.m_messageSelectors = new String[1];
            this.m_messageSelectors[0] = StreamUtil.readUTF(in);
        } else {
            int numSelectors = StreamUtil.readInt(in);
            if (numSelectors > 0) {
                this.m_messageSelectors = new String[numSelectors];
                for (int ii = 0; ii < numSelectors; ++ii) {
                    this.m_messageSelectors[ii] = StreamUtil.readUTF(in);
                }
            } else {
                this.m_messageSelectors = null;
            }
        }
        this.m_isSelectorAtBroker = StreamUtil.readBoolean(in);
        this.setLabel(Label.unserialize(in, tteTTLConvert));
        if (this.m_eventType >= 60) {
            this.setCreationTime(StreamUtil.readLong(in));
            this.setPreviousBrokerCID(StreamUtil.readLong(in));
            this.setRestoreToBrokerCID(StreamUtil.readLong(in));
        }
        if (this.m_eventType >= 108) {
            this.setDurableStrictMessageOrder(StreamUtil.readBoolean(in));
            this.setTTE(StreamUtil.readLong(in));
        } else {
            this.setDurableStrictMessageOrder(true);
            this.setTTE(-1L);
        }
        if (this.m_eventType > 108) {
            this.m_durableModification = StreamUtil.readByte(in);
        }
        this.setLocalSubscriptionDone(true);
        this.setReplyDone(true);
        this.setSuppressCWADSPropagation(true);
    }
}

