/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.db.EInvalidConfiguration;
import progress.message.dd.NoDupDetectDb;
import progress.message.dd.NoDupDetectDbConnection;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class UpdateChannelTransactionNoDup
implements IMessageHandler {
    private AgentRegistrar m_reg;
    private NoDupDetectDbConnection m_ndConnection = null;

    public UpdateChannelTransactionNoDup(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block13: {
            Message rep = new Message();
            Message req = env.getMessage();
            try {
                String transactionId = req.readUTF();
                long lifespan = req.readLong();
                int channelState = req.readInt();
                String channelID = req.readUTF();
                try {
                    if (NoDupDetectDb.isEnabled()) {
                        int result;
                        if (this.m_ndConnection == null) {
                            this.m_ndConnection = NoDupDetectDb.getConnection();
                        }
                        if ((result = this.m_ndConnection.updateChannelRecord(transactionId, lifespan, channelState, channelID)) == 0) {
                            rep.writeShort(15);
                        } else {
                            rep.writeShort(0);
                        }
                    } else {
                        rep.writeShort(10);
                    }
                }
                catch (EDatabaseException e) {
                    rep.writeShort(8);
                }
                catch (EInvalidConfiguration e) {
                    rep.writeShort(10);
                }
                catch (IllegalArgumentException e) {
                    rep.writeShort(9);
                }
                catch (EGeneralException e) {
                    rep.writeShort(5);
                }
                catch (IOException e) {
                    rep.writeShort(1);
                }
                s.reply(rep, env);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block13;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

