/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import progress.message.broker.mqtt.MqttBrokerConnection;
import progress.message.broker.mqtt.MqttJmsUtils;
import progress.message.broker.mqtt.MqttMessageIdTracker;
import progress.message.broker.mqtt.agent.MqttAgentSession;
import progress.message.broker.mqtt.proto.MessageIdMessage;
import progress.message.broker.mqtt.proto.MqttLastWillTestament;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.MqttSubscription;
import progress.message.broker.mqtt.proto.PubAckMessage;
import progress.message.broker.mqtt.proto.PubCompMessage;
import progress.message.broker.mqtt.proto.PubRecMessage;
import progress.message.broker.mqtt.proto.PubRelMessage;
import progress.message.broker.mqtt.proto.PublishMessage;
import progress.message.zclient.Envelope;

public abstract class MqttSession {
    private final String m_clientId;
    private final MqttMessageIdTracker m_msgIdTracker = new MqttMessageIdTracker();
    private final Object m_pubTrackingLock = new Object();
    private final Map<Integer, PublishMessage> m_pubTracking = new ConcurrentHashMap<Integer, PublishMessage>();
    private MqttBrokerConnection m_connection;

    public MqttSession(String clientId) {
        Objects.requireNonNull(clientId);
        this.m_clientId = clientId;
    }

    public static MqttSession createAgentSession(String clientId) {
        return new MqttAgentSession(clientId);
    }

    public abstract void restore(MqttBrokerConnection var1, String var2, String var3) throws IOException;

    public abstract void connect(MqttBrokerConnection var1, String var2, String var3) throws IOException;

    public abstract MqttQoS subscribe(MqttSubscription var1) throws IOException;

    public abstract void unsubscribe(String var1) throws IOException;

    public abstract void stop();

    public abstract void start();

    public void close(boolean remove) {
        if (remove) {
            this.closeInternal();
        } else {
            this.stop();
        }
    }

    protected void closeInternal() {
        this.clearPubTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPubTracking() {
        Object object = this.m_pubTrackingLock;
        synchronized (object) {
            this.m_pubTracking.clear();
        }
    }

    public void confirmPublish(PubRelMessage relMessage) {
        PublishMessage publishMessage = this.m_pubTracking.get(relMessage.getMessageId());
        if (publishMessage != null) {
            this.publishToSubscribers(publishMessage);
        } else {
            String msg = "Publish tracking not found for MQTT publish rel message = " + relMessage;
            BrokerComponent.getComponentContext().logMessage(msg, 2);
        }
    }

    public void sendLastWillMessage(MqttLastWillTestament lwt) {
        PublishMessage message = lwt.createMessage();
        this.publishToSubscribers(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(PublishMessage message) throws IOException {
        if (message.getMessageId() != null) {
            this.m_msgIdTracker.trackMessageId(message.getMessageId());
        }
        if (message.getQos() == MqttQoS.EXACTLY_ONCE) {
            Object object = this.m_pubTrackingLock;
            synchronized (object) {
                this.m_pubTracking.put(message.getMessageId(), message);
            }
            PubRecMessage pubRecMessage = new PubRecMessage();
            pubRecMessage.setMessageId(message.getMessageId());
            this.m_connection.send(pubRecMessage);
        } else {
            this.publishToSubscribers(message);
        }
    }

    protected abstract void publishToSubscribers(PublishMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackPublish(MessageIdMessage ackMessage) {
        try {
            this.m_connection.send(ackMessage);
            this.m_msgIdTracker.releaseMessageId(ackMessage.getMessageId());
            Object object = this.m_pubTrackingLock;
            synchronized (object) {
                this.m_pubTracking.remove(ackMessage.getMessageId());
            }
        }
        catch (IOException ex) {
            String msg = "Failed to send MQTT publish acknowledge message = " + ackMessage;
            BrokerComponent.getComponentContext().logMessage(msg, (Throwable)ex, 2);
        }
    }

    protected MessageIdMessage createAckPublishMessage(PublishMessage message) {
        MessageIdMessage ackMessage = null;
        if (message.getMessageId() != null) {
            switch (message.getQos()) {
                case AT_LEAST_ONCE: {
                    ackMessage = new PubAckMessage();
                    ackMessage.setMessageId(message.getMessageId());
                    break;
                }
                case EXACTLY_ONCE: {
                    ackMessage = new PubCompMessage();
                    ackMessage.setMessageId(message.getMessageId());
                    break;
                }
                default: {
                    String msg = "Invalid MQTT publish message = " + message;
                    BrokerComponent.getComponentContext().logMessage(msg, 2);
                }
            }
        }
        return ackMessage;
    }

    public void receive(Envelope envelope, MqttQoS qos) {
        PublishMessage message = MqttJmsUtils.createMqttMessage(envelope, qos);
        if (qos == MqttQoS.AT_LEAST_ONCE || qos == MqttQoS.EXACTLY_ONCE) {
            this.trackDelivery(message, envelope);
        } else {
            this.deliveryComplete(envelope);
        }
        this.m_connection.getSender().enqueue(message);
    }

    protected void deliveryComplete(Envelope envelope) {
        envelope.handlerDone(envelope.isGuaranteed());
    }

    protected void trackDelivery(PublishMessage message, Envelope envelope) {
        message.setMessageId(this.m_msgIdTracker.getNextMessageId());
    }

    public void ackDelivery(MessageIdMessage message) throws IOException {
        PubRelMessage pubRelMessage = new PubRelMessage();
        pubRelMessage.setMessageId(message.getMessageId());
        this.m_connection.send(pubRelMessage);
    }

    public void confirmDelivery(MessageIdMessage message) {
        this.m_msgIdTracker.releaseMessageId(message.getMessageId());
    }

    public String getClientId() {
        return this.m_clientId;
    }

    public MqttBrokerConnection getConnection() {
        return this.m_connection;
    }

    public void setConnection(MqttBrokerConnection m_connection) {
        this.m_connection = m_connection;
    }

    public void dropConnection() {
        this.getConnection().close(true);
    }

    public String toString() {
        return "MqttSession " + this.m_clientId;
    }
}

