/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.pubsub;

import com.odi.ClassInfo;
import com.odi.Database;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.Placement;
import com.odi.imp.ObjectReference;
import com.odi.util.OSSmallMap;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import progress.message.broker.MgramSerializer;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.dbsc.pse.pc.PSEByteArrayWrapper;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessage;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.util.server.ByteBufferInputStream;
import progress.message.zclient.EMgramFormatError;

public class PSEMessage
implements IPSEMessage,
IPersistent,
IPersistentHooks {
    private long _MessageId;
    private long _SequenceNumber;
    private int _MessageSize;
    private long _Expiration;
    private String _JMSMessageId;
    private PSEByteArrayWrapper _MessageBody;
    private OSSmallMap _RecipientIds;
    private transient boolean deleted;
    protected transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = PSEMessage.getClassInfoInstance();

    public PSEMessage(long mid, long seq, int size, Date exp, String jmsId, byte[] msgBody) {
        this._MessageId = mid;
        this._SequenceNumber = seq;
        this._MessageSize = size;
        if (jmsId != null) {
            this._JMSMessageId = new String(jmsId);
        }
        this._Expiration = exp == null ? PSEBrokerDb.PSE_NULL_DATE : exp.getTime();
        if (msgBody != null) {
            this._MessageBody = new PSEByteArrayWrapper(msgBody);
        }
    }

    @Override
    public boolean isExpired(long time) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._Expiration == PSEBrokerDb.PSE_NULL_DATE) {
            return false;
        }
        return this._Expiration < time;
    }

    @Override
    public boolean addRecipient(long id) {
        Long lid;
        Long recip;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        boolean added = false;
        if (this._RecipientIds == null) {
            PSEMessage pSEMessage;
            if (((pSEMessage = this).ODIObjectState & 2) != 0) {
                pSEMessage = pSEMessage;
                ObjectStore.dirty((IPersistent)pSEMessage);
            }
            pSEMessage._RecipientIds = new OSSmallMap();
        }
        if ((recip = (Long)this._RecipientIds.get((Object)(lid = new Long(id)))) == null) {
            this._RecipientIds.put((Object)lid, (Object)lid);
            added = true;
        }
        return added;
    }

    @Override
    public boolean removeRecipient(long id) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._RecipientIds == null) {
            return false;
        }
        boolean removed = false;
        Long key = new Long(id);
        Long valueObj = (Long)this._RecipientIds.get((Object)key);
        if (valueObj != null) {
            this._RecipientIds.remove((Object)key);
            this.destroyObjectStore(valueObj);
            removed = true;
            if (!this.hasRecipients()) {
                PSEMessage pSEMessage;
                ObjectStore.destroy((IPersistent)this._RecipientIds);
                if (((pSEMessage = this).ODIObjectState & 2) != 0) {
                    pSEMessage = pSEMessage;
                    ObjectStore.dirty((IPersistent)pSEMessage);
                }
                pSEMessage._RecipientIds = null;
            }
        }
        return removed;
    }

    @Override
    public int removeAllRecipients() {
        PSEMessage pSEMessage;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        int uncommittedCount = 0;
        if (this._RecipientIds != null && ObjectStore.isPersistent((IPersistent)this._RecipientIds) && !ObjectStore.isDestroyed((Object)this._RecipientIds)) {
            if (!this._RecipientIds.isEmpty()) {
                Iterator ids = this._RecipientIds.values().iterator();
                while (ids.hasNext()) {
                    Long id = (Long)ids.next();
                    ids.remove();
                    this.destroyObjectStore(id);
                    ++uncommittedCount;
                }
            }
            ObjectStore.destroy((IPersistent)this._RecipientIds);
        }
        if (((pSEMessage = this).ODIObjectState & 2) != 0) {
            pSEMessage = pSEMessage;
            ObjectStore.dirty((IPersistent)pSEMessage);
        }
        pSEMessage._RecipientIds = null;
        return uncommittedCount;
    }

    private void destroyObjectStore(Long id) {
        if (!ObjectStore.isDestroyed((Object)id)) {
            ObjectStore.destroy((Object)id);
        }
    }

    @Override
    public long getMessageId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageId;
    }

    @Override
    public long getSequenceNumber() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._SequenceNumber;
    }

    @Override
    public int getMessageSize() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageSize;
    }

    @Override
    public Date getExpiration() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._Expiration == PSEBrokerDb.PSE_NULL_DATE) {
            return null;
        }
        return new Date(this._Expiration);
    }

    @Override
    public String getJMSMessageId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._JMSMessageId;
    }

    @Override
    public Iterator getRecipients() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._RecipientIds == null) {
            return null;
        }
        return this._RecipientIds.values().iterator();
    }

    @Override
    public long[] getRecipsArray() {
        long[] lArray = null;
        int size = this.getRecipientCount();
        long[] result = new long[size];
        Iterator it = this.getRecipients();
        int i = 0;
        while (it != null && it.hasNext()) {
            long[] lArray2 = result;
            if (result != lArray) {
                ObjectStore.dirty((Object)lArray2);
                lArray2 = lArray = lArray2;
            }
            lArray2[i] = (Long)it.next();
            ++i;
        }
        return result;
    }

    @Override
    public boolean hasBody() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageBody != null;
    }

    @Override
    public boolean hasJMSMessageId() {
        return this.getJMSMessageId() != null;
    }

    @Override
    public boolean hasRecipients() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._RecipientIds == null) {
            return false;
        }
        return !this._RecipientIds.isEmpty();
    }

    @Override
    public int getRecipientCount() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._RecipientIds == null) {
            return 0;
        }
        return this._RecipientIds.size();
    }

    @Override
    public synchronized IMgram getMgram() {
        if (this.deleted) {
            return null;
        }
        if (ObjectStore.isDestroyed((Object)this)) {
            return null;
        }
        return this.getMgramInternal();
    }

    private IMgram getMgramInternal() {
        byte[] body;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        IMgram mgram = null;
        if (this._MessageBody == null) {
            new EAssertFailure("PSEMessage.getMgramInternal: _MessageBody is null; mid= " + this._MessageId + " ctrecips= " + this.getRecipientCount()).printStackTrace();
            return null;
        }
        byte[] byArray = body = this._MessageBody.getBytes();
        if (body != null) {
            byArray = byArray;
            ObjectStore.fetch((byte[])byArray);
        }
        ByteBufferInputStream bis = new ByteBufferInputStream(byArray);
        try {
            mgram = MgramSerializer.getMgramSerializer().unserialize(bis, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EMgramFormatError ex) {
            ex.printStackTrace();
        }
        ObjectStore.evict((Object)this._MessageBody, (int)2);
        return mgram;
    }

    @Override
    public boolean setMessageBodyIfNull(byte[] msgBody) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        boolean added = false;
        if (msgBody != null && this._MessageBody == null) {
            PSEMessage pSEMessage;
            if (((pSEMessage = this).ODIObjectState & 2) != 0) {
                pSEMessage = pSEMessage;
                ObjectStore.dirty((IPersistent)pSEMessage);
            }
            pSEMessage._MessageBody = new PSEByteArrayWrapper(msgBody);
            added = true;
        }
        return added;
    }

    @Override
    public void setJMSMessageId(String jmsId) {
        PSEMessage pSEMessage;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String oldS = this._JMSMessageId;
        String newS = jmsId;
        if (oldS != null) {
            if (oldS.equals(newS)) {
                return;
            }
            ObjectStore.destroy((Object)oldS);
        }
        if (((pSEMessage = this).ODIObjectState & 2) != 0) {
            pSEMessage = pSEMessage;
            ObjectStore.dirty((IPersistent)pSEMessage);
        }
        pSEMessage._JMSMessageId = new String(jmsId);
    }

    public void preFlushContents() {
        if (!ObjectStore.isPersistent((Object)this)) {
            return;
        }
        if (this._MessageBody != null && !ObjectStore.isPersistent((Object)this._MessageBody)) {
            ObjectStore.migrate((Object)this._MessageBody, (Placement)Database.of((Object)this), (boolean)false);
        }
        if (this._MessageBody != null) {
            ObjectStore.evict((Object)this._MessageBody, (int)2);
        }
    }

    public synchronized void preDestroyPersistent() {
        PSEMessage pSEMessage;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._RecipientIds != null && !this._RecipientIds.isEmpty()) {
            new EAssertFailure("Destroying message that has recipients; id= " + this._MessageId + " CountRecips= " + this._RecipientIds.size()).printStackTrace();
        }
        ObjectStore.destroy((IPersistent)this._RecipientIds);
        ObjectStore.destroy((Object)this._MessageBody);
        ObjectStore.destroy((Object)this._JMSMessageId);
        this.deleted = true;
        if (((pSEMessage = this).ODIObjectState & 2) != 0) {
            pSEMessage = pSEMessage;
            ObjectStore.dirty((IPersistent)pSEMessage);
        }
        pSEMessage._MessageBody = null;
        this._JMSMessageId = null;
        this._RecipientIds = null;
    }

    @Override
    public Date getTimestamp() {
        return null;
    }

    @Override
    public String toStringAll() {
        StringBuffer buf = new StringBuffer("PSEMessage: ");
        buf.append("\tMid: " + this.getMessageId());
        buf.append("\tSeq: " + this.getSequenceNumber());
        buf.append("\tSize: " + this.getMessageSize());
        buf.append("\tExp: " + this.getExpiration());
        buf.append("\tExp: " + this.getTimestamp());
        buf.append("\tJMSId: " + this.getJMSMessageId());
        buf.append("\thasBody: " + this.hasBody());
        buf.append("\tcountRecips: " + this.getRecipientCount());
        return buf.toString();
    }

    public String toString() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return "PSEMessage: mid= " + this._MessageId + " size= " + this._MessageSize;
    }

    @Override
    public void setMessageBodyNullNoDestroy() {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._MessageBody = null;
    }

    @Override
    public PSEByteArrayWrapper getMessageBody() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageBody;
    }

    @Override
    public void setMessageBody(PSEByteArrayWrapper m) {
        PSEMessage pSEMessage;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._MessageBody != null) {
            new EAssertFailure("PSEMessage.setMessageBody: existing message body is not null").printStackTrace();
        }
        if (((pSEMessage = this).ODIObjectState & 2) != 0) {
            pSEMessage = pSEMessage;
            ObjectStore.dirty((IPersistent)pSEMessage);
        }
        pSEMessage._MessageBody = m;
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSEMessage)super.clone()).ODIref = null;
        ((PSEMessage)super.clone()).ODIObjectState = 0;
        return (PSEMessage)super.clone();
    }

    public void postInitializeContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._MessageId = genericObject.getLongField(1, classInfo);
        this._SequenceNumber = genericObject.getLongField(2, classInfo);
        this._MessageSize = genericObject.getIntField(3, classInfo);
        this._Expiration = genericObject.getLongField(4, classInfo);
        this._JMSMessageId = genericObject.getStringField(5, classInfo);
        this._MessageBody = (PSEByteArrayWrapper)genericObject.getClassField(6, classInfo);
        this._RecipientIds = (OSSmallMap)genericObject.getClassField(7, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setLongField(1, this._MessageId, classInfo);
        genericObject.setLongField(2, this._SequenceNumber, classInfo);
        genericObject.setIntField(3, this._MessageSize, classInfo);
        genericObject.setLongField(4, this._Expiration, classInfo);
        genericObject.setStringField(5, this._JMSMessageId, classInfo);
        genericObject.setClassField(6, (Object)this._MessageBody, classInfo);
        genericObject.setClassField(7, (Object)this._RecipientIds, classInfo);
    }

    public void clearContents() {
        this._MessageId = 0L;
        this._SequenceNumber = 0L;
        this._MessageSize = 0;
        this._Expiration = 0L;
        this._JMSMessageId = null;
        this._MessageBody = null;
        this._RecipientIds = null;
    }

    public PSEMessage(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        return ClassInfo.get(PSEMessage.class);
    }
}

