/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.reg;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.util.OSVector;
import java.util.Collection;
import java.util.Iterator;
import progress.message.dbsc.pse.pc.PSEByteArrayWrapper;
import progress.message.dbsc.pse.pc.reg.IPSESubscription;

public class PSEClient
implements IPersistent,
IPersistentHooks {
    private long _ClientId;
    private String _UserId;
    private String _AppId;
    private boolean _Interbroker;
    private long _LastConnectedTime;
    private PSEByteArrayWrapper _SecContext;
    private Collection _Subscriptions;
    protected transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = PSEClient.getClassInfoInstance();

    public PSEClient(long client_id) {
        this._ClientId = client_id;
        this._UserId = null;
        this._AppId = null;
        this._Interbroker = false;
        this._LastConnectedTime = 0L;
        this._SecContext = null;
        this._Subscriptions = null;
    }

    public long getClientId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._ClientId;
    }

    public String getUserId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._UserId;
    }

    public String getAppId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._AppId;
    }

    public boolean getInterbroker() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Interbroker;
    }

    public long getLastConnectedTime() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._LastConnectedTime;
    }

    public byte[] getSecContext() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._SecContext.getBytes();
    }

    public Collection getSubscriptions() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Subscriptions;
    }

    public void setUserId(String id) {
        PSEClient pSEClient;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String oldS = this._UserId;
        String newS = id;
        if (oldS != null) {
            if (oldS.equals(newS)) {
                return;
            }
            ObjectStore.destroy((Object)oldS);
        }
        if (((pSEClient = this).ODIObjectState & 2) != 0) {
            pSEClient = pSEClient;
            ObjectStore.dirty((IPersistent)pSEClient);
        }
        pSEClient._UserId = new String(id);
    }

    public void setAppId(String id) {
        PSEClient pSEClient;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String oldS = this._AppId;
        String newS = id;
        if (oldS != null) {
            if (oldS.equals(newS)) {
                return;
            }
            ObjectStore.destroy((Object)oldS);
        }
        if (((pSEClient = this).ODIObjectState & 2) != 0) {
            pSEClient = pSEClient;
            ObjectStore.dirty((IPersistent)pSEClient);
        }
        pSEClient._AppId = new String(id);
    }

    public void setInterbroker(boolean flag) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._Interbroker = flag;
    }

    public void setLastConnectedTime(long tm) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._LastConnectedTime = tm;
    }

    public void setSecContext(byte[] bytes) {
        PSEClient pSEClient;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._SecContext != null) {
            ObjectStore.destroy((Object)this._SecContext);
        }
        if (((pSEClient = this).ODIObjectState & 2) != 0) {
            pSEClient = pSEClient;
            ObjectStore.dirty((IPersistent)pSEClient);
        }
        pSEClient._SecContext = new PSEByteArrayWrapper(bytes);
    }

    public void addSubscription(IPSESubscription sub) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._Subscriptions == null) {
            PSEClient pSEClient;
            if (((pSEClient = this).ODIObjectState & 2) != 0) {
                pSEClient = pSEClient;
                ObjectStore.dirty((IPersistent)pSEClient);
            }
            pSEClient._Subscriptions = new OSVector();
        }
        this._Subscriptions.add(sub);
    }

    public void removeAllSubscriptions() {
        PSEClient pSEClient;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._Subscriptions == null) {
            return;
        }
        Iterator iter = this._Subscriptions.iterator();
        while (iter.hasNext()) {
            IPSESubscription sub = (IPSESubscription)iter.next();
            iter.remove();
            ObjectStore.destroy((Object)sub);
        }
        ObjectStore.destroy((Object)this._Subscriptions);
        if (((pSEClient = this).ODIObjectState & 2) != 0) {
            pSEClient = pSEClient;
            ObjectStore.dirty((IPersistent)pSEClient);
        }
        pSEClient._Subscriptions = null;
    }

    public void preDestroyPersistent() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._UserId != null) {
            PSEClient pSEClient;
            ObjectStore.destroy((Object)this._UserId);
            if (((pSEClient = this).ODIObjectState & 2) != 0) {
                pSEClient = pSEClient;
                ObjectStore.dirty((IPersistent)pSEClient);
            }
            pSEClient._UserId = null;
        }
        if (this._AppId != null) {
            PSEClient pSEClient;
            ObjectStore.destroy((Object)this._AppId);
            if (((pSEClient = this).ODIObjectState & 2) != 0) {
                pSEClient = pSEClient;
                ObjectStore.dirty((IPersistent)pSEClient);
            }
            pSEClient._AppId = null;
        }
        if (this._SecContext != null) {
            PSEClient pSEClient;
            ObjectStore.destroy((Object)this._SecContext);
            if (((pSEClient = this).ODIObjectState & 2) != 0) {
                pSEClient = pSEClient;
                ObjectStore.dirty((IPersistent)pSEClient);
            }
            pSEClient._SecContext = null;
        }
        this.removeAllSubscriptions();
    }

    public String toStringAll() {
        StringBuffer buf = new StringBuffer("PSEClient: ");
        buf.append("\tClientId: " + this.getClientId());
        buf.append("\tUserId: " + this.getUserId());
        buf.append("\tAppId: " + this.getAppId());
        buf.append("\n\tInterbroker: " + this.getInterbroker());
        buf.append("\tLastConnectedTime: " + this.getLastConnectedTime());
        buf.append("\tSecContext: " + (this.getSecContext() == null ? null : "Size= " + this.getSecContext().length));
        buf.append("\tCountSubscriptions: " + (this.getSubscriptions() == null ? null : "" + this.getSubscriptions().size()));
        return buf.toString();
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSEClient)super.clone()).ODIref = null;
        ((PSEClient)super.clone()).ODIObjectState = 0;
        return (PSEClient)super.clone();
    }

    public void postInitializeContents() {
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._ClientId = genericObject.getLongField(1, classInfo);
        this._UserId = genericObject.getStringField(2, classInfo);
        this._AppId = genericObject.getStringField(3, classInfo);
        this._Interbroker = genericObject.getBooleanField(4, classInfo);
        this._LastConnectedTime = genericObject.getLongField(5, classInfo);
        this._SecContext = (PSEByteArrayWrapper)genericObject.getClassField(6, classInfo);
        this._Subscriptions = (Collection)genericObject.getInterfaceField(7, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setLongField(1, this._ClientId, classInfo);
        genericObject.setStringField(2, this._UserId, classInfo);
        genericObject.setStringField(3, this._AppId, classInfo);
        genericObject.setBooleanField(4, this._Interbroker, classInfo);
        genericObject.setLongField(5, this._LastConnectedTime, classInfo);
        genericObject.setClassField(6, (Object)this._SecContext, classInfo);
        genericObject.setInterfaceField(7, (Object)this._Subscriptions, classInfo);
    }

    public void clearContents() {
        this._ClientId = 0L;
        this._UserId = null;
        this._AppId = null;
        this._Interbroker = false;
        this._LastConnectedTime = 0L;
        this._SecContext = null;
        this._Subscriptions = null;
    }

    public PSEClient(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        return ClassInfo.get(PSEClient.class);
    }
}

