/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient.xa;

import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import progress.message.jclient.AbstractJMSContext;
import progress.message.jclient.JMSExceptionUtils;

public class XAJMSContext
extends AbstractJMSContext
implements javax.jms.XAJMSContext {
    private XAConnection xaConnection;
    private XASession xaSession;
    private Session session;

    public XAJMSContext(XAConnection connection, int sessionMode) {
        super(sessionMode);
        this.xaConnection = connection;
    }

    @Override
    public JMSContext createContext(int sessionMode) {
        return new XAJMSContext(this.xaConnection, sessionMode);
    }

    @Override
    protected XAConnection getConnection() {
        return this.xaConnection;
    }

    @Override
    protected Session getSession() {
        return this.session;
    }

    @Override
    public JMSContext getContext() {
        return this;
    }

    @Override
    protected void checkSession() {
        if (this.closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
        if (this.xaSession == null) {
            try {
                this.xaSession = this.xaConnection.createXASession();
                this.session = this.xaSession.getSession();
            }
            catch (JMSException e) {
                throw JMSExceptionUtils.convertToRuntimeException(e);
            }
        }
    }

    @Override
    public XAResource getXAResource() {
        this.checkSession();
        return this.xaSession.getXAResource();
    }
}

