/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import javax.jms.JMSException;
import javax.jms.JMSSecurityException;

public class JMSExceptionUtil {
    public static final JMSException createJMSException(Exception anException) {
        JMSException jmse = new JMSException(anException.getMessage());
        jmse.setLinkedException(anException);
        jmse.initCause(anException);
        return jmse;
    }

    public static final JMSException createJMSException(String reason, Exception anException) {
        JMSException jmse = new JMSException(reason);
        return JMSExceptionUtil.populateLinkedExceptionAndCause(anException, jmse);
    }

    public static final JMSException createJMSException(String reason, String errorCode, Exception anException) {
        JMSException jmse = new JMSException(reason, errorCode);
        return JMSExceptionUtil.populateLinkedExceptionAndCause(anException, jmse);
    }

    public static final JMSSecurityException createJMSSecurityException(Exception anException) {
        String msg = "";
        if (anException != null) {
            msg = anException.getMessage();
        }
        return JMSExceptionUtil.createJMSSecurityException(msg, anException);
    }

    public static final JMSSecurityException createJMSSecurityException(String reason, Exception anException) {
        return JMSExceptionUtil.createJMSSecurityException(reason, -1, anException);
    }

    public static final JMSSecurityException createJMSSecurityException(String reason, int errorCode, Exception anException) {
        JMSSecurityException jmse = new JMSSecurityException(reason, Integer.toString(errorCode));
        return JMSExceptionUtil.populateLinkedExceptionAndCause(anException, jmse);
    }

    private static <T0 extends JMSException> T0 populateLinkedExceptionAndCause(Exception anException, T0 jmse) {
        if (anException != null) {
            jmse.setLinkedException(anException);
            jmse.initCause(anException);
        }
        return jmse;
    }
}

