/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.ServerSession;
import javax.jms.TransactionRolledBackException;
import org.w3c.dom.Document;
import progress.message.client.EAlreadyConnected;
import progress.message.client.EAlreadyInTransaction;
import progress.message.client.EAnonymousConnectionDisallowed;
import progress.message.client.EChannelTransactionFailure;
import progress.message.client.EClientNotRegistered;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EDefaultHandlerNotSet;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidUserId;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENoSubscribersFound;
import progress.message.client.ENotConnected;
import progress.message.client.ENotInTransaction;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ESubjectNotSet;
import progress.message.client.ETimeout;
import progress.message.client.ETransactionFailure;
import progress.message.client.ETransactionRollbackByBroker;
import progress.message.client.EUnauthorizedHttpNode;
import progress.message.client.EUnauthorizedOverrideDestination;
import progress.message.client.EUnknownTransaction;
import progress.message.client.EUnusableConnection;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.prAccessor;
import progress.message.jclient.ChannelActiveException;
import progress.message.jclient.Constants;
import progress.message.jclient.DestinationFactory;
import progress.message.jclient.JMSAsynchronousDeliveryException;
import progress.message.jclient.JMSSendTimeoutException;
import progress.message.jclient.MultiDestination;
import progress.message.jclient.MultipartMessage;
import progress.message.jclient.XMLMessage;
import progress.message.jimpl.BytesMessage;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.Destination;
import progress.message.jimpl.DurableSubscriber;
import progress.message.jimpl.EventHandler;
import progress.message.jimpl.IAfterDeliveryListener;
import progress.message.jimpl.IBeforeDeliveryListener;
import progress.message.jimpl.IConnectionConsumer;
import progress.message.jimpl.IServerSessionReleaseListener;
import progress.message.jimpl.IXMessageFactory;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Lock;
import progress.message.jimpl.MapMessage;
import progress.message.jimpl.Message;
import progress.message.jimpl.MessageConsumer;
import progress.message.jimpl.MessageProducer;
import progress.message.jimpl.MultiTopic;
import progress.message.jimpl.ObjectMessage;
import progress.message.jimpl.QueueBrowser;
import progress.message.jimpl.QueueReceiver;
import progress.message.jimpl.QueueSender;
import progress.message.jimpl.QueueSession;
import progress.message.jimpl.SessionAcknowledgeProcessor;
import progress.message.jimpl.SessionAcknowledgeQueue;
import progress.message.jimpl.SessionCloseEvent;
import progress.message.jimpl.StreamMessage;
import progress.message.jimpl.TemporaryQueue;
import progress.message.jimpl.TemporaryTopic;
import progress.message.jimpl.TextMessage;
import progress.message.jimpl.Topic;
import progress.message.jimpl.TopicPublisher;
import progress.message.jimpl.TopicSession;
import progress.message.jimpl.TopicSubscriber;
import progress.message.jimpl.UnacknowledgedMessagesQueue;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.jclient.SharedSubscriptionUtil;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EConnectionClosing;
import progress.message.zclient.EFlowControlException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobCompletionListener;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.IRejectionListener;
import progress.message.zclient.Job;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Publication;
import progress.message.zclient.RejectionTracker;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subscription;

public class Session
extends DebugObject
implements progress.message.jclient.Session,
IJobCompletionListener,
IRejectionListener {
    private static final String XMESSAGE_FACTORY_CLASS = "progress.message.jimpl.xmessage.XMessageFactory";
    private static final int SEND_TIMEOUT_MINIMUM = 100;
    private static final String QUESTION_MARKS = "???";
    private static final String NOT_AUTH_DEST = "NOT_AUTH_DEST";
    private static final String NOT_AUTH_HTTP_NODE_URL = "NOT_AUTH_HTTP_NODE_URL";
    private static final String ERROR_MAPPING_JMSEXCEPTION = "Error maping JMSException: ";
    private static final String BECAUSE_MESSAGE_PROPERTY_ACCESS_GENERATED = " because Message property access generated: ";
    private static final String DELIVERY_TIMEOUT_ON_CLOSE = "DELIVERY_TIMEOUT_ON_CLOSE";
    private static final String NOT_AUTH_SEND = "NOT_AUTH_SEND";
    private static final String NOT_AUTH_PUBLISH = "NOT_AUTH_PUBLISH";
    private static final String SESSION_CLOSED_TXN_TIMEOUT = "SESSION_CLOSED_TXN_TIMEOUT";
    private static final int QUEUE_NOT_FOUND = 3005;
    private static final int MESSAGE_TOO_BIG_FOR_QUEUE = 3004;
    private static final int PERSISTENT_STORE_ERROR_2500 = 2500;
    private static final int PERSISTENT_STORE_ERROR_2501 = 2501;
    private static final int NO_ROOM_IN_DB = 3006;
    private static final int INVALID_DESTINATION = 2505;
    private static final String NO_MESSAGE_SELECTOR = null;
    private static final String METHOD_NAME_CREATE_SHARED_DURABLE_CONSUMER = "createSharedDurableConsumer";
    Connection m_jconnection = null;
    progress.message.zclient.Connection m_zconnection = null;
    MessageHandler m_zmessageHandler = null;
    private IMessageHandler m_defaultIHandler = null;
    int m_deliveryMode = 0;
    SessionThread m_thread = null;
    String m_name = null;
    Vector m_consumers = new Vector();
    Vector m_producers = new Vector();
    Vector m_browsers = new Vector();
    Hashtable m_durableSubscribers = new Hashtable();
    private boolean m_deliveryStarted = false;
    String m_clientId;
    static final int DONTKNOW = 0;
    static final int SYNC = 1;
    static final int ASYNC = 2;
    static final int ASYNC_CC = 3;
    int m_ackMode;
    int m_ackMode_original;
    boolean m_transacted;
    boolean m_transacted_original;
    protected volatile boolean m_internalClose = false;
    protected progress.message.zclient.Session m_ackSession = null;
    private boolean m_defaultToPersistentDelivery = false;
    int m_rxMsgCnt = 0;
    int numCalls = 0;
    int numWaits = 0;
    private volatile boolean m_closing = false;
    private volatile boolean m_closed = false;
    private volatile boolean m_stopped = false;
    private final Object m_msgCntLock = new Object();
    private UnacknowledgedMessagesQueue m_ackQueue;
    private UnacknowledgedMessagesQueue m_ackQueue_original = this.m_ackQueue = new UnacknowledgedMessagesQueue();
    private progress.message.zclient.Session m_ackSession_original = null;
    private boolean associatedToGT = false;
    private Vector eventHandlerList = null;
    private boolean m_getFromXASession = false;
    private boolean asyncAckNotPermittedForDeliveredMsg = false;
    private final Object m_closeSyncObject = new Object();
    private boolean m_deliveringMessage = false;
    private boolean m_sendingMessage = false;
    private final Lock m_stateLock = new Lock(this.m_closeSyncObject);
    Message deliveredMsg = null;
    private ClientAcknowledgedMessageHolder m_clientAckdMsg = new ClientAcknowledgedMessageHolder();
    MessageListener m_jlistener = null;
    ServerSession m_serverSession = null;
    IBeforeDeliveryListener m_beforeDeliveryListener = null;
    IAfterDeliveryListener m_afterDeliveryListener = null;
    boolean m_useInternalThreadForCCDelivery = false;
    IServerSessionReleaseListener m_serverSessionReleaseListener = null;
    IConnectionConsumer m_cc = null;
    IConnectionConsumer m_lastcc = null;
    Thread m_ccThread = null;
    private boolean m_threadExited = false;
    protected boolean m_waitingForDeliveryThread = false;
    private int m_txnBatchSize = 0;
    private HashMap m_batchTable;
    private int m_batchSize = 0;
    private int m_batchCount = 0;
    private boolean m_batchTableHasMultiTopic = false;
    private boolean m_AckListEnabled = true;
    private SessionAcknowledgeProcessor m_sap = null;
    private SessionAcknowledgeQueue m_acknowledgeQueue = null;
    private boolean m_sessionDurableMessageOrder = false;
    private boolean m_useDurableMessageOrderSetting = false;
    private int m_flowToDisk = 0;
    private int m_sendTimeoutMs = 0;
    private boolean m_splitMultiTopicDelivery;
    private boolean m_rethrowCCRuntimeExceptions;
    private final int m_asyncDeliveryMode;
    private final int m_deliveryDoubtWindow;
    private final boolean m_trackDeliveryDoubt;
    private final HashSet m_inDoubtDeliveries;
    private final long m_deliveryCloseTimeout;
    private final boolean m_rejectableSupported;
    private boolean m_AckDelayedInXATxn = false;
    private boolean m_enforceLocallyTransactedOnXAEnlistment = false;

    public Session(Connection connection, boolean transacted, int acknowledgeMode, String sessionName) throws JMSException {
        super(DebugState.GLOBAL_DEBUG_ON ? "jimpl.Session" : null);
        if (transacted) {
            connection.checkPersistence("Transacted Session");
        }
        this.m_transacted = transacted;
        this.m_ackMode = acknowledgeMode;
        this.m_jconnection = connection;
        this.m_defaultToPersistentDelivery = connection.isDefaultToPersistentDelivery();
        this.m_rejectableSupported = this.m_jconnection.getBrokerSessionVer() >= 30;
        this.m_clientId = this.m_jconnection.getClientID();
        this.m_asyncDeliveryMode = this.m_jconnection.getAsyncDeliveryMode();
        this.m_deliveryCloseTimeout = this.m_jconnection.getDeliveryCloseTimeout();
        this.m_deliveryDoubtWindow = this.m_jconnection.getDeliveryDoubtWindow();
        if (this.m_deliveryDoubtWindow > 0 && !transacted) {
            this.m_trackDeliveryDoubt = true;
            this.m_inDoubtDeliveries = new HashSet();
        } else {
            this.m_inDoubtDeliveries = null;
            this.m_trackDeliveryDoubt = false;
        }
        if (this.m_transacted) {
            this.m_ackMode = 1;
            this.setTxnBatchSize(this.m_jconnection.getDefaultTxnBatchSize());
        } else if (this.m_ackMode != 1 && this.m_ackMode != 2 && this.m_ackMode != 3 && this.m_ackMode != 1004) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("INVALID_ACKMODE"), null);
        }
        this.setFlowToDisk(this.m_jconnection.getFlowToDisk());
        this.setSplitMultiTopicDelivery(this.m_jconnection.getSplitMultiTopicDelivery());
        this.m_rethrowCCRuntimeExceptions = this.m_jconnection.getRethrowCCRuntimeExceptions();
        this.m_ackMode_original = this.m_ackMode;
        this.m_transacted_original = this.m_transacted;
        try {
            this.m_defaultIHandler = new DefaultIHandler();
            this.m_zmessageHandler = !this.m_transacted ? new MessageHandler(this.m_defaultIHandler, true, true) : new MessageHandler(this.m_defaultIHandler, true, false);
            this.m_zmessageHandler.setName("Session default handler");
            this.m_zmessageHandler.setGuaranteed(true);
            String string = sessionName = sessionName == null ? SessionConfig.JMS_SESSION_NAME_DEFAULT : sessionName;
            if (sessionName != null && sessionName.length() == 0) {
                sessionName = null;
            }
            if (sessionName != null && (sessionName.indexOf("#") != -1 || sessionName.indexOf("*") != -1 || sessionName.indexOf("$") != -1 || sessionName.indexOf(".") != -1)) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("SESS_INVALID_NAME") + sessionName, null);
            }
            this.m_name = sessionName;
            String baseAppId = this.m_name == null ? "$SESSION$" : "$SESSION$" + this.m_name + '$';
            this.m_zconnection = this.m_jconnection.getZConnectionFactory().createZConnection(baseAppId, null, this.m_zmessageHandler, true, this.m_jconnection.getRejectionProcessor());
            this.m_zconnection.setAckMode(Session.j2zAckMode(this.m_ackMode, this.m_transacted));
            this.m_zconnection.setRejectionListener(this);
            this.m_zconnection.setDeliveryCloseTimeout(this.m_deliveryCloseTimeout);
            this.m_zconnection.setReturnDbLimitExceptions(2);
            this.m_jconnection.addZConnection(this.m_zconnection);
            long parentID = this.m_jconnection.m_zconnection.getClientId();
            this.m_zconnection.connect(this.m_jconnection.m_zconnection, parentID);
            this.m_ackSession_original = this.m_ackSession = this.m_zmessageHandler.getSession();
            connection.addJMSSession(this);
            if (this.m_transacted) {
                this.m_ackSession.beginWork();
            }
        }
        catch (EUnusableConnection euc) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(euc);
        }
        catch (EParameterIsNull epin) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(epin);
        }
        catch (EAlreadyConnected e) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EAnonymousConnectionDisallowed e) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EConnectionLimitExceeded e) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e.getMessage(), "-26", e);
        }
        catch (EUserAlreadyConnected e) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENoSubscribersFound e) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException ege) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(ege);
        }
    }

    public static short j2zAckMode(int jmode, boolean transacted) {
        if (transacted) {
            return 6;
        }
        switch (jmode) {
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 1004: {
                return 5;
            }
        }
        return 0;
    }

    public short getZAckMode() {
        return this.m_zconnection.getAckMode();
    }

    public void setBeforeDeliveryListener(IBeforeDeliveryListener ibdl) {
        this.m_beforeDeliveryListener = ibdl;
    }

    public IBeforeDeliveryListener getBeforeDeliveryListener() {
        return this.m_beforeDeliveryListener;
    }

    public void setAfterDeliveryListener(IAfterDeliveryListener iadl) {
        this.m_afterDeliveryListener = iadl;
    }

    public IAfterDeliveryListener getAfterDeliveryListener() {
        return this.m_afterDeliveryListener;
    }

    public void setServerSessionReleaseListener(IServerSessionReleaseListener isrl) {
        this.m_serverSessionReleaseListener = isrl;
    }

    public IServerSessionReleaseListener getServerSessionReleaseListener() {
        return this.m_serverSessionReleaseListener;
    }

    public void setUseInternalThreadForCCDelivery(boolean value) {
        this.m_useInternalThreadForCCDelivery = value;
    }

    public boolean getUseInternalThreadForCCDelivery() {
        return this.m_useInternalThreadForCCDelivery;
    }

    protected Session(Connection connection, boolean transacted, int acknowledgeMode, boolean fromXASession, String sessionName) throws JMSException {
        this(connection, transacted, acknowledgeMode, sessionName);
        this.m_getFromXASession = fromXASession;
    }

    public void setFromXASession(boolean fromXASession) {
        this.m_getFromXASession = fromXASession;
    }

    boolean isGetFromXASession() {
        return this.m_getFromXASession;
    }

    public javax.jms.BytesMessage createBytesMessage() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return new BytesMessage();
    }

    public javax.jms.MapMessage createMapMessage() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return new MapMessage();
    }

    public javax.jms.Message createMessage() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return new Message();
    }

    public javax.jms.ObjectMessage createObjectMessage() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return new ObjectMessage();
    }

    public javax.jms.ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        ObjectMessage msg = new ObjectMessage();
        msg.setObject(object);
        return msg;
    }

    public javax.jms.StreamMessage createStreamMessage() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return new StreamMessage();
    }

    public javax.jms.TextMessage createTextMessage() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return new TextMessage();
    }

    public javax.jms.TextMessage createTextMessage(String text) throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        TextMessage msg = new TextMessage();
        msg.setText(text);
        return msg;
    }

    public XMLMessage createXMLMessage() throws JMSException {
        IXMessageFactory factory = null;
        try {
            Class<?> c = Class.forName(XMESSAGE_FACTORY_CLASS);
            factory = (IXMessageFactory)c.newInstance();
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + XMESSAGE_FACTORY_CLASS, e);
        }
        if (factory == null) {
            return null;
        }
        return factory.createXMLMessage();
    }

    public XMLMessage createXMLMessage(String str) throws JMSException {
        XMLMessage msg = this.createXMLMessage();
        msg.setText(str);
        return msg;
    }

    public XMLMessage createXMLMessage(Document aDocument) throws JMSException {
        XMLMessage msg = this.createXMLMessage();
        msg.setDocument(aDocument);
        return msg;
    }

    public MultipartMessage createMultipartMessage() throws JMSException {
        IXMessageFactory factory = null;
        try {
            Class<?> c = Class.forName(XMESSAGE_FACTORY_CLASS);
            factory = (IXMessageFactory)c.newInstance();
        }
        catch (Exception e) {
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + XMESSAGE_FACTORY_CLASS, e);
        }
        if (factory == null) {
            return null;
        }
        return factory.createMultipartMessage();
    }

    public void setTransacted(boolean transacted) {
        this.m_transacted = transacted;
        if (this.m_transacted) {
            this.m_ackMode = 1;
            this.m_txnBatchSize = this.m_jconnection.getDefaultTxnBatchSize();
        }
    }

    public boolean getTransacted() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return this.getTransactedFlag();
    }

    public boolean getTransactedFlag() {
        return this.m_transacted;
    }

    public synchronized void commit() throws JMSException {
        this.commit(null, 0L);
    }

    public synchronized void commit(String transactionId) throws JMSException {
        this.commit(transactionId, 0L);
    }

    public synchronized void commit(String transactionId, long lifespan) throws JMSException {
        this.commit(transactionId, lifespan, false, 14, "");
    }

    public synchronized void commit(String transactionId, long lifespan, boolean isChannel, int channelStatus, String channelID) throws JMSException {
        if (!this.m_transacted) {
            throw new IllegalStateException(prAccessor.getString("NON_TRANSACTED"));
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        if (transactionId != null && this.isTxnBatchable()) {
            this.getAckSession().setTxnMgrUsed(true);
        }
        try {
            this.acknowledgeLastAsyncMsg();
            if (this.isTxnBatchable()) {
                this.sendBatch();
                if (!this.getAckSession().isTxnMgrUsed()) {
                    return;
                }
            }
            this.sendBatchedAcks();
            this.getOriginalUnacknowledgedMessagesQueue().removeAllMessages();
            this.getOriginalAckSession().commitWork(true, transactionId, lifespan, isChannel, channelStatus, channelID);
        }
        catch (EAlreadyInTransaction e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EUnknownTransaction e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENotInTransaction e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EConnectionClosing ecc) {
            if (this.wasClosedInternally()) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString(SESSION_CLOSED_TXN_TIMEOUT), "-23", null);
            }
            throw this.mapJMSException(ecc, null);
        }
        catch (ENetworkFailure e) {
            throw this.mapJMSException(e, null);
        }
        catch (ETransactionRollbackByBroker e) {
            TransactionRolledBackException exc = new TransactionRolledBackException(e.getMessage());
            exc.setLinkedException(e);
            throw exc;
        }
        catch (EChannelTransactionFailure e) {
            ChannelActiveException exc = new ChannelActiveException(e.getMessage(), e.getTime());
            exc.setLinkedException((Exception)e);
            throw exc;
        }
        catch (ETransactionFailure e) {
            JMSException exc = null;
            switch (e.getErrorId()) {
                case 7: {
                    exc = new TransactionRolledBackException(e.getMessage(), new Integer(-18).toString());
                    break;
                }
                case 8: {
                    exc = new TransactionRolledBackException(e.getMessage(), new Integer(-19).toString());
                    break;
                }
                case 9: {
                    exc = new TransactionRolledBackException(e.getMessage(), new Integer(-20).toString());
                    break;
                }
                case 10: {
                    exc = new TransactionRolledBackException(e.getMessage(), new Integer(-21).toString());
                    break;
                }
                default: {
                    exc = JMSExceptionUtil.createJMSException(e);
                }
            }
            exc.setLinkedException(e);
            throw exc;
        }
        catch (EFlowControlException fcE) {
            try {
                this.rollback();
            }
            catch (JMSException rbE) {
                rbE.setLinkedException(fcE);
                throw JMSExceptionUtil.createJMSException("Rollback caused by flow control is failed.", rbE);
            }
            TransactionRolledBackException trbE = new TransactionRolledBackException(fcE.getMessage(), String.valueOf(-16));
            trbE.setLinkedException(fcE);
            throw trbE;
        }
        catch (EGeneralException e) {
            throw this.mapJMSException(e, null);
        }
        finally {
            this.setTxnMgrUsed(false);
        }
    }

    public int getAcknowledgeMode() {
        return this.m_ackMode;
    }

    public void setTxnMgrUsed(boolean txnMgrUsed) {
        this.getAckSession().setTxnMgrUsed(txnMgrUsed);
    }

    public final void setTxnBatchSize(int size) throws IllegalStateException, JMSException {
        this.checkTransactedAndIsClosing();
        try {
            if (this.isTxnBatchable() && this.m_batchCount > 0) {
                this.setTxnMgrUsed(true);
                this.sendBatch();
            }
        }
        catch (EFlowControlException fcE) {
            throw JMSExceptionUtil.createJMSException(fcE.getMessage(), String.valueOf(-16), fcE);
        }
        finally {
            this.m_txnBatchSize = size;
        }
    }

    public int getTxnBatchSize() throws JMSException {
        return this.m_txnBatchSize;
    }

    public void acknowledgeLastAsyncMsg() throws JMSException {
        if (this.getDeliveryMode() == 2 && this.m_thread == Thread.currentThread() && !this.asyncAckNotPermittedForDeliveredMsg || this.getDeliveryMode() == 2 && this.isGetFromXASession() && !this.asyncAckNotPermittedForDeliveredMsg || this.getDeliveryMode() == 3 && !this.asyncAckNotPermittedForDeliveredMsg) {
            if (this.deliveredMsg != null) {
                this.deliveredMsg.getConsumer().acknowledge(this.deliveredMsg.m_zenvelope);
            }
            this.deliveredMsg = null;
            this.asyncAckNotPermittedForDeliveredMsg = false;
        }
    }

    public synchronized void associateToXAtxn(progress.message.zclient.Session zSession, UnacknowledgedMessagesQueue unackQueue) {
        if (this.getEnforceLocallyTransactedOnXAEnlistment()) {
            this.m_transacted = true;
            this.m_ackMode = 1;
        }
        if (this.deliveredMsg != null && (this.getDeliveryMode() == 2 && this.m_thread == Thread.currentThread() || this.getDeliveryMode() == 2 && this.isGetFromXASession() || this.isGetFromXASession() && this.isDeferredAckInXATxn() || this.getDeliveryMode() == 3)) {
            try {
                if (this.getOriginalUnacknowledgedMessagesQueue().dequeueFromEnd(this.deliveredMsg) != null) {
                    unackQueue.enqueue(this.deliveredMsg);
                    this.asyncAckNotPermittedForDeliveredMsg = false;
                } else {
                    this.asyncAckNotPermittedForDeliveredMsg = true;
                }
            }
            catch (NoSuchElementException e) {
                this.asyncAckNotPermittedForDeliveredMsg = true;
            }
        }
        this.m_ackSession = zSession;
        this.m_ackQueue = unackQueue;
        this.associatedToGT = true;
        if (this.isTxnBatchable()) {
            this.setTxnMgrUsed(true);
        }
    }

    public void setDeferredAckInXATxn(boolean value) {
        this.m_AckDelayedInXATxn = value;
    }

    public boolean isDeferredAckInXATxn() {
        return this.m_AckDelayedInXATxn;
    }

    public synchronized void dissociateToXAtxn() {
        if (this.isGetFromXASession() && this.isDeferredAckInXATxn()) {
            try {
                this.setDelayedAcknowledgeMessage(null);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        this.m_ackSession = this.getOriginalAckSession();
        this.m_ackQueue = this.getOriginalUnacknowledgedMessagesQueue();
        this.m_transacted = this.m_transacted_original;
        this.m_ackMode = this.m_ackMode_original;
        this.associatedToGT = false;
    }

    protected boolean isAssociatedToGT() {
        return this.associatedToGT;
    }

    protected progress.message.zclient.Session getOriginalAckSession() {
        return this.m_ackSession_original;
    }

    private UnacknowledgedMessagesQueue getOriginalUnacknowledgedMessagesQueue() {
        return this.m_ackQueue_original;
    }

    protected progress.message.zclient.Connection getZconnection() {
        return this.m_zconnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(EventHandler handler) {
        if (this.eventHandlerList == null) {
            this.eventHandlerList = new Vector();
        }
        Vector vector = this.eventHandlerList;
        synchronized (vector) {
            if (!this.eventHandlerList.contains(handler)) {
                this.eventHandlerList.addElement(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventHandler(EventHandler handler) {
        if (this.eventHandlerList == null) {
            return;
        }
        Vector vector = this.eventHandlerList;
        synchronized (vector) {
            this.eventHandlerList.removeElement(handler);
        }
    }

    protected void processEvent(EventObject evt) {
        if (this.eventHandlerList == null) {
            return;
        }
        Vector evtlist = (Vector)this.eventHandlerList.clone();
        if (evtlist == null) {
            return;
        }
        for (int i = 0; i < evtlist.size(); ++i) {
            EventHandler handler = (EventHandler)evtlist.elementAt(i);
            handler.handleEvent(evt);
        }
    }

    public void sendJSessionBatchedMsgs() throws JMSException {
        if (this.isTxnBatchable()) {
            this.sendBatchInternal();
        }
        this.sendBatchedAcks();
    }

    boolean hasUnackedMessages(MessageConsumer consumer) {
        return this.m_ackQueue.contains(consumer);
    }

    progress.message.zclient.Session getAckSession() {
        return this.m_ackSession;
    }

    public synchronized void rollback() throws JMSException {
        if (!this.m_transacted) {
            throw new IllegalStateException(prAccessor.getString("NON_TRANSACTED"));
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        try {
            if (this.getDeliveryMode() == 2 && this.m_thread == Thread.currentThread() || this.getDeliveryMode() == 3) {
                this.deliveredMsg = null;
                this.asyncAckNotPermittedForDeliveredMsg = false;
            }
            this.recoverInternal();
            if (this.rollbackBatch()) {
                return;
            }
            this.getOriginalAckSession().rollbackWork(true);
        }
        catch (EAlreadyInTransaction e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EUnknownTransaction e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENotInTransaction e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EConnectionClosing ecc) {
            if (this.wasClosedInternally()) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString(SESSION_CLOSED_TXN_TIMEOUT), "-23", null);
            }
            throw this.mapJMSException(ecc, null);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ETransactionFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        finally {
            this.setTxnMgrUsed(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl(CloseType type) throws JMSException {
        JMSException exc;
        block35: {
            block34: {
                exc = null;
                if (type != CloseType.CLOSE_TXN_TIMEOUT) {
                    this.waitForDeliveringMessage();
                }
                if (this.isAssociatedToGT()) {
                    try {
                        this.sendJSessionBatchedMsgs();
                    }
                    catch (JMSException e) {
                        exc = e;
                    }
                }
                if (this.m_deliveryStarted) {
                    try {
                        this.m_waitingForDeliveryThread = true;
                        this.stopImpl();
                    }
                    catch (JMSException e) {
                        exc = e;
                    }
                    finally {
                        this.m_waitingForDeliveryThread = false;
                    }
                }
                Enumeration consumers = ((Vector)this.m_consumers.clone()).elements();
                while (consumers.hasMoreElements()) {
                    MessageConsumer consumer = (MessageConsumer)consumers.nextElement();
                    try {
                        consumer.closeInternal();
                    }
                    catch (JMSException e) {
                        if (exc != null) continue;
                        exc = e;
                    }
                }
                Enumeration dsubs = ((Hashtable)this.m_durableSubscribers.clone()).elements();
                while (dsubs.hasMoreElements()) {
                    DurableSubscriber dsub = (DurableSubscriber)dsubs.nextElement();
                    try {
                        dsub.closeInternal();
                    }
                    catch (JMSException e) {
                        if (exc != null) continue;
                        exc = e;
                    }
                }
                Enumeration browsers = ((Vector)this.m_browsers.clone()).elements();
                while (browsers.hasMoreElements()) {
                    QueueBrowser browser = (QueueBrowser)browsers.nextElement();
                    try {
                        browser.close();
                    }
                    catch (JMSException e) {
                        if (exc != null) continue;
                        exc = e;
                    }
                }
                Enumeration producers = ((Vector)this.m_producers.clone()).elements();
                while (producers.hasMoreElements()) {
                    MessageProducer producer = (MessageProducer)producers.nextElement();
                    try {
                        producer.close();
                    }
                    catch (JMSException e) {
                        if (exc != null) continue;
                        exc = e;
                    }
                }
                if (this.getOriginalAckSession().getConnection().hierarchicallyConnected() && this.m_transacted_original) {
                    try {
                        if (this.isSendingMessage()) {
                            Thread.sleep(200L);
                        }
                        this.getOriginalAckSession().rollbackWork(false, false, null);
                    }
                    catch (ENotConnected producer) {
                    }
                    catch (EGeneralException e) {
                        if (exc == null) {
                            exc = JMSExceptionUtil.createJMSException(e);
                        }
                    }
                    catch (InterruptedException ie) {
                        if (exc != null) break block34;
                        exc = JMSExceptionUtil.createJMSException(ie.getMessage(), new Integer(-24).toString(), ie);
                    }
                }
            }
            SessionCloseEvent closeEvt = new SessionCloseEvent(this);
            this.processEvent(closeEvt);
            try {
                this.m_zconnection.disconnect(true);
            }
            catch (ENotConnected e) {
            }
            catch (EGeneralException e) {
                if (exc != null) break block35;
                exc = JMSExceptionUtil.createJMSException(e);
            }
        }
        this.m_closed = true;
        this.m_jconnection.removeZConnection(this.m_zconnection);
        this.m_jconnection.removeJMSSession(this);
        if (exc != null) {
            throw exc;
        }
    }

    public void close() throws JMSException {
        this.close(CloseType.CLOSE_EXTERNAL);
    }

    public void closeInternal() throws JMSException {
        this.close(CloseType.CLOSE_INTERNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(CloseType type) throws JMSException {
        boolean close = false;
        this.beginWaitForSession();
        try {
            Object object = this.m_closeSyncObject;
            synchronized (object) {
                this.m_stateLock.lock();
                if (!this.m_closing && !this.m_closed) {
                    this.m_internalClose = type == CloseType.CLOSE_TXN_TIMEOUT;
                    this.m_closing = true;
                    close = true;
                    this.closeImpl(type);
                }
            }
        }
        finally {
            try {
                if (close) {
                    this.postClose(type);
                }
            }
            finally {
                this.m_stateLock.unlock();
                this.endWaitForSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postClose(CloseType type) {
        if (type != CloseType.CLOSE_TXN_TIMEOUT) {
            if (this.m_sap != null) {
                this.m_sap.interrupt();
            }
            if (this.m_acknowledgeQueue != null) {
                this.m_acknowledgeQueue = null;
            }
        }
        if (this.m_trackDeliveryDoubt) {
            HashSet hashSet = this.m_inDoubtDeliveries;
            synchronized (hashSet) {
                this.m_inDoubtDeliveries.notifyAll();
            }
        }
        if (type == CloseType.CLOSE_EXTERNAL) {
            this.m_jconnection.getRejectionProcessor().waitForRejectionProcessing();
        }
    }

    private boolean isXASession() {
        String className = this.getClass().getName();
        return className.indexOf("XASession") >= 0 || className.indexOf("XAQueueSession") >= 0 || className.indexOf("XATopicSession") >= 0;
    }

    public void recover() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        if (this.m_transacted) {
            throw new IllegalStateException(prAccessor.getString("TRANSACTED"));
        }
        if ((this.getDeliveryMode() == 2 && this.m_thread == Thread.currentThread() || this.getDeliveryMode() == 3) && this.m_ackMode != 2 && this.m_ackMode != 1004) {
            this.getUnacknowledgedMessagesQueue().addMessage((Message)this.deliveredMsg.clone());
            this.deliveredMsg = null;
            this.asyncAckNotPermittedForDeliveredMsg = false;
        }
        this.setDelayedAcknowledgeMessage(null);
        this.recoverInternal();
    }

    void recoverInternal() throws JMSException {
        UnacknowledgedMessagesQueue q = this.getOriginalUnacknowledgedMessagesQueue();
        LinkedList ccMsgs = new LinkedList();
        LinkedList nonCCMsgs = new LinkedList();
        q.removeAllMessages(ccMsgs, nonCCMsgs);
        this.recoverReceivedMessageQueue(ccMsgs, nonCCMsgs);
    }

    public void recoverReceivedMessageQueue(LinkedList ccMsgs, LinkedList nonCCMsgs) {
        Message m;
        ListIterator iter;
        if (!ccMsgs.isEmpty()) {
            iter = ccMsgs.listIterator();
            while (iter.hasNext()) {
                m = (Message)iter.next();
                m.incrementReenqueue();
                ((IConnectionConsumer)((Object)m.getConnectionConsumer())).redeliver(m.getEnvelope());
            }
        }
        if (!nonCCMsgs.isEmpty()) {
            iter = nonCCMsgs.listIterator(nonCCMsgs.size());
            while (iter.hasPrevious()) {
                m = (Message)iter.previous();
                m.incrementReenqueue();
                m.getConsumer().getReceivedMessagesQueue().putMessageBack(m);
                this.incrementReceivedMessageCount();
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return this.m_jlistener;
    }

    public final void setMessageListener(MessageListener listener) throws JMSException {
        if (listener != null) {
            if (this.isClosing() || this.m_jconnection.isClosing()) {
                throw this.getJMSObjectClosedException();
            }
            this.m_jconnection.checkPersistence("setMessageListener");
            this.checkDeliveryMode(3);
        } else {
            this.m_deliveryMode = 0;
        }
        this.m_jlistener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws JMSException {
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            this.m_stateLock.lock();
            try {
                if (!this.m_closed) {
                    this.startImpl();
                }
            }
            finally {
                this.m_stateLock.unlock();
            }
        }
    }

    private void startImpl() throws JMSException {
        JMSException exc = null;
        try {
            this.m_zconnection.startDelivery();
            this.m_deliveryStarted = true;
        }
        catch (EUnusableConnection e) {
            exc = JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            exc = JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            exc = JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            exc = JMSExceptionUtil.createJMSException(e);
        }
        Enumeration consumers = ((Vector)this.m_consumers.clone()).elements();
        while (consumers.hasMoreElements()) {
            MessageConsumer consumer = (MessageConsumer)consumers.nextElement();
            try {
                consumer.start();
            }
            catch (JMSException e) {
                if (exc != null) continue;
                exc = e;
            }
        }
        Enumeration dsubs = ((Hashtable)this.m_durableSubscribers.clone()).elements();
        while (dsubs.hasMoreElements()) {
            DurableSubscriber dsub = (DurableSubscriber)dsubs.nextElement();
            try {
                dsub.start();
            }
            catch (JMSException e) {
                if (exc != null) continue;
                exc = e;
            }
        }
        Enumeration browsers = ((Vector)this.m_browsers.clone()).elements();
        while (browsers.hasMoreElements()) {
            QueueBrowser browser = (QueueBrowser)browsers.nextElement();
            try {
                browser.start();
            }
            catch (JMSException e) {
                if (exc != null) continue;
                exc = e;
            }
        }
        if (this.m_deliveryMode == 2) {
            this.startDeliveryThread();
        }
        if (exc != null) {
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        this.beginWaitForSession();
        try {
            Object object = this.m_closeSyncObject;
            synchronized (object) {
                this.m_stateLock.lock();
                try {
                    if (this.m_deliveryStarted) {
                        this.stopImpl();
                    }
                }
                finally {
                    this.m_stateLock.unlock();
                }
            }
        }
        finally {
            this.endWaitForSession();
        }
    }

    private void stopImpl() throws JMSException {
        JMSException exc;
        block14: {
            exc = null;
            try {
                this.setDelayedAcknowledgeMessage(null);
            }
            catch (JMSException e) {
                Exception ex = e.getLinkedException();
                if (ex != null && ex instanceof ENotConnected) break block14;
                throw e;
            }
        }
        if (this.m_deliveryMode == 2) {
            this.stopDeliveryThread();
        }
        try {
            this.m_zconnection.stopDelivery();
            this.m_deliveryStarted = false;
        }
        catch (EUnusableConnection e) {
            exc = JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            exc = JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            exc = JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            exc = JMSExceptionUtil.createJMSException(e);
        }
        Enumeration consumers = ((Vector)this.m_consumers.clone()).elements();
        while (consumers.hasMoreElements()) {
            MessageConsumer consumer = (MessageConsumer)consumers.nextElement();
            exc = this.stopMessageConsumer(consumer, exc);
        }
        Enumeration dsubs = ((Hashtable)this.m_durableSubscribers.clone()).elements();
        while (dsubs.hasMoreElements()) {
            DurableSubscriber dsub = (DurableSubscriber)dsubs.nextElement();
            exc = this.stopMessageConsumer(dsub, exc);
        }
        Enumeration browsers = ((Vector)this.m_browsers.clone()).elements();
        while (browsers.hasMoreElements()) {
            QueueBrowser browser = (QueueBrowser)browsers.nextElement();
            try {
                browser.stop();
            }
            catch (JMSException e) {
                if (exc != null) continue;
                exc = e;
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    private <T0 extends MessageConsumer> JMSException stopMessageConsumer(T0 dsub, JMSException excParam) {
        JMSException exc;
        block3: {
            exc = excParam;
            try {
                if (!dsub.isClosing()) {
                    dsub.stop();
                }
            }
            catch (JMSException e) {
                if (exc != null) break block3;
                exc = e;
            }
        }
        return exc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        if (this.m_deliveryMode == 3) {
            if (this.deliveredMsg == null || this.isClosing()) {
                return;
            }
            this.deliver(this.deliveredMsg.getConsumer());
            return;
        }
        while (!this.isStopped() && this.m_thread == Thread.currentThread()) {
            try {
                this.waitForReceivedMessages();
                if (this.isStopped()) {
                    return;
                }
                Enumeration consumers = ((Vector)this.m_consumers.clone()).elements();
                while (consumers.hasMoreElements() && !this.isStopped()) {
                    MessageConsumer consumer = (MessageConsumer)consumers.nextElement();
                    this.deliver(consumer);
                    if (this.isStopped()) {
                        return;
                    }
                    if (!(consumer instanceof QueueReceiver)) continue;
                    Object object = this.m_closeSyncObject;
                    synchronized (object) {
                        if (!consumer.isClosing()) {
                            ((QueueReceiver)consumer).makeGetRequest();
                        }
                    }
                }
                Enumeration dsubs = this.m_durableSubscribers.elements();
                while (dsubs.hasMoreElements() && !this.isStopped()) {
                    DurableSubscriber dsub = (DurableSubscriber)dsubs.nextElement();
                    this.deliver(dsub);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    boolean isAcknowledged(Message msg) throws JMSException {
        return !this.getUnacknowledgedMessagesQueue().contains(msg);
    }

    void acknowledge(Message msg) throws JMSException {
        switch (this.m_ackMode) {
            case 2: {
                ArrayList msgs = new ArrayList();
                if (this.getUnacknowledgedMessagesQueue().removeAllMessages(msgs)) {
                    HashMap<MessageConsumer, MessageConsumer> consumerMap = new HashMap<MessageConsumer, MessageConsumer>();
                    for (Message aMsg : msgs) {
                        MessageConsumer consumer = aMsg.getConsumer();
                        if (consumer == null) continue;
                        consumer.batchAck(aMsg.m_zenvelope);
                        consumerMap.put(consumer, consumer);
                    }
                    for (MessageConsumer consumer : consumerMap.values()) {
                        consumer.sendBatch(this.m_ackMode == 3);
                        Session.closeConsumer(consumer);
                    }
                    for (Message aMsg : msgs) {
                        aMsg.m_zenvelope.setUserAcked();
                    }
                    return;
                }
            }
            case 1004: {
                MessageConsumer consumer;
                if (this.getUnacknowledgedMessagesQueue().removeSingleMessage(msg) && (consumer = msg.getConsumer()) != null) {
                    consumer.acknowledge(msg.m_zenvelope);
                    msg.m_zenvelope.setUserAcked();
                    Session.closeConsumer(consumer);
                }
                return;
            }
        }
    }

    private static void closeConsumer(MessageConsumer consumer) throws JMSException {
        if (consumer.isClosing() && consumer.isClosePending()) {
            consumer.close();
        }
    }

    protected boolean isStopped() {
        return this.m_stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStopped() {
        this.m_stopped = true;
        Object object = this.m_msgCntLock;
        synchronized (object) {
            this.m_msgCntLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDeliveryThread() {
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (this.m_thread != null && !this.m_thread.isStopped()) {
                SessionThread deliveryThread = this.m_thread;
                deliveryThread.setStopped();
                if (Thread.currentThread() != deliveryThread) {
                    try {
                        while (deliveryThread.isAlive() && !this.wasClosedInternally() && !this.m_threadExited && !this.isWaitingForSession(deliveryThread)) {
                            this.m_closeSyncObject.wait(60000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    boolean isDeliveryThreadStarted() {
        return this.m_thread != null;
    }

    public void startDeliveryThread() {
        if (this.m_thread == null || this.m_thread.isStopped()) {
            this.m_thread = new SessionThread();
            this.m_thread.setDaemon(true);
            this.m_stopped = false;
            this.addDispatcher(this.m_thread);
            this.m_thread.start();
            this.m_threadExited = false;
        }
    }

    boolean wasClosedInternally() {
        return this.m_internalClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkDeliveryMode(int mode) throws JMSException {
        if (this.m_deliveryMode == 0) {
            this.m_deliveryMode = mode;
            if (mode == 2) {
                Object object = this.m_closeSyncObject;
                synchronized (object) {
                    if (this.m_deliveryStarted) {
                        this.startDeliveryThread();
                    }
                }
            }
        } else {
            if (this.m_deliveryMode == mode) {
                return;
            }
            if (this.m_deliveryMode == 1) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("SESSION_IS_SYNC"), null);
            }
            if (this.m_deliveryMode == 2) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("SESSION_IS_ASYNC"), null);
            }
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("SESSION_IS_CC"), null);
        }
    }

    int getDeliveryMode() {
        return this.m_deliveryMode;
    }

    boolean okToCloseConsumer(MessageConsumer consumer) {
        boolean result = true;
        if (!this.isClosing() && (this.m_ackMode == 2 || this.m_ackMode == 1004) && this.hasUnackedMessages(consumer)) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliver(MessageConsumer consumer) {
        boolean isCC;
        boolean bl = isCC = this.m_cc != null;
        if (this.prepareToDeliver(consumer, isCC)) {
            return;
        }
        try {
            Message msg = this.getMessage(consumer, isCC);
            if (msg == null) {
                return;
            }
            Message clientMsg = (Message)msg.protectedClone();
            clientMsg.setConsumer(consumer);
            if (this.m_beforeDeliveryListener != null) {
                this.m_beforeDeliveryListener.beforeDelivery(this, clientMsg);
            }
            this.processAckMode(msg, clientMsg);
            MessageListener msgListener = null;
            try {
                msgListener = isCC ? this.getMessageListener() : consumer.getMessageListener();
                msgListener.onMessage((javax.jms.Message)((Object)clientMsg));
            }
            catch (RuntimeException e) {
                clientMsg = this.retryClientMsgProcessing(consumer, isCC, msg, clientMsg, msgListener);
                this.processRuntimeException(isCC, e);
            }
            catch (JMSException e) {
                this.m_jconnection.onException(e);
            }
            finally {
                this.releaseResources(consumer, isCC, msg, clientMsg);
            }
        }
        finally {
            this.cleanupDeliver(isCC);
        }
    }

    private void releaseResources(MessageConsumer consumer, boolean isCC, Message msg, Message clientMsg) {
        boolean closing = this.isClosing(consumer);
        if (!closing) {
            if (this.m_ackMode != 2 && this.m_ackMode != 1004) {
                try {
                    if (this.deliveredMsg != null) {
                        consumer.acknowledge(msg.getEnvelope());
                    }
                }
                catch (JMSException e) {
                    this.handleJMSExceptionOnDelivery(e, isCC);
                }
            }
            consumer.release(msg);
            if (this.m_afterDeliveryListener != null) {
                this.m_afterDeliveryListener.afterDelivery(this, clientMsg);
            }
            if (isCC) {
                if (this.m_serverSessionReleaseListener != null) {
                    this.m_serverSessionReleaseListener.okToClose(this);
                }
                this.m_thread = null;
                this.m_cc = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosing(MessageConsumer consumer) {
        boolean closing;
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            closing = consumer.isClosing() || this.isClosing();
        }
        return closing;
    }

    private void processRuntimeException(boolean isCC, RuntimeException exception) {
        if (isCC && this.m_rethrowCCRuntimeExceptions) {
            throw exception;
        }
        exception.printStackTrace(System.err);
        JMSException exc = JMSExceptionUtil.createJMSException(prAccessor.getString("SSN_EXCEPT_IN_MSG_LSTNR") + exception.getMessage(), String.valueOf(-15), exception);
        this.m_jconnection.onException(exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message retryClientMsgProcessing(MessageConsumer consumer, boolean isCC, Message msg, Message originalClientMsg, MessageListener msgListener) {
        Message clientMsg = originalClientMsg;
        if (!(this.m_transacted || this.m_ackMode != 1 && this.m_ackMode != 3)) {
            while (true) {
                try {
                    msg.incrementReenqueue();
                    if (consumer.checkUndeliverable(msg) == null) {
                        break;
                    }
                }
                catch (JMSException jmse) {
                    this.handleJMSExceptionOnDelivery(jmse, isCC);
                }
                Object jmse = this.m_closeSyncObject;
                synchronized (jmse) {
                    if (consumer.isClosing() || this.isClosing()) {
                        break;
                    }
                }
                try {
                    clientMsg = (Message)msg.protectedClone();
                    clientMsg.setConsumer(consumer);
                    clientMsg.setJMSRedelivered(true, true);
                    msgListener.onMessage((javax.jms.Message)((Object)clientMsg));
                }
                catch (RuntimeException | JMSException e1) {
                    e1.printStackTrace(System.err);
                    if (!this.DEBUG) continue;
                    this.debug(e1.toString(), e1);
                    continue;
                }
                break;
            }
        }
        return clientMsg;
    }

    private void processAckMode(Message msg, Message clientMsg) {
        if (this.m_ackMode == 2 || this.m_ackMode == 1004 || this.m_transacted) {
            clientMsg.unprotectSuccessor();
            this.getUnacknowledgedMessagesQueue().addMessage(msg);
        }
    }

    private Message getMessage(MessageConsumer consumer, boolean isCC) {
        Message msg = null;
        if (isCC) {
            msg = this.deliveredMsg;
        } else {
            try {
                msg = this.getNextMessage(consumer);
            }
            catch (JMSException ex) {
                this.handleJMSExceptionOnDelivery(ex, isCC);
            }
            if (msg == null) {
                return null;
            }
            msg.setConsumer(consumer);
            this.deliveredMsg = msg;
            this.asyncAckNotPermittedForDeliveredMsg = false;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToDeliver(MessageConsumer consumer, boolean isCC) {
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (consumer.isClosing()) {
                return true;
            }
            if (this.isClosing()) {
                return true;
            }
            this.m_deliveringMessage = true;
            if (isCC) {
                this.m_ccThread = Thread.currentThread();
                this.addDispatcher(this.m_ccThread);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDeliver(boolean isCC) {
        if (isCC) {
            this.removeDispatcher(this.m_ccThread);
        }
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            this.m_deliveringMessage = false;
            this.m_ccThread = null;
            this.m_closeSyncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementReceivedMessageCount() {
        Object object = this.m_msgCntLock;
        synchronized (object) {
            ++this.m_rxMsgCnt;
            this.m_msgCntLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementReceivedMessageCount() {
        Object object = this.m_msgCntLock;
        synchronized (object) {
            --this.m_rxMsgCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReceivedMessages() throws InterruptedException {
        Object object = this.m_msgCntLock;
        synchronized (object) {
            while (this.m_rxMsgCnt <= 0 && !this.isStopped()) {
                this.m_msgCntLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDelayedAcknowledgeMessage(Message msg) throws JMSException {
        ClientAcknowledgedMessageHolder clientAcknowledgedMessageHolder = this.m_clientAckdMsg;
        synchronized (clientAcknowledgedMessageHolder) {
            MessageConsumer consumer;
            Message heldMsg = this.m_clientAckdMsg.getMessage();
            if (heldMsg != null && (consumer = heldMsg.getConsumer()) != null) {
                consumer.acknowledge(heldMsg.m_zenvelope);
            }
            this.m_clientAckdMsg.setMessage(msg);
        }
    }

    UnacknowledgedMessagesQueue getUnacknowledgedMessagesQueue() {
        return this.m_ackQueue;
    }

    JMSException getJMSObjectClosedException() {
        if (this.wasClosedInternally()) {
            return new IllegalStateException(prAccessor.getString(SESSION_CLOSED_TXN_TIMEOUT), new Integer(-23).toString());
        }
        int errorCode = -22;
        if (this.m_zconnection.getConnectionDropped()) {
            errorCode = -5;
        }
        return new IllegalStateException(prAccessor.getString("SESSION_CLOSED"), new Integer(errorCode).toString());
    }

    public boolean isClosing() {
        return this.m_closing || this.m_closed;
    }

    public synchronized void loadMsgFromCC(Message msg) throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.deliveredMsg = msg;
        this.m_lastcc = this.m_cc = (IConnectionConsumer)((Object)this.deliveredMsg.getConnectionConsumer());
    }

    public void setServerSession(ServerSession serverSession) {
        this.m_serverSession = serverSession;
    }

    public ServerSession getServerSession() {
        return this.m_serverSession;
    }

    public Connection getJconnection() {
        return this.m_jconnection;
    }

    public Object getCloseLock() {
        return this.m_closeSyncObject;
    }

    public boolean isDeliveringMessage() {
        return this.m_deliveringMessage;
    }

    public boolean isSendingMessage() {
        return this.m_sendingMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeliveringMessage() {
        Thread deliveryThread;
        Thread thread = deliveryThread = this.m_cc == null ? this.m_thread : this.m_ccThread;
        if (deliveryThread == null || deliveryThread == Thread.currentThread()) {
            return;
        }
        boolean interrupted = false;
        while (this.isDeliveringMessage() && !this.isWaitingForSession(deliveryThread)) {
            try {
                Object object = this.m_closeSyncObject;
                synchronized (object) {
                    this.m_closeSyncObject.wait(60000L);
                }
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isDefaultToPersistentDelivery() {
        return this.m_defaultToPersistentDelivery;
    }

    public void setEnforceLocallyTransactedOnXAEnlistment(boolean b) {
        this.m_enforceLocallyTransactedOnXAEnlistment = b;
    }

    public boolean getEnforceLocallyTransactedOnXAEnlistment() {
        return this.m_enforceLocallyTransactedOnXAEnlistment;
    }

    void batch(javax.jms.Destination dest, Envelope env) throws JMSException {
        Envelope e;
        if (this.m_batchTable == null) {
            this.m_batchTable = new HashMap();
        }
        int messageSize = env.getMessage().getRawBodyLength();
        if (this.m_batchSize > this.m_txnBatchSize) {
            this.sendBatchInternal();
        }
        if ((e = (Envelope)this.m_batchTable.get(dest)) != null && e.isNonPersistentReplicated() != env.isNonPersistentReplicated()) {
            this.sendBatchInternal();
            e = null;
        }
        if (e != null) {
            String existingOverride = (String)Session.getProperty(Session.getFirstSubMgram(e), "X-HTTP-DestinationURL");
            String newOverride = (String)env.getProperty("X-HTTP-DestinationURL");
            if (newOverride == null && existingOverride != null || newOverride != null && !newOverride.equals(existingOverride)) {
                this.sendBatchInternal();
                e = null;
            }
        }
        boolean isMultiTopic = dest instanceof MultiTopic;
        if (e == null && this.m_batchTable.size() > 0 && (isMultiTopic || this.m_batchTableHasMultiTopic)) {
            this.sendBatchInternal();
            e = null;
        }
        env.syncEnvelopeBatch();
        if (e == null) {
            Envelope envClone = (Envelope)env.protectedClone();
            envClone.setTxnBatchable(this.getAckSession().getTid());
            if (!this.m_batchTable.isEmpty()) {
                this.setTxnMgrUsed(true);
            }
            this.m_batchTable.put(dest, envClone);
        } else {
            if (isMultiTopic) {
                this.m_batchTableHasMultiTopic = true;
            }
            e.addToBatch(env);
        }
        this.m_batchSize += messageSize;
        ++this.m_batchCount;
    }

    private void sendBatchInternal() throws JMSException {
        this.setTxnMgrUsed(true);
        try {
            this.sendBatch();
        }
        catch (EFlowControlException fcE) {
            throw JMSExceptionUtil.createJMSException(fcE.getMessage(), String.valueOf(-16), fcE);
        }
    }

    private static IMgram getFirstSubMgram(Envelope e) {
        return (IMgram)e.getMgram().getBatchHandle().getBatchIterator().next();
    }

    private static Object getProperty(IMgram mgram, String property) {
        mgram.createSidebandDataIfNeeded();
        return mgram.getSidebandDataReadOnly().getProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void send(javax.jms.Destination d, Message msg, boolean sync, boolean needsAckParam) throws JMSException {
        block41: {
            boolean needsAck = needsAckParam;
            Envelope env = msg.getEnvelope();
            env.setAsyncDelivery(!sync);
            if (this.m_jconnection.isSecure()) {
                boolean perMsgEnc = false;
                Boolean value = (Boolean)env.getProperties().get("JMS_SonicMQ_perMessageEncryption");
                if (value != null) {
                    perMsgEnc = value;
                }
                env.setPerMsgEncrypted(perMsgEnc);
            }
            Object perMsgEnc = this.m_closeSyncObject;
            synchronized (perMsgEnc) {
                if (this.isClosing()) {
                    throw this.getJMSObjectClosedException();
                }
                this.m_sendingMessage = true;
            }
            try {
                boolean trackDeliveryDoubt;
                if (this.isTxnBatchable()) {
                    this.batch(d, env);
                    return;
                }
                boolean bl = trackDeliveryDoubt = !sync && this.m_trackDeliveryDoubt && !env.isDiscardable();
                if (trackDeliveryDoubt) {
                    if (this.m_deliveryDoubtWindow == 1) {
                        sync = true;
                        env.setAsyncDelivery(false);
                        trackDeliveryDoubt = false;
                    } else {
                        needsAck = true;
                    }
                }
                if (!sync && this.m_asyncDeliveryMode == Constants.ASYNC_DELIVERY_MODE_ENABLED && this.m_jconnection.getRejectionProcessor().hasRejectionListener() && !env.isDiscardable()) {
                    env.setRejectionTracker(new RejectionTracker(this, env));
                    if (!this.m_rejectableSupported) {
                        needsAck = true;
                    }
                }
                try {
                    int timeoutValue = sync ? (this.m_sendTimeoutMs > 0 ? this.m_sendTimeoutMs : -1) : 0;
                    Publication j = this.m_ackSession.publishMs(env, timeoutValue, needsAck);
                    if (!trackDeliveryDoubt) break block41;
                    HashSet hashSet = this.m_inDoubtDeliveries;
                    synchronized (hashSet) {
                        Publication publication = j;
                        synchronized (publication) {
                            if (j.isRunning()) {
                                j.setJobCompletionListener(this);
                                if (this.DEBUG && this.checkDebugFlags(128)) {
                                    this.debug("ADDED IN DOUBT PUBLICATION: " + j);
                                }
                                this.m_inDoubtDeliveries.add(j);
                            }
                        }
                        while (this.m_inDoubtDeliveries.size() >= this.m_deliveryDoubtWindow) {
                            if (this.isClosing()) {
                                throw this.getJMSObjectClosedException();
                            }
                            try {
                                this.m_inDoubtDeliveries.wait();
                            }
                            catch (InterruptedException ie) {
                                throw JMSExceptionUtil.createJMSException(ie.getMessage(), new Integer(-24).toString(), ie);
                            }
                        }
                    }
                }
                catch (EGeneralException ege) {
                    RejectionTracker rt = env.getRejectionTracker();
                    if (rt == null || rt.cancel()) {
                        if (ege instanceof ETimeout) {
                            throw new JMSSendTimeoutException(prAccessor.getString("SEND_TIMEOUT"), "-60", (Exception)ege);
                        }
                        throw this.mapJMSException(ege, msg);
                    }
                }
            }
            finally {
                perMsgEnc = this.m_closeSyncObject;
                synchronized (perMsgEnc) {
                    this.m_sendingMessage = false;
                    this.m_closeSyncObject.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onJobComplete(Job job) {
        if (this.m_trackDeliveryDoubt) {
            HashSet hashSet = this.m_inDoubtDeliveries;
            synchronized (hashSet) {
                if (this.m_inDoubtDeliveries.remove(job)) {
                    if (this.DEBUG && this.checkDebugFlags(128)) {
                        this.debug("PUBLICATION COMPLETE: " + job);
                    }
                    this.m_inDoubtDeliveries.notifyAll();
                }
            }
        }
    }

    @Override
    public final void onRejection(Envelope env, Exception error) {
        Message msg = null;
        try {
            msg = Message.createMessage(env);
        }
        catch (JMSException e) {
            SessionConfig.logMessage(prAccessor.getString("MESSAGE_CREATION_ERROR"), e, SessionConfig.SEVERE);
        }
        JMSException jmse = this.mapJMSException(error, msg);
        JMSAsynchronousDeliveryException jade = new JMSAsynchronousDeliveryException(jmse, null, null);
        this.m_jconnection.getRejectionProcessor().handleRejection((JMSException)jade, (javax.jms.Message)((Object)msg), false);
    }

    final JMSException mapJMSException(Exception error, Message msg) {
        if (error instanceof EUnauthorizedOverrideDestination) {
            return this.mapEUnauthorizedOverrideDestinationException(error, msg);
        }
        if (error instanceof EUnauthorizedHttpNode) {
            return this.mapEUnauthorizedHttpNodeException(error, msg);
        }
        if (error instanceof ESecurityPolicyViolation) {
            return this.mapESecurityPolicyViolationException(error, msg);
        }
        if (error instanceof ESubjectNotSet) {
            return new InvalidDestinationException(error.getMessage());
        }
        if (error instanceof EConnectionClosing && this.wasClosedInternally()) {
            return JMSExceptionUtil.createJMSException(prAccessor.getString(SESSION_CLOSED_TXN_TIMEOUT), String.valueOf(-23), null);
        }
        if (error instanceof EFlowControlException) {
            return JMSExceptionUtil.createJMSException(error.getMessage(), String.valueOf(-16), error);
        }
        if (error instanceof EInterrupted) {
            return JMSExceptionUtil.createJMSException(error.getMessage(), String.valueOf(-24), error);
        }
        if (error instanceof EGeneralException) {
            return this.mapGeneralException((EGeneralException)error);
        }
        return JMSExceptionUtil.createJMSException(error);
    }

    private JMSException mapEUnauthorizedOverrideDestinationException(Exception error, Message msg) {
        String url = QUESTION_MARKS;
        try {
            if (msg != null) {
                url = msg.getStringProperty("X-HTTP-DestinationURL");
            }
        }
        catch (JMSException jmse) {
            this.debugErrorMappingJmsException(error, jmse);
        }
        return JMSExceptionUtil.createJMSSecurityException(prAccessor.getString(NOT_AUTH_DEST) + url, error);
    }

    private JMSException mapEUnauthorizedHttpNodeException(Exception error, Message msg) {
        String routing = QUESTION_MARKS;
        try {
            if (msg != null) {
                routing = DestUtil.getRoutingName(msg.getJMSDestination());
            }
        }
        catch (JMSException jmse) {
            this.debugErrorMappingJmsException(error, jmse);
        }
        return JMSExceptionUtil.createJMSSecurityException(prAccessor.getString(NOT_AUTH_HTTP_NODE_URL) + routing, error);
    }

    private JMSException mapESecurityPolicyViolationException(Exception error, Message msg) {
        String dest = QUESTION_MARKS;
        boolean topic = true;
        try {
            if (msg != null) {
                Destination destination = (Destination)DestinationFactory.createSonicDestination(msg.getJMSDestination());
                dest = destination.getDestinationName();
                if (destination.isQueue()) {
                    topic = false;
                }
            }
        }
        catch (JMSException jmse) {
            this.debugErrorMappingJmsException(error, jmse);
        }
        if (topic) {
            return JMSExceptionUtil.createJMSSecurityException(prAccessor.getString(NOT_AUTH_PUBLISH) + dest, error);
        }
        return JMSExceptionUtil.createJMSSecurityException(prAccessor.getString(NOT_AUTH_SEND) + dest, error);
    }

    private void debugErrorMappingJmsException(Exception error, JMSException jmse) {
        if (this.DEBUG && this.checkDebugFlags(8192)) {
            this.debug(ERROR_MAPPING_JMSEXCEPTION + error.toString() + BECAUSE_MESSAGE_PROPERTY_ACCESS_GENERATED + jmse, jmse);
            this.debug(error.toString(), error);
        }
    }

    private JMSException mapGeneralException(EGeneralException error) {
        EGeneralException ege = error;
        int errorId = ege.getErrorId();
        switch (errorId) {
            case 202: {
                return JMSExceptionUtil.createJMSException(prAccessor.getString(DELIVERY_TIMEOUT_ON_CLOSE), String.valueOf(-28), ege);
            }
            case 106: {
                int errorCode = -22;
                if (this.m_zconnection.getConnectionDropped()) {
                    errorCode = -5;
                }
                return JMSExceptionUtil.createJMSException(ege.getMessage(), String.valueOf(errorCode), ege);
            }
            case 3005: {
                return new InvalidDestinationException(ege.getMessage());
            }
            case 3004: {
                return JMSExceptionUtil.createJMSException(ege.getMessage(), String.valueOf(-17), ege);
            }
            case 2500: {
                return JMSExceptionUtil.createJMSException(ege.getMessage(), new Integer(-4002).toString(), ege);
            }
            case 2501: {
                return JMSExceptionUtil.createJMSException(ege.getMessage(), String.valueOf(-4000), ege);
            }
            case 2505: {
                return new InvalidDestinationException(ege.getMessage());
            }
            case 200: {
                return JMSExceptionUtil.createJMSException(ege.getMessage(), String.valueOf(-22), ege);
            }
            case 3006: {
                return JMSExceptionUtil.createJMSException(ege.getMessage(), String.valueOf(-29), ege);
            }
        }
        return JMSExceptionUtil.createJMSException(ege);
    }

    public void sendBatch() throws JMSException, EFlowControlException {
        try {
            if (this.m_batchCount > 0) {
                for (Envelope e : this.m_batchTable.values()) {
                    this.getAckSession().publish(e, -1, false, this.getAckSession().isTxnMgrUsed());
                    if (!this.CALLBACK) continue;
                    this.callback("Batch Sent", 0, new Object[]{e.getMgram().getSubject().getSubjectString()});
                }
                this.resetData();
            }
        }
        catch (EConnectionClosing ecc) {
            if (this.wasClosedInternally()) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString(SESSION_CLOSED_TXN_TIMEOUT), "-23", null);
            }
            throw this.mapJMSException(ecc, null);
        }
        catch (ENetworkFailure e) {
            throw this.mapJMSException(e, null);
        }
        catch (ETransactionFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EFlowControlException fcE) {
            throw fcE;
        }
        catch (EGeneralException e) {
            throw this.mapJMSException(e, null);
        }
    }

    public boolean rollbackBatch() throws JMSException {
        if (this.isAssociatedToGT()) {
            this.sendJSessionBatchedMsgs();
        }
        if (this.isTxnBatchable()) {
            if (this.m_batchCount > 0) {
                this.resetData();
            }
            if (!this.getAckSession().isTxnMgrUsed()) {
                return true;
            }
        }
        this.getAckSession().discardBatchedAcks();
        return false;
    }

    private void resetData() {
        this.m_batchTable.clear();
        this.m_batchSize = 0;
        this.m_batchCount = 0;
        this.m_batchTableHasMultiTopic = false;
    }

    public final boolean isTxnBatchable() {
        return this.m_txnBatchSize > 0;
    }

    protected void sendBatchedCCAcks() throws JMSException {
        if (this.m_lastcc != null) {
            try {
                this.getAckSession().sendBatchedAcks(this.m_ackMode == 3);
            }
            catch (EGeneralException ege) {
                throw JMSExceptionUtil.createJMSException(ege);
            }
        }
    }

    void sendBatchedAcks() throws JMSException {
        this.sendBatchedCCAcks();
        Enumeration consumers = ((Vector)this.m_consumers.clone()).elements();
        while (consumers.hasMoreElements()) {
            MessageConsumer consumer = (MessageConsumer)consumers.nextElement();
            consumer.sendBatch(this.m_ackMode == 3);
        }
        Enumeration dsubs = ((Hashtable)this.m_durableSubscribers.clone()).elements();
        while (dsubs.hasMoreElements()) {
            DurableSubscriber dsub = (DurableSubscriber)dsubs.nextElement();
            dsub.sendBatch(this.m_ackMode == 3);
        }
    }

    public void setAckBatchingEnabled(boolean enabled) throws IllegalStateException, JMSException {
        this.checkTransactedAndIsClosing();
        this.m_AckListEnabled = enabled;
    }

    private void checkTransactedAndIsClosing() throws JMSException {
        if (!this.m_transacted) {
            throw new IllegalStateException(prAccessor.getString("NON_TRANSACTED"));
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
    }

    boolean getAckListEnabled() {
        return this.m_AckListEnabled;
    }

    private void addConsumer(MessageConsumer consumer) {
        this.m_consumers.addElement(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQueueReceiver(QueueReceiver receiver) throws JMSException {
        this.addConsumer(receiver);
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (this.m_deliveryStarted) {
                receiver.start(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTopicSubscriber(TopicSubscriber subscriber) throws JMSException {
        this.addConsumer(subscriber);
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (this.m_deliveryStarted) {
                subscriber.start();
            }
        }
    }

    final void removeConsumer(MessageConsumer consumer) {
        this.m_consumers.removeElement(consumer);
    }

    final void addProducer(MessageProducer producer) {
        this.m_producers.addElement(producer);
    }

    final void removeProducer(MessageProducer producer) {
        this.m_producers.removeElement(producer);
    }

    final void addBrowser(QueueBrowser browser) {
        this.m_browsers.addElement(browser);
    }

    final void removeBrowser(QueueBrowser browser) {
        this.m_browsers.removeElement(browser);
    }

    public final javax.jms.QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.createTopicSessionAndIsClosingAndPersistence();
        return new QueueBrowser(this, queue);
    }

    public final javax.jms.QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.createTopicSessionAndIsClosingAndPersistence();
        return new QueueBrowser(this, queue, messageSelector);
    }

    private void createTopicSessionAndIsClosingAndPersistence() throws JMSException {
        if (this instanceof TopicSession) {
            throw new IllegalStateException("Cannot create QueueBrowser from a TopicSession");
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.m_jconnection.checkPersistence("createBrowser");
    }

    public final javax.jms.MessageConsumer createConsumer(javax.jms.Destination destination) throws JMSException {
        MessageConsumer consumer = null;
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.m_jconnection.checkPersistence("createConsumer");
        Destination d = this.validateConsumerDestination(destination);
        if (d.isQueue()) {
            consumer = new QueueReceiver(this, (Queue)destination);
        } else if (d.isTopic()) {
            consumer = new TopicSubscriber(this, (javax.jms.Topic)destination);
        }
        return consumer;
    }

    public final javax.jms.MessageConsumer createConsumer(javax.jms.Destination destination, String messageSelector) throws JMSException {
        MessageConsumer consumer = null;
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.m_jconnection.checkPersistence("createConsumer");
        Destination d = this.validateConsumerDestination(destination);
        if (d.isQueue()) {
            consumer = new QueueReceiver(this, (Queue)destination, messageSelector);
        } else if (d.isTopic()) {
            consumer = new TopicSubscriber(this, (javax.jms.Topic)destination, messageSelector, false);
        }
        return consumer;
    }

    public MessageConsumer createConsumer(javax.jms.Destination destination, String messageSelector, IMessageHandler ihr) throws JMSException {
        MessageConsumer consumer = null;
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.m_jconnection.checkPersistence("createConsumer");
        Destination d = this.validateConsumerDestination(destination);
        if (d.isQueue()) {
            consumer = new QueueReceiver(this.m_jconnection, this, (Queue)destination, messageSelector, ihr);
        } else if (d.isTopic()) {
            consumer = new TopicSubscriber(this.m_jconnection, this, (javax.jms.Topic)destination, messageSelector, ihr);
        }
        return consumer;
    }

    public javax.jms.MessageProducer createProducer(javax.jms.Destination destination) throws JMSException {
        MessageProducer producer = null;
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        producer = destination instanceof Queue ? new QueueSender(this, (Queue)destination) : (destination instanceof javax.jms.Topic ? new TopicPublisher(this, (javax.jms.Topic)destination) : new MessageProducer(this, destination));
        if (this.isDefaultToPersistentDelivery()) {
            producer.setDeliveryMode(2);
        }
        return producer;
    }

    public final javax.jms.MessageConsumer createConsumer(javax.jms.Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        MessageConsumer consumer = null;
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.m_jconnection.checkPersistence("createConsumer");
        Destination d = this.validateConsumerDestination(destination);
        if (d.isQueue()) {
            consumer = new QueueReceiver(this, (Queue)destination, messageSelector);
        } else if (d.isTopic()) {
            consumer = new TopicSubscriber(this, (javax.jms.Topic)destination, messageSelector, NoLocal);
        }
        return consumer;
    }

    public javax.jms.MessageConsumer createSharedConsumer(javax.jms.Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.createSharedConsumer(topic, sharedSubscriptionName, NO_MESSAGE_SELECTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.jms.MessageConsumer createSharedConsumer(javax.jms.Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            Topic sharedTopic = SharedSubscriptionUtil.createSharedTopic(topic, sharedSubscriptionName, this.m_jconnection);
            SharedSubscriptionUtil.checkSharedSubscriptionRequest(sharedTopic, sharedSubscriptionName, messageSelector, this.m_clientId, this.m_consumers);
            return this.createConsumer(sharedTopic, messageSelector);
        }
    }

    public final javax.jms.TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this instanceof QueueSession) {
            throw new IllegalStateException("Cannot create TemporaryTopic from a QueueSession");
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.m_jconnection.checkPersistence("createTemporaryTopic");
        return new TemporaryTopic(this);
    }

    public final javax.jms.Topic createTopic(String topicName) throws JMSException {
        if (this instanceof QueueSession) {
            throw new IllegalStateException("Cannot create Topic from a QueueSession");
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return DestinationFactory.createTopic(topicName);
    }

    public final Queue createQueue(String queueName) throws JMSException {
        if (this instanceof TopicSession) {
            throw new IllegalStateException("Cannot create Queue from a TopicSession");
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return DestinationFactory.createQueue(queueName);
    }

    public final progress.message.jclient.MultiTopic createMultiTopic() throws JMSException {
        if (this instanceof QueueSession) {
            throw new IllegalStateException("Cannot create MultiTopic from a QueueSession");
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        return DestinationFactory.createMultiTopic();
    }

    public javax.jms.TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.createTemporaryQueue("");
    }

    public javax.jms.TemporaryQueue createTemporaryQueue(String customID) throws JMSException {
        if (this instanceof TopicSession) {
            throw new IllegalStateException("Cannot create TemporaryQueue from a TopicSession");
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.m_jconnection.checkPersistence("createTemporaryQueue");
        long connectID = this.m_jconnection.getConnectionID();
        long brokerID = this.m_jconnection.getBrokerID();
        String routingNodeName = this.m_jconnection.getRoutingNodeName();
        String uniqueID = customID + connectID + brokerID + routingNodeName;
        TemporaryQueue queue = new TemporaryQueue(this, true, uniqueID);
        return queue;
    }

    public final javax.jms.TemporaryQueue createGlobalTemporaryQueue(String uniqueId) throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.m_jconnection.checkPersistence("createGlobalTemporaryQueue");
        TemporaryQueue queue = new TemporaryQueue(this, true, uniqueId);
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDurableSubscriber(String name, DurableSubscriber subscriber) throws JMSException {
        DurableSubscriber previousSubscriber = this.m_durableSubscribers.put(name, subscriber);
        if (previousSubscriber != null) {
            this.unsubscribe(previousSubscriber);
        }
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (this.m_deliveryStarted) {
                subscriber.start();
            }
        }
    }

    final void removeDurableSubscriber(String name) {
        this.m_durableSubscribers.remove(name);
    }

    private final void unsubscribe(DurableSubscriber sub) throws JMSException {
        try {
            sub.unsubscribe();
        }
        catch (ENotConnected e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    final void startSAP() {
        if (this.m_acknowledgeQueue == null) {
            this.m_acknowledgeQueue = new SessionAcknowledgeQueue(this);
        }
        if (this.m_sap == null) {
            this.m_sap = new SessionAcknowledgeProcessor(this);
            this.m_sap.setDaemon(true);
            this.m_sap.start();
        }
    }

    final SessionAcknowledgeQueue getAcknowledgeQueue() {
        return this.m_acknowledgeQueue;
    }

    public final void unsubscribe(String name) throws JMSException {
        if (this instanceof QueueSession) {
            throw new IllegalStateException("Cannot unsubscribe a DurableSubscriber from a QueueSession");
        }
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        progress.message.zclient.Connection tmp_zconnection = null;
        try {
            if (this.m_zconnection.getBrokerSessionVer() >= 28) {
                this.m_zconnection.getInternalSession().unsubscribeDurable(name, this.m_clientId);
                return;
            }
            String appId = SessionConfig.createDurableAppid(this.m_clientId, name, false);
            tmp_zconnection = new progress.message.zclient.Connection(appId, null, new DummyHandler());
            long parentID = this.m_zconnection.getClientId();
            tmp_zconnection.connect(this.m_jconnection.m_zconnection, parentID);
            Subscription[] subs = tmp_zconnection.getBrokerSubscriptions();
            Session.disconnectLogicalConnection(subs, tmp_zconnection);
            if (subs.length == 0) {
                appId = SessionConfig.createDurableAppid(this.m_clientId, name, true);
                tmp_zconnection = new progress.message.zclient.Connection(appId, null, new DummyHandler());
                parentID = this.m_zconnection.getClientId();
                tmp_zconnection.connect(this.m_jconnection.m_zconnection, parentID);
                subs = tmp_zconnection.getBrokerSubscriptions();
                Session.disconnectLogicalConnection(subs, tmp_zconnection);
                if (subs.length == 0) {
                    throw new EClientNotRegistered();
                }
            }
        }
        catch (EClientNotRegistered ensf) {
            if (tmp_zconnection != null) {
                tmp_zconnection.cleanUp();
            }
            throw new InvalidDestinationException(prAccessor.getString("DUR_SUB_DOES_NOT_EXIST"));
        }
        catch (EUserAlreadyConnected e) {
            if (tmp_zconnection != null) {
                tmp_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(prAccessor.getString("DUR_SUB_ALREADY_ACTIVE"), e);
        }
        catch (EInvalidApplicationId e) {
            if (tmp_zconnection != null) {
                tmp_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EDefaultHandlerNotSet e) {
            if (tmp_zconnection != null) {
                tmp_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EInvalidUserId e) {
            if (tmp_zconnection != null) {
                tmp_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENoSubscribersFound e) {
            if (tmp_zconnection != null) {
                tmp_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            if (tmp_zconnection != null) {
                tmp_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private static void disconnectLogicalConnection(Subscription[] subs, progress.message.zclient.Connection tmp_zconnection) throws EGeneralException {
        if (subs.length == 1) {
            subs[0].cancel();
        }
        tmp_zconnection.disconnect(false);
    }

    public javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic topic, String name) throws JMSException {
        this.checkIsClosingValidateAndCheckCreateDurableSubscriber(topic);
        return new DurableSubscriber(this.m_jconnection, this, name, topic);
    }

    public javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic topic, String name, long timeToLive) throws JMSException {
        this.checkIsClosingValidateAndCheckCreateDurableSubscriber(topic);
        return new DurableSubscriber(this.m_jconnection, this, name, topic, timeToLive);
    }

    public javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkIsClosingValidateAndCheckCreateDurableSubscriber(topic);
        return new DurableSubscriber(this.m_jconnection, this, name, topic, messageSelector, noLocal);
    }

    public javax.jms.MessageConsumer createDurableConsumer(javax.jms.Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name);
    }

    public javax.jms.MessageConsumer createDurableConsumer(javax.jms.Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public javax.jms.MessageConsumer createSharedDurableConsumer(javax.jms.Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.createSharedDurableConsumer(topic, sharedSubscriptionName, NO_MESSAGE_SELECTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.jms.MessageConsumer createSharedDurableConsumer(javax.jms.Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            Topic sharedTopic = SharedSubscriptionUtil.createSharedTopic(topic, sharedSubscriptionName, this.m_jconnection);
            SharedSubscriptionUtil.checkSharedDurableSubscriptionRequest(sharedTopic, sharedSubscriptionName, messageSelector, this.m_clientId, this.m_durableSubscribers);
            this.m_jconnection.checkPersistence(METHOD_NAME_CREATE_SHARED_DURABLE_CONSUMER);
            return new DurableSubscriber(this.m_jconnection, this, sharedSubscriptionName, sharedTopic, messageSelector, false);
        }
    }

    public javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic topic, String name, String messageSelector, boolean noLocal, long timeToLive) throws JMSException {
        this.checkIsClosingValidateAndCheckCreateDurableSubscriber(topic);
        return new DurableSubscriber(this.m_jconnection, this, name, topic, messageSelector, noLocal, timeToLive);
    }

    private void checkIsClosingValidateAndCheckCreateDurableSubscriber(javax.jms.Topic topic) throws JMSException {
        if (this.isClosing()) {
            throw this.getJMSObjectClosedException();
        }
        this.validateConsumerDestination(topic);
        this.m_jconnection.checkPersistence("createDurableSubscriber");
    }

    public void setFlowControlDisabled(boolean disabled) {
        this.m_zconnection.setFlowControlDisabled(disabled);
    }

    public boolean isFlowControlDisabled() {
        return this.m_zconnection.isFlowControlDisabled();
    }

    public final void setDurableMessageOrder(boolean durableSubscriberMessageOrder) {
        this.m_sessionDurableMessageOrder = durableSubscriberMessageOrder;
        this.m_useDurableMessageOrderSetting = true;
    }

    public final boolean getDurableMessageOrder() {
        if (this.m_useDurableMessageOrderSetting) {
            return this.m_sessionDurableMessageOrder;
        }
        return this.m_jconnection.isDurableMessageOrderEnabled();
    }

    public final boolean useTopicSessionDurableMessageOrder() {
        return this.m_useDurableMessageOrderSetting;
    }

    public final void setFlowToDisk(int setting) {
        if (setting <= 2) {
            this.m_flowToDisk = setting;
        }
    }

    public void setSendTimeout(int milliseconds) throws JMSException {
        if (milliseconds > 0) {
            if (this.m_transacted) {
                throw new JMSException("Send timeout not supported for transacted sessions.");
            }
            if (this.m_jconnection.getZConnectionFactory().isPersistenceEnabled()) {
                throw new JMSException("Send timeout not supported with Client Persistence.");
            }
            this.m_sendTimeoutMs = milliseconds < 100 ? 100 : milliseconds;
        } else {
            this.m_sendTimeoutMs = 0;
        }
    }

    public int getSendTimeout() {
        return this.m_sendTimeoutMs;
    }

    public final void setSplitMultiTopicDelivery(boolean value) {
        this.m_splitMultiTopicDelivery = value;
    }

    public boolean getSplitMultiTopicDelivery() {
        return this.m_splitMultiTopicDelivery;
    }

    final int getAsyncDeliveryMode() {
        return this.m_asyncDeliveryMode;
    }

    final int getDeliveryDoubtWindow() {
        return this.m_deliveryDoubtWindow;
    }

    final long getDeliveryCloseTimeout() {
        return this.m_deliveryCloseTimeout;
    }

    public int getFlowToDisk() {
        return this.m_flowToDisk;
    }

    public String getSessionName() {
        return this.m_name;
    }

    protected void assertTempDestIsDeletable(javax.jms.Destination dest) throws JMSException {
        String destName = null;
        if (dest == null || this.isClosing()) {
            return;
        }
        destName = dest instanceof Queue ? ((Queue)dest).getQueueName() : ((javax.jms.Topic)dest).getTopicName();
        Enumeration consumers = ((Vector)this.m_consumers.clone()).elements();
        while (consumers.hasMoreElements()) {
            Destination d;
            MessageConsumer consumer = (MessageConsumer)consumers.nextElement();
            if (consumer.isClosing()) continue;
            if (consumer instanceof QueueReceiver) {
                try {
                    if (!destName.equals(((QueueReceiver)consumer).getQueue().getQueueName())) continue;
                    throw new JMSException("A MessageConsumer is still active for " + destName);
                }
                catch (IllegalStateException illegalStateException) {
                    continue;
                }
            }
            if (!(consumer instanceof TopicSubscriber) || (!(d = (Destination)DestinationFactory.createSonicDestination(((TopicSubscriber)consumer).getTopic())).isMultiDestination() || !((MultiDestination)d).contains(dest)) && !destName.equals(d.getDestinationName())) continue;
            throw new JMSException("A MessageConsumer is still active for " + destName);
        }
        Enumeration dsubs = ((Hashtable)this.m_durableSubscribers.clone()).elements();
        while (dsubs.hasMoreElements()) {
            Destination d;
            DurableSubscriber consumer = (DurableSubscriber)dsubs.nextElement();
            if (consumer.isClosing() || (!(d = (Destination)DestinationFactory.createSonicDestination(consumer.getTopic())).isMultiDestination() || !((MultiDestination)d).contains(dest)) && !destName.equals(d.getDestinationName())) continue;
            throw new JMSException("A DurableSubscriber is still active for " + destName);
        }
        Enumeration browsers = ((Vector)this.m_browsers.clone()).elements();
        while (browsers.hasMoreElements()) {
            QueueBrowser browser = (QueueBrowser)browsers.nextElement();
            if (browser.isClosing() || !destName.equals(browser.getQueue().getQueueName())) continue;
            throw new JMSException("A QueueBrowser is still active for " + destName);
        }
    }

    private final Destination validateConsumerDestination(javax.jms.Destination destination) throws JMSException {
        return SharedSubscriptionUtil.convertToConsumerDestination(destination, this.m_jconnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message getNextMessage(MessageConsumer consumer) throws JMSException {
        Message msg = null;
        while ((msg = consumer.getReceivedMessagesQueue().nextMessageIfAny()) != null) {
            if ((msg = consumer.checkUndeliverable(msg)) != null) {
                return msg;
            }
            Object object = this.m_closeSyncObject;
            synchronized (object) {
                block10: {
                    if (consumer.isClosing()) {
                        return null;
                    }
                    if (this.isClosing()) {
                        return null;
                    }
                    if (consumer instanceof QueueReceiver) {
                        try {
                            ((QueueReceiver)consumer).makeGetRequest();
                        }
                        catch (EGeneralException ex) {
                            if (!this.DEBUG) break block10;
                            this.debug(ex.toString(), ex);
                        }
                    }
                }
            }
        }
        return msg;
    }

    private void handleJMSExceptionOnDelivery(JMSException e, boolean isCC) {
        boolean raiseException = true;
        if (this.m_thread.isStopped()) {
            Exception el = e.getLinkedException();
            if (!isCC && el != null && el instanceof ENetworkFailure) {
                raiseException = false;
            }
            if (el != null && el instanceof EInterrupted) {
                raiseException = false;
            }
        }
        if (raiseException) {
            this.m_jconnection.onException(e);
        }
    }

    void beginWaitForSession() {
        this.m_jconnection.beginWaitForSession(this);
    }

    void endWaitForSession() {
        this.m_jconnection.endWaitForSession(this);
    }

    private boolean isWaitingForSession(Thread thread) {
        return this.m_jconnection.isWaitingForSession(thread, this);
    }

    private void addDispatcher(Thread dispatcher) {
        this.m_jconnection.addDispatcher(dispatcher, this);
    }

    private void removeDispatcher(Thread dispatcher) {
        this.m_jconnection.removeDispatcher(dispatcher);
    }

    private class ClientAcknowledgedMessageHolder {
        Message heldMessage = null;

        ClientAcknowledgedMessageHolder() {
        }

        Message getMessage() {
            return this.heldMessage;
        }

        void setMessage(Message msg) {
            this.heldMessage = msg;
        }
    }

    private class DefaultIHandler
    implements IMessageHandler {
        private DefaultIHandler() {
        }

        @Override
        public void handleMessage(progress.message.zclient.Session session, Envelope envelope) {
            block3: {
                if (envelope.getSubject().getSubjectString().equals("$SYS.TRANSACTION.IDLE_TIMEOUT")) {
                    try {
                        Session.this.close(CloseType.CLOSE_TXN_TIMEOUT);
                        Session.this.m_jconnection.onException(JMSExceptionUtil.createJMSException(prAccessor.getString(Session.SESSION_CLOSED_TXN_TIMEOUT), "-23", null));
                    }
                    catch (JMSException jmse) {
                        if (!SessionConfig.DEBUG) break block3;
                        Session.this.debug(jmse.toString(), jmse);
                    }
                }
            }
            envelope.handlerDone(Session.this.m_zmessageHandler.isGuaranteed(), false);
        }
    }

    private class DummyHandler
    extends MessageHandler {
        private DummyHandler() {
        }

        @Override
        public void handleMessage(progress.message.zclient.Session s, Envelope env) {
        }
    }

    private final class SessionThread
    extends Thread {
        SessionThread() {
            super("JMS Session Delivery Thread" + (Session.this.m_zconnection == null ? "" : " - " + Session.this.m_zconnection.getApplicationId() + ':' + Session.this.m_zconnection.getClientId()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Session.this.run();
            }
            finally {
                Session.this.removeDispatcher(Thread.currentThread());
                Object object = Session.this.m_closeSyncObject;
                synchronized (object) {
                    Session.this.m_threadExited = true;
                    if (!Session.this.wasClosedInternally()) {
                        Session.this.m_thread = null;
                    }
                    Session.this.m_closeSyncObject.notifyAll();
                }
            }
        }

        public void setStopped() {
            Session.this.setStopped();
        }

        public boolean isStopped() {
            return Session.this.isStopped();
        }
    }

    private static final class ListenerMessageBinding {
        MessageListener m_listener;
        Message m_message;

        ListenerMessageBinding(MessageListener listener, Message message) {
            this.m_listener = listener;
            this.m_message = message;
        }
    }

    protected static final class CloseType {
        public static final CloseType CLOSE_EXTERNAL = new CloseType();
        public static final CloseType CLOSE_INTERNAL = new CloseType();
        public static final CloseType CLOSE_TXN_TIMEOUT = new CloseType();

        private CloseType() {
        }
    }
}

