/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.IOException;
import java.io.InputStream;
import progress.message.util.StreamUtil;

final class StreamUtilCounter {
    private int m_count = 0;

    StreamUtilCounter() {
    }

    public short readShort(InputStream is) throws IOException {
        this.m_count += 2;
        return StreamUtil.readShort(is);
    }

    public long readLong(InputStream is) throws IOException {
        this.m_count += 8;
        return StreamUtil.readLong(is);
    }

    public long read6ByteLong(InputStream is) throws IOException {
        this.m_count += 6;
        return StreamUtil.read6ByteLong(is);
    }

    public int readInt(InputStream is) throws IOException {
        this.m_count += 4;
        return StreamUtil.readInt(is);
    }

    public byte[] readUTFString(InputStream is) throws IOException {
        byte[] returnVal = StreamUtil.readUTFString(is);
        this.m_count += returnVal.length;
        return returnVal;
    }

    public void readBytes(InputStream is, byte[] target, int offset, int length) throws IOException {
        this.m_count += length;
        StreamUtil.readBytes(is, target, offset, length);
    }

    public byte readByte(InputStream is) throws IOException {
        ++this.m_count;
        return StreamUtil.readByte(is);
    }

    public void resetCounter() {
        this.m_count = 0;
    }

    public int getCounter() {
        return this.m_count;
    }

    public void incrementCounter(int value) {
        this.m_count += value;
    }
}

