/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentSubjectSpace;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPrincipal;

public final class NewGroupEvent
extends SecurityEvent {
    NewGroupEvent(SecurityBean source, long starttime, int vtime, ProgressGroup group) {
        super(source, starttime, vtime);
        this.m_group = group;
    }

    NewGroupEvent() {
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processNewGroupEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
    }

    @Override
    short getType() {
        return 9;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_group.getName());
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        super.unserialize(in, cache);
        String groupname = in.readUTF();
        ProgressPrincipal p = cache.getPrincipal(groupname);
        this.m_group = p instanceof ProgressGroup ? (ProgressGroup)p : new ProgressGroup(groupname);
    }
}

