/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import progress.message.util.DebugFilterData;
import progress.message.util.FilterTypeEnumeration;
import progress.message.zclient.SessionConfig;

public class DebugFilterManager {
    public static final String FILTER_START_TOKEN = "[";
    public static final String FILTER_END_TOKEN = "]";
    protected static final String FILTER_SEPARATOR = ",";
    protected static final String FILTER_VALUE_SEPARATOR = "|";
    private Hashtable<String, Hashtable<String, IFilter>> filters = new Hashtable();
    private static DebugFilterManager debugFilterManager = new DebugFilterManager();
    private boolean evaluateFilters = true;

    public static final DebugFilterManager getInstance() {
        return debugFilterManager;
    }

    private DebugFilterManager() {
    }

    public boolean isValidFilterName(String filterName) {
        return null != FilterTypeEnumeration.fromString(filterName);
    }

    public void parseFilterValue(String className, String filterValueParam) {
        String filterValue = filterValueParam;
        if (filterValue.startsWith(FILTER_START_TOKEN)) {
            filterValue = filterValue.substring(1);
        }
        if (filterValue.endsWith(FILTER_END_TOKEN)) {
            filterValue = filterValue.substring(0, filterValue.length() - 1);
        }
        this.resetFilterValues(className);
        StringTokenizer st = new StringTokenizer(filterValue, FILTER_SEPARATOR);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            String value = "";
            String name = "";
            int i = entry.indexOf("=");
            if (i > -1) {
                IFilter filter;
                name = entry.substring(0, i);
                if (!this.isValidFilterName(name)) {
                    SessionConfig.logln("Invalid filter name: " + name);
                    continue;
                }
                value = entry.substring(i + 1);
                FilterTypeEnumeration.Type type = FilterTypeEnumeration.fromString(name).getType();
                if (FilterTypeEnumeration.Type.STRING == type) {
                    filter = new StringFilter(value);
                    this.addFilter(name, filter, className);
                    continue;
                }
                filter = new BooleanFilter(Boolean.parseBoolean(value));
                this.addFilter(name, filter, className);
                continue;
            }
            SessionConfig.logln("Improperly formatted filter " + entry + ": missing =");
        }
    }

    private void addFilter(String name, IFilter filter, String className) {
        Hashtable<String, IFilter> filterTable = this.filters.get(className);
        if (null == filterTable) {
            filterTable = new Hashtable();
            this.filters.put(className, filterTable);
        }
        filterTable.put(name, filter);
        this.evaluateFilters = true;
    }

    public boolean isFilteredOut(DebugFilterData filterData) {
        if (null == filterData) {
            SessionConfig.logln("filterData cannot be null");
            return false;
        }
        if (filterData.getState() == DebugFilterData.State.FILTERED_OUT && !this.evaluateFilters) {
            return true;
        }
        if (filterData.getState() == DebugFilterData.State.FILTERED_IN && !this.evaluateFilters) {
            return false;
        }
        String className = filterData.getClassName();
        if (this.filters.isEmpty()) {
            return false;
        }
        Hashtable<String, IFilter> filterTable = this.filters.get(className);
        if (null == filterTable || filterTable.isEmpty()) {
            return false;
        }
        boolean filterOut = false;
        for (String name : filterTable.keySet()) {
            IFilter filter = filterTable.get(name);
            String data = filterData.get(name);
            if (null == filter || filter.matches(data)) continue;
            filterOut = true;
            break;
        }
        if (filterOut) {
            filterData.setState(DebugFilterData.State.FILTERED_OUT);
        } else {
            filterData.setState(DebugFilterData.State.FILTERED_IN);
        }
        this.evaluateFilters = false;
        return filterOut;
    }

    public void resetFilterValues(String className) {
        this.filters = new Hashtable();
        for (FilterTypeEnumeration type : FilterTypeEnumeration.values()) {
            if (null == type.getDefaultValue()) continue;
            if (type.getType() == FilterTypeEnumeration.Type.BOOLEAN) {
                boolean defaultValue = Boolean.parseBoolean(type.getDefaultValue());
                BooleanFilter filter = new BooleanFilter(defaultValue);
                this.addFilter(type.getName(), filter, className);
                continue;
            }
            if (type.getType() != FilterTypeEnumeration.Type.STRING) continue;
            StringFilter filter = new StringFilter(type.getDefaultValue());
            this.addFilter(type.getName(), filter, className);
        }
        this.evaluateFilters = true;
    }

    private class BooleanFilter
    implements IFilter {
        private boolean value;

        public BooleanFilter(boolean value) {
            this.value = value;
        }

        @Override
        public boolean matches(String data) {
            return this.value || !Boolean.parseBoolean(data);
        }
    }

    private class StringFilter
    implements IFilter {
        private HashSet<String> values = new HashSet();

        public StringFilter(String value) {
            this.parseValue(value);
        }

        private final void parseValue(String value) {
            if (null != value && value.indexOf(DebugFilterManager.FILTER_VALUE_SEPARATOR) != -1) {
                StringTokenizer tokenizer = new StringTokenizer(value, DebugFilterManager.FILTER_VALUE_SEPARATOR);
                while (tokenizer.hasMoreTokens()) {
                    this.values.add(tokenizer.nextToken());
                }
            } else {
                this.values.add(value);
            }
        }

        @Override
        public boolean matches(String data) {
            for (String value : this.values) {
                if (null == data && null != value) {
                    return false;
                }
                if (null == data) {
                    return true;
                }
                if (null != value && -1 == data.indexOf(value)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface IFilter {
        public boolean matches(String var1);
    }
}

