/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mq.common.runtime.IAcceptorData;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;

public class AcceptorData
implements IAcceptorData,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final short CURRENT_VERSION = 0;
    private static final String ACCEPTOR_NAME = "ACCEPTOR_NAME";
    private static final String ACCEPTOR_PROTOCOL = "ACCEPTOR_PROTOCOL";
    private static final String ACCEPTOR_URL = "ACCEPTOR_URL";
    private static final String ACCEPTOR_PORT = "ACCEPTOR_PORT";
    private static final String ACCEPTOR_EXTERNAL_URL = "ACCEPTOR_EXTERNAL_URL";
    private static final String ACCEPTOR_STATE = "ACCEPTOR_STATE";
    private static final String ACCEPTOR_CONNECTION_COUNT = "ACCEPTOR_CONNECTION_COUNT";
    private Properties m_acceptorData = null;

    public AcceptorData() {
    }

    public AcceptorData(Properties acceptorData) {
        this.m_acceptorData = acceptorData;
    }

    public AcceptorData(String acceptorName, String protocol, String URL2, String externalURL, int port, int state, int connectionCount) {
        this.setAcceptorName(acceptorName);
        this.setProtocol(protocol);
        this.setURL(URL2);
        this.setExternalURL(externalURL);
        this.setPort(port);
        this.setAcceptorState(state);
        this.setConnectionCount(connectionCount);
    }

    @Override
    public String getAcceptorName() {
        return this.retrieveProperty(ACCEPTOR_NAME);
    }

    @Override
    public int getAcceptorState() {
        if (this.m_acceptorData == null) {
            return 0;
        }
        return Integer.parseInt(this.m_acceptorData.getProperty(ACCEPTOR_STATE));
    }

    @Override
    public String getProtocol() {
        return this.retrieveProperty(ACCEPTOR_PROTOCOL);
    }

    @Override
    public String getExternalURL() {
        return this.retrieveProperty(ACCEPTOR_EXTERNAL_URL);
    }

    @Override
    public String getURL() {
        return this.retrieveProperty(ACCEPTOR_URL);
    }

    private String retrieveProperty(String propertyNamee) {
        if (this.m_acceptorData == null) {
            return null;
        }
        return this.m_acceptorData.getProperty(propertyNamee);
    }

    @Override
    public int getPort() {
        return this.parsePropertyInt(ACCEPTOR_PORT);
    }

    @Override
    public int getConnectionCount() {
        return this.parsePropertyInt(ACCEPTOR_CONNECTION_COUNT);
    }

    private int parsePropertyInt(String propertyName) {
        if (this.m_acceptorData == null) {
            return -1;
        }
        return Integer.parseInt(this.m_acceptorData.getProperty(propertyName));
    }

    public final void setAcceptorName(String acceptorName) {
        this.initAcceptorData();
        this.m_acceptorData.setProperty(ACCEPTOR_NAME, acceptorName);
    }

    public final void setAcceptorState(int state) {
        this.initAcceptorData();
        this.m_acceptorData.setProperty(ACCEPTOR_STATE, String.valueOf(state));
    }

    public final void setProtocol(String protocol) {
        this.initAcceptorData();
        this.m_acceptorData.setProperty(ACCEPTOR_PROTOCOL, protocol);
    }

    public final void setExternalURL(String externalURL) {
        this.initAcceptorData();
        this.m_acceptorData.setProperty(ACCEPTOR_EXTERNAL_URL, externalURL);
    }

    public final void setURL(String URL2) {
        this.initAcceptorData();
        this.m_acceptorData.setProperty(ACCEPTOR_URL, URL2);
    }

    public final void setPort(int port) {
        this.initAcceptorData();
        this.m_acceptorData.setProperty(ACCEPTOR_PORT, String.valueOf(port));
    }

    public final void setConnectionCount(int count) {
        this.initAcceptorData();
        this.m_acceptorData.setProperty(ACCEPTOR_CONNECTION_COUNT, String.valueOf(count));
    }

    private void initAcceptorData() {
        if (this.m_acceptorData == null) {
            this.m_acceptorData = new Properties();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[name=").append(this.getAcceptorName()).append(']');
        sb.append("[protocol=").append(this.getProtocol()).append(']');
        sb.append("[url=").append(this.getURL()).append(']');
        sb.append("[port=").append(this.getPort()).append(']');
        sb.append("[external url=").append(this.getExternalURL()).append(']');
        sb.append("[state=").append(this.getAcceptorState() == 3 ? "online" : "offline").append(']');
        sb.append("[connection count=").append(this.getConnectionCount()).append(']');
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(0);
        stream.writeObject(this.m_acceptorData);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        short version = stream.readShort();
        switch (version) {
            case 0: {
                this.m_acceptorData = (Properties)stream.readObject();
                break;
            }
            default: {
                throw new InvalidObjectException("Unsupported Sonic management version - class: " + this.getClass().getName() + ", version: " + version);
            }
        }
    }
}

