/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.ws;

import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.wsdl.WSDLContext;
import java.net.URL;
import java.util.Hashtable;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class WSDLCache
extends DebugObject {
    private static final String DEBUG_NAME = "WSDLCache ";
    private static final String ESB_WSDL_WORKSPACE = "sonicfs:///workspace";
    private Hashtable m_hashtable = new Hashtable();

    public WSDLCache() {
        super(DebugState.GLOBAL_DEBUG_ON ? DEBUG_NAME : null);
    }

    public Hashtable getWSDLHashtable() {
        return this.m_hashtable;
    }

    public synchronized void addWSDL(String wsdlLocation, String requestPath, WSDLContext context) {
        block5: {
            String fileName = this.getWSDLFileName(wsdlLocation);
            if (fileName == null) {
                return;
            }
            try {
                IElement ie = BrokerComponent.getComponentContext().registerFileChangeInterest(fileName);
                if (this.DEBUG) {
                    this.debug("registerFileChangeInterest returned " + ie);
                }
                Hashtable ctxTable = null;
                ctxTable = this.m_hashtable.containsKey(fileName) ? (Hashtable)this.m_hashtable.get(fileName) : new Hashtable();
                this.addToTable(ctxTable, requestPath, context);
                this.m_hashtable.put(fileName, ctxTable);
                if (this.DEBUG) {
                    this.debug("cache WSDL for " + fileName + ";" + requestPath);
                }
            }
            catch (Exception e) {
                if (!this.DEBUG) break block5;
                e.printStackTrace();
            }
        }
    }

    private synchronized void addToTable(Hashtable ctxTable, String requestPath, WSDLContext context) {
        if (ctxTable.containsKey(requestPath)) {
            ctxTable.remove(requestPath);
        }
        ctxTable.put(requestPath, context);
    }

    public synchronized WSDLContext getWSDL(String wsdlLocation, String requestPath) {
        Hashtable ctxTable;
        if (this.DEBUG) {
            this.debug("getWSDL on wsdlLocation " + wsdlLocation);
        }
        if (wsdlLocation.startsWith(ESB_WSDL_WORKSPACE)) {
            if (this.DEBUG) {
                this.debug("no chche on this one ");
            }
            return null;
        }
        String fileName = this.getWSDLFileName(wsdlLocation);
        if (this.DEBUG) {
            this.debug("get WSDL cache for " + fileName + ";" + requestPath);
        }
        if (fileName != null && this.m_hashtable.containsKey(fileName) && (ctxTable = (Hashtable)this.m_hashtable.get(fileName)) != null) {
            WSDLContext ctx = (WSDLContext)ctxTable.get(requestPath);
            if (this.DEBUG) {
                this.debug("found cache " + ctx);
            }
            return ctx;
        }
        if (this.DEBUG) {
            this.debug("found no cache ");
        }
        return null;
    }

    public synchronized void onFileUpdate(String fileName) {
        if (this.DEBUG) {
            this.debug("Got file update notification for " + fileName);
        }
        if (fileName == null) {
            return;
        }
        if (this.m_hashtable.containsKey(fileName)) {
            Hashtable t = (Hashtable)this.m_hashtable.get(fileName);
            this.m_hashtable.remove(fileName);
            Object var2_2 = null;
        }
    }

    private String getWSDLFileName(String wsdlLocation) {
        String fileName = null;
        try {
            URL url = new URL(wsdlLocation);
            if (url != null) {
                fileName = url.getFile();
            }
        }
        catch (Exception e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        return fileName;
    }
}

