/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.pcs;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.PluggableMessageProtection;
import com.sonicsw.util.debug.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;

public class PluggableSecureInputStream
extends InputStream
implements ISecureInputStream {
    private static final boolean DEBUG_TRACE_DATA = false;
    private Cipher m_mkCipher;
    private int m_bytesInCipher = 0;
    private static final int MAX_BUFFER_MULTIPLIER = 1024;
    private PluggableMessageProtection m_mp = null;
    private byte[] m_key = null;
    private InputStream m_is = null;
    private byte[] m_buffer = null;
    private int m_location = -1;
    private int m_blockSize = 0;
    private int m_bufferSize = 0;
    private int m_bytesExpected = -1;

    public PluggableSecureInputStream() {
        this.m_mp = null;
        this.m_is = null;
        this.m_key = null;
        this.m_blockSize = 0;
        this.m_buffer = null;
    }

    public PluggableSecureInputStream(InputStream is, IMessageProtection mp, byte[] buffer) {
        this.initSecureInputStream(is, mp, null);
    }

    @Override
    public final void initSecureInputStream(InputStream is, IMessageProtection mp, byte[] buffer) {
        this.m_mp = (PluggableMessageProtection)mp;
        this.m_is = is;
        this.m_key = null;
        this.m_blockSize = this.m_mp.getBlockSize();
        this.m_buffer = buffer == null ? new byte[this.m_blockSize * 1024] : buffer;
    }

    @Override
    public InputStream getInputStream() {
        return this;
    }

    @Override
    public final void setMessageKey(byte[] rawKey) {
        this.m_key = rawKey;
        try {
            Key key = null;
            if (AbstractCipherSuite.s_cipherAlgorithm.equalsIgnoreCase("DES") || AbstractCipherSuite.s_cipherAlgorithm.equalsIgnoreCase("DESEDE") || AbstractCipherSuite.s_cipherAlgorithm.equalsIgnoreCase("AES") || AbstractCipherSuite.s_cipherAlgorithm.equalsIgnoreCase("Blowfish")) {
                key = this.keygen(AbstractCipherSuite.m_isKeySizeSupplied, AbstractCipherSuite.s_cipherAlgorithm, this.m_key);
            } else {
                SecretKeySpec keySpec = new SecretKeySpec(this.m_key, AbstractCipherSuite.s_cipherAlgorithm);
                key = keySpec;
            }
            if (this.m_mkCipher == null) {
                this.m_mkCipher = AbstractCipherSuite.getNewCipherInstance(AbstractCipherSuite.s_cipherTransformation);
            }
            if (AbstractCipherSuite.isCipherModeECB()) {
                this.m_mkCipher.init(2, key);
            } else {
                this.m_mkCipher.init(2, key, AbstractCipherSuite.getAlgorithmParameterSpec(rawKey, 0, rawKey.length));
            }
            this.m_bytesInCipher = 0;
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException ex) {
            ex.printStackTrace();
        }
        catch (InvalidKeySpecException ex) {
            ex.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        catch (EInvalidCipherSuiteException ex) {
            ex.printStackTrace();
        }
    }

    private Key keygen(boolean keySizeSupplied, String algorithm, byte[] rawKey) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        SecretKey key = null;
        SecretKeyFactory keyFactory = null;
        if (algorithm.equalsIgnoreCase("DES")) {
            DESKeySpec keySpec = new DESKeySpec(rawKey);
            keyFactory = SecretKeyFactory.getInstance(algorithm);
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            key = secretKey;
        } else if (algorithm.equalsIgnoreCase("DESEDE")) {
            DESedeKeySpec keySpec = new DESedeKeySpec(rawKey);
            keyFactory = SecretKeyFactory.getInstance(algorithm);
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            key = secretKey;
        } else {
            SecretKeySpec keySpec;
            key = keySpec = new SecretKeySpec(rawKey, algorithm);
        }
        return key;
    }

    @Override
    public final void useSessionKey() {
        this.m_key = null;
        this.m_bytesInCipher = 0;
    }

    @Override
    public final synchronized int read() throws IOException {
        if (this.m_location >= this.m_bufferSize || this.m_location == -1) {
            this.readBlock();
        }
        return this.m_buffer[this.m_location++] & 0xFF;
    }

    @Override
    public final synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        while (count < len) {
            int destPos;
            if (this.m_location + (len - count) < this.m_bufferSize) {
                destPos = off + count;
                this.m_location = this.transferBufferUpdateCount(len, count, b, destPos, this.m_location);
                count += len - count;
                continue;
            }
            if (this.m_location + (len - count) < this.m_bufferSize || (count = this.transferBufferUpdateCount(this.m_bufferSize, this.m_location, b, destPos = off + count, count)) >= len) continue;
            this.readBlock();
        }
        return count;
    }

    private int transferBufferUpdateCount(int m_bufferSize, int m_location, byte[] b, int destPos, int countParam) {
        int count = countParam;
        int lengthToCopy = m_bufferSize - m_location;
        this.traceBufferDetails(b, destPos, lengthToCopy);
        return count += m_bufferSize - m_location;
    }

    private void traceBufferDetails(byte[] b, int destPos, int lengthToCopy) {
        System.arraycopy(this.m_buffer, this.m_location, b, destPos, lengthToCopy);
    }

    @Override
    public final synchronized long skip(long nParam) throws IOException {
        long n = nParam;
        if (n < 0L) {
            return 0L;
        }
        while ((long)this.m_location + n > (long)this.m_bufferSize) {
            n -= (long)(this.m_bufferSize - this.m_location);
            this.readBlock();
        }
        this.m_location = (int)((long)this.m_location + n);
        return n;
    }

    @Override
    public final synchronized int available() {
        return this.m_bufferSize - this.m_location;
    }

    @Override
    public final boolean markSupported() {
        return this.m_is.markSupported();
    }

    @Override
    public final void mark(int readAheadLimit) {
        this.m_is.mark(readAheadLimit);
    }

    @Override
    public final void reset() throws IOException {
        this.m_is.reset();
    }

    @Override
    public final void close() throws IOException {
        this.m_is.close();
    }

    public IMessageProtection getMessageProtection() {
        return this.m_mp;
    }

    public void doFinal() throws IOException {
    }

    private void readBlock() throws IOException {
        int bytesToRead;
        int available = this.m_is.available();
        int bufferSize = this.m_buffer.length;
        if (this.m_bytesExpected > 0) {
            bytesToRead = bufferSize < this.m_bytesExpected ? bufferSize : this.m_bytesExpected;
        } else if (available > bufferSize) {
            bytesToRead = bufferSize;
        } else if (available < this.m_blockSize) {
            bytesToRead = this.m_blockSize;
        } else {
            int remainder = available % this.m_blockSize;
            bytesToRead = available - remainder;
        }
        int tempResult = 0;
        for (int result = 0; result < bytesToRead; result += tempResult) {
            tempResult = this.m_is.read(this.m_buffer, result, bytesToRead - result);
            if (tempResult != -1) continue;
            throw new EOFException();
        }
        byte[] output = null;
        if (this.m_key == null) {
            if (this.m_bytesExpected == bytesToRead) {
                output = this.m_mp.doFinal(this.m_buffer, 0, bytesToRead);
                System.arraycopy(output, 0, this.m_buffer, 0, output.length);
                this.m_bufferSize = Math.max(bytesToRead + this.m_bytesInCipher, output.length);
                this.traceBytesToReadDetails(bytesToRead, output);
            } else {
                output = this.m_mp.update(this.m_buffer, 0, bytesToRead);
                this.cloneOutput(bytesToRead, output);
                this.traceBytesToReadDetails(bytesToRead, output);
            }
        } else if (this.m_bytesExpected == bytesToRead) {
            output = this.m_mp.doFinal(this.m_mkCipher, this.m_buffer, 0, bytesToRead);
            System.arraycopy(output, 0, this.m_buffer, 0, output.length);
            this.m_bufferSize = Math.max(bytesToRead + this.m_bytesInCipher, output.length);
        } else {
            output = this.m_mp.update(this.m_mkCipher, this.m_buffer, 0, bytesToRead);
            this.cloneOutput(bytesToRead, output);
        }
        if (this.m_bytesExpected != -1) {
            this.m_bytesExpected -= bytesToRead;
        }
        this.m_location = 0;
    }

    private void cloneOutput(int bytesToRead, byte[] output) {
        System.arraycopy(output, 0, this.m_buffer, 0, output.length);
        this.m_bytesInCipher = this.m_bytesInCipher + bytesToRead - output.length;
        this.m_bufferSize = output.length;
    }

    private void traceBytesToReadDetails(int bytesToRead, byte[] output) {
    }

    private void debugBytesDetails(int bytesToRead) {
        Debug.trace((String)(Thread.currentThread() + " bytesToRead : " + bytesToRead));
        Debug.trace((String)(Thread.currentThread() + " m_bytesExpected: " + this.m_bytesExpected));
        Debug.trace((String)(Thread.currentThread() + " m_buffer.length : " + this.m_buffer.length));
    }

    @Override
    public final void bytesExpected(int count) {
        this.m_bytesExpected = count;
        this.m_location = -1;
    }
}

