/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpRemoteBroker;
import com.sonicsw.net.http.soap.SOAPUtils;
import com.sonicsw.net.http.ws.WSHttpInRequest;
import com.sonicsw.net.http.ws.WSHttpOutRequest;
import com.sonicsw.net.http.ws.WSHttpOutResponse;
import com.sonicsw.net.http.ws.WSHttpOutboundHandler;
import com.sonicsw.ws.rm.protocol.Constants;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.MgramURLHelper;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.gr.RouteForwarder;
import progress.message.msg.IMgram;

public class HandlerUtils {
    public static HttpOutboundHandler locateHttpRoutingHandler(String transportURL) {
        IRemoteBroker rb;
        RouteForwarder rf = AgentRegistrar.getAgentRegistrar().getRouterManager().getRouteForwarder();
        String nodeName = "sonic.http";
        String httpDestURL = transportURL;
        boolean newconnect = false;
        int[] destination = null;
        String httpGroupID = null;
        RoutingConnectionInfo rci = AgentRegistrar.getAgentRegistrar().routingNodeReverseLookup(transportURL);
        if (rci != null) {
            nodeName = rci.getRoutingNodeName();
        }
        if ((rb = rf.getRemoteBroker(nodeName, destination, httpGroupID, httpDestURL, newconnect)) == null || !(rb instanceof HttpRemoteBroker)) {
            return null;
        }
        HttpRemoteBroker hrb = (HttpRemoteBroker)rb;
        return hrb.getHandler();
    }

    public static void faultOutboundMessage(MessageContext mc, AxisFault af) {
        HandlerUtils.faultOutboundMessage(mc, af, false);
    }

    public static void faultOutboundMessage(MessageContext mc, AxisFault af, boolean includeSOAP11SequenceFaultElement) {
        try {
            Constants RMConstants = (Constants)mc.getProperty("COM_SONIC_WS_RM_CONSTANTS");
            Message resp = HandlerUtils.makeFaultMessage(mc, af, includeSOAP11SequenceFaultElement, RMConstants);
            HandlerUtils.faultOutboundMessage(mc, resp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void faultOutboundMessage(MessageContext mc, Message flt) {
        try {
            IMgram m = (IMgram)mc.getProperty("progress.message.msg.IMgram");
            WSHttpOutboundHandler handler = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
            HttpLock lock = (HttpLock)mc.getProperty("com.sonicsw.net.http.HttpLock");
            WSHttpOutRequest request = (WSHttpOutRequest)mc.getProperty("com.sonicsw.net.http.HttpOutRequest");
            WSHttpOutResponse response = (WSHttpOutResponse)mc.getProperty("com.sonicsw.net.http.HttpOutResponse");
            response.setAxisResponse(flt);
            response.setResponseCode(lock.getErrorType());
            response.setResponseMessage(lock.getMessage());
            handler.onResponse(lock, m, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Message makeFaultMessage(MessageContext mc, AxisFault af, boolean includeSOAP11SequenceFaultElement, Constants RMConstants) throws Exception {
        WSHttpOutRequest request = (WSHttpOutRequest)mc.getProperty("com.sonicsw.net.http.HttpOutRequest");
        Message resp = SOAPUtils.buildFaultMessage(af, request.getSoapVersion());
        resp.getSOAPEnvelope().addNamespaceDeclaration("wsrm", RMConstants.getNSURI());
        if (request.getSoapVersion() == "SOAP 1.1" && includeSOAP11SequenceFaultElement) {
            org.apache.axis.message.SOAPEnvelope env = resp.getSOAPEnvelope();
            if (env.getHeader() == null) {
                env.addHeader();
            }
            Name name = env.createName("SequenceFault", "wsrm", RMConstants.getNSURI());
            SOAPHeaderElement headerElement = env.getHeader().addHeaderElement(name);
            QName[] qn = af.getFaultSubCodes();
            for (int i = 0; i < qn.length; ++i) {
                headerElement.addChildElement("FaultCode", "wsrm", RMConstants.getNSURI()).addTextNode(qn[i].getPrefix() + ":" + qn[i].getLocalPart());
            }
            Element[] el = af.getFaultDetails();
            for (int i = 0; i < el.length; ++i) {
                MessageElement me = new MessageElement(el[i]);
                headerElement.appendChild((Node)me);
            }
            af.clearFaultDetails();
            af.clearFaultSubCodes();
        }
        return resp;
    }

    public static void stripHeaders(SOAPEnvelope env, String URI2) throws SOAPException {
        SOAPHeader header = env.getHeader();
        if (header == null) {
            return;
        }
        Iterator iter = header.examineAllHeaderElements();
        Vector<SOAPHeaderElement> trash = new Vector<SOAPHeaderElement>();
        while (iter.hasNext()) {
            SOAPHeaderElement headerElement = (SOAPHeaderElement)iter.next();
            Name name = headerElement.getElementName();
            if (!name.getURI().equals(URI2)) continue;
            trash.add(headerElement);
        }
        for (SOAPHeaderElement headerElement : trash) {
            headerElement.detachNode();
        }
    }

    public static boolean hasSOAPEnvelope(Message m) {
        try {
            return m != null && m.getSOAPEnvelope() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String evaluateOutboundTransportURL(MessageContext mc) {
        WSHttpOutboundHandler handler = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
        if (handler == null) {
            return null;
        }
        IMgram m = (IMgram)mc.getProperty("progress.message.msg.IMgram");
        String messageURL = MgramURLHelper.getEffectiveURLDestination(m);
        if (messageURL == null || messageURL.equals("")) {
            messageURL = handler.getHttpRoutingInfo().getUrlString();
        }
        return messageURL;
    }

    public static String evaluateInboundHandlerURL(MessageContext mc) {
        String receiveURL = null;
        WSHttpInRequest wsreq = (WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest");
        if (wsreq == null) {
            return null;
        }
        receiveURL = (String)mc.getProperty("HTTP_IN_REQUEST_PATH");
        if (receiveURL == null && wsreq.getRequest() != null) {
            receiveURL = wsreq.getRequest().getRequestURL().toString();
        }
        return receiveURL;
    }
}

