/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.conversation.sts;

import com.sonicsw.ws.conversation.sts.SecurityContextToken;
import com.sonicsw.ws.conversation.sts.TokenID;
import java.util.Comparator;

public class SecurityContextTokenImpl
implements SecurityContextToken {
    private TokenID theTokenID;
    private String theToken;
    private long expiration;

    public SecurityContextTokenImpl(TokenID theTokenID, String theToken, long expiration) {
        this.theTokenID = theTokenID;
        this.theToken = theToken;
        this.expiration = expiration;
    }

    @Override
    public TokenID getTokenID() {
        return this.theTokenID;
    }

    @Override
    public String getToken() {
        return this.theToken;
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public boolean isExpired() {
        long now = System.currentTimeMillis();
        return this.getExpiration() < now;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        sb.append(this.getTokenID().toString());
        sb.append(',');
        sb.append(this.getToken());
        sb.append(',');
        sb.append(this.getExpiration());
        sb.append('}');
        return sb.toString();
    }

    public static final class ByExpirationComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            long exp2;
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            SecurityContextTokenImpl sct1 = (SecurityContextTokenImpl)o1;
            SecurityContextTokenImpl sct2 = (SecurityContextTokenImpl)o2;
            long exp1 = sct1.getExpiration();
            if (exp1 < (exp2 = sct2.getExpiration())) {
                return -1;
            }
            if (exp1 == exp2) {
                TokenID t1 = sct1.getTokenID();
                TokenID t2 = sct2.getTokenID();
                if (t1 == null) {
                    return -1;
                }
                if (t2 == null) {
                    return 1;
                }
                return sct1.getTokenID().compareTo(sct2.getTokenID());
            }
            return 1;
        }
    }

    public static final class ByIDComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SecurityContextToken sct1 = (SecurityContextToken)o1;
            SecurityContextToken sct2 = (SecurityContextToken)o2;
            TokenID id1 = sct1.getTokenID();
            TokenID id2 = sct2.getTokenID();
            return id1.compareTo(id2);
        }
    }
}

