/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.model.BootstrapToken;
import com.sonicsw.ws.security.policy.parser.processors.SymmetricBindingProcessor;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.AlgorithmSuiteProcessor;
import org.apache.ws.security.policy.parser.processors.AsymmetricBindingProcessor;
import org.apache.ws.security.policy.parser.processors.EncryptedPartsElementsProcessor;
import org.apache.ws.security.policy.parser.processors.EndorsingSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.LayoutProcessor;
import org.apache.ws.security.policy.parser.processors.SignedEndorsingSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SignedPartsElementsProcessor;
import org.apache.ws.security.policy.parser.processors.SignedSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.Wss10Processor;
import org.apache.ws.security.policy.parser.processors.Wss11Processor;
import org.w3c.dom.Element;

public class BootstrapProcessor {
    private boolean m_initialized = false;
    private String m_id;

    private void initializeBootstrapPolicy(SecurityPolicyToken spt) throws NoSuchMethodException {
        AsymmetricBindingProcessor abp = new AsymmetricBindingProcessor();
        SecurityPolicyToken tmpSpt = SecurityPolicy.asymmetricBinding.copy();
        tmpSpt.setProcessTokenMethod((Object)abp);
        spt.setChildToken(tmpSpt);
        SymmetricBindingProcessor sbp = new SymmetricBindingProcessor();
        tmpSpt = SecurityPolicy.symmetricBinding.copy();
        tmpSpt.setProcessTokenMethod((Object)sbp);
        spt.setChildToken(tmpSpt);
        SignedPartsElementsProcessor spep = new SignedPartsElementsProcessor();
        tmpSpt = SecurityPolicy.signedParts.copy();
        tmpSpt.setProcessTokenMethod((Object)spep);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signedElements.copy();
        tmpSpt.setProcessTokenMethod((Object)spep);
        spt.setChildToken(tmpSpt);
        EncryptedPartsElementsProcessor epep = new EncryptedPartsElementsProcessor();
        tmpSpt = SecurityPolicy.encryptedParts.copy();
        tmpSpt.setProcessTokenMethod((Object)epep);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.encryptedElements.copy();
        tmpSpt.setProcessTokenMethod((Object)epep);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.includeTimestamp.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.algorithmSuite.copy();
        tmpSpt.setProcessTokenMethod((Object)new AlgorithmSuiteProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.layout.copy();
        tmpSpt.setProcessTokenMethod((Object)new LayoutProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.includeTimestamp.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.supportingTokens.copy();
        tmpSpt.setProcessTokenMethod((Object)new SupportingTokensProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signedSupportingTokens.copy();
        tmpSpt.setProcessTokenMethod((Object)new SignedSupportingTokensProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.endorsingSupportingTokens.copy();
        tmpSpt.setProcessTokenMethod((Object)new EndorsingSupportingTokensProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signedEndorsingSupportingTokens.copy();
        tmpSpt.setProcessTokenMethod((Object)new SignedEndorsingSupportingTokensProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wss10.copy();
        tmpSpt.setProcessTokenMethod((Object)new Wss10Processor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wss11.copy();
        tmpSpt.setProcessTokenMethod((Object)new Wss11Processor());
        spt.setChildToken(tmpSpt);
    }

    public Object doBootstrapPolicy(SecurityProcessorContext spc) {
        DebugObjects.getSecureConversationDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        if (!HttpHelper.ENABLE_SECURE_CONVERSATION) {
            DebugObjects.getSecureConversationDebug().debug("WS-SecureConversation support is not yet implemented.");
            return new Boolean(false);
        }
        switch (spc.getAction()) {
            case 1: {
                if (this.m_initialized) break;
                try {
                    this.initializeBootstrapPolicy(spt);
                    System.out.println(" TODO: We've got to actually do something with the bootstrap policy. See BootstrapProcessor.java");
                    BootstrapToken bootstrapToken = (BootstrapToken)spc.readCurrentPolicyEngineData();
                    this.m_initialized = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        DebugObjects.getSecureConversationDebug().debug(this.getClass().getName() + ": Found SecureConversationToken list element");
        this.m_id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public String getId() {
        return this.m_id;
    }

    public Object doIncludeTimestamp(SecurityProcessorContext spc) {
        DebugObjects.getSecureConversationDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((BootstrapToken)spc.readCurrentPolicyEngineData()).setIncludeTimestamp(true);
        }
        return new Boolean(true);
    }
}

