/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.gr.RouterManager;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.SessionConfig;

class BrokerSecurityContextDisplayInfo
implements ClientSecurityContext.ISecurityContextDisplayInfo {
    private short m_displayType;
    private String m_displayName;

    BrokerSecurityContextDisplayInfo(ClientSecurityContext csc) {
        String appid = csc.getAppid();
        String uid = csc.getUid();
        this.m_displayType = 0;
        this.m_displayName = appid;
        if (appid == null) {
            this.m_displayName = "<appid-unset>";
            return;
        }
        try {
            if (appid.equals("Broker")) {
                this.m_displayType = (short)2;
                this.m_displayName = "SonicMQ.Cluster$" + uid;
            } else if (RouterManager.isRouterAppID(appid)) {
                this.m_displayType = (short)3;
                this.m_displayName = "SonicMQ.Routing$" + RouterManager.getRemoteNodeFromGRAppID(appid) + '$' + RouterManager.getRemoteBrokerFromAppID(appid) + '$' + uid;
            } else if (RouterManager.isRemoteNodeGSAppID(appid)) {
                this.m_displayType = (short)3;
                this.m_displayName = "SonicMQ.Routing$" + RouterManager.getRemoteNodeFromGSAppID(appid) + '$' + RouterManager.getRemoteBrokerFromGSAppID(appid) + '$' + uid;
            } else if (appid.endsWith("$CONNECTION$")) {
                this.m_displayType = 1;
                this.m_displayName = appid.substring(0, appid.lastIndexOf("$CONNECTION$"));
            } else {
                int idx = appid.indexOf("$SESSION$");
                if (idx > 0) {
                    this.m_displayType = (short)4;
                    int lastSep = appid.lastIndexOf("$");
                    int sessNameIdx = idx + "$SESSION$".length();
                    String name = "";
                    if (sessNameIdx < lastSep) {
                        name = ":" + appid.substring(sessNameIdx, lastSep);
                    }
                    this.m_displayName = "Session" + appid.substring(lastSep + 1) + name;
                } else if (appid.indexOf("$CC$$TS$") >= 0) {
                    this.m_displayType = (short)9;
                    this.m_displayName = "TopicCC" + appid.substring(appid.lastIndexOf("$") + 1);
                } else if (appid.indexOf("$DURABLE$$CC$") >= 0) {
                    this.m_displayType = (short)10;
                    this.m_displayName = SessionConfig.getDurableSubNameFromAppid(appid);
                } else if (appid.indexOf("$CC$$QR$") >= 0) {
                    this.m_displayType = (short)11;
                    this.m_displayName = "QueueCC" + appid.substring(appid.lastIndexOf("$") + 1);
                } else if (appid.indexOf("$NONDURABLE$") >= 0) {
                    this.m_displayType = (short)5;
                    this.m_displayName = "TopicSubscriber" + appid.substring(appid.lastIndexOf("$") + 1);
                } else if (appid.startsWith("$DURABLE$")) {
                    this.m_displayType = (short)6;
                    this.m_displayName = SessionConfig.getDurableSubNameFromAppid(appid);
                } else if (appid.indexOf("$QR$") >= 0) {
                    this.m_displayType = (short)7;
                    this.m_displayName = "QueueReceiver" + appid.substring(appid.lastIndexOf("$") + 1);
                } else if (appid.indexOf("$QB$") >= 0) {
                    this.m_displayType = (short)8;
                    this.m_displayName = "QueueBrowser" + appid.substring(appid.lastIndexOf("$") + 1);
                }
            }
        }
        catch (Exception e) {
            this.m_displayType = 0;
            this.m_displayName = appid;
        }
    }

    @Override
    public short getType() {
        return this.m_displayType;
    }

    @Override
    public String getName() {
        return this.m_displayName;
    }
}

