/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.zclient.ClientSecurityContext;

public class ConnectEvt
extends LogEvent {
    private long m_id;
    private boolean m_ib;
    private ClientSecurityContext m_secctx;

    public ConnectEvt(long id, ClientSecurityContext secctx, boolean ib) {
        this.m_id = id;
        this.m_ib = ib;
        this.m_secctx = secctx;
    }

    ConnectEvt() {
    }

    @Override
    public short type() {
        return 19;
    }

    @Override
    protected int memSizeBody() {
        return 13 + this.m_secctx.length();
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return 9 + this.m_secctx.length();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeBoolean(this.m_ib, os);
        this.m_secctx.serialize(os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_ib = StreamUtil.readBoolean(in);
        this.m_secctx = ClientSecurityContext.unserialize(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoConnect(this.m_id, this.m_secctx, this.m_ib);
    }

    @Override
    public String toString() {
        return super.toString() + "Connect ft: " + this.m_secctx.isFaultTolerant() + " uid: " + this.m_secctx.getUid() + " appid: " + this.m_secctx.getAppid() + " id: " + this.m_id + " parent: " + this.m_secctx.getParentId();
    }
}

