/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class ResumeGlobalTransaction
implements IMessageHandler {
    private AgentRegistrar m_reg;

    ResumeGlobalTransaction(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message req = env.getMessage();
            ISubject subj = req.getSubject();
            Object xid = req.readObject();
            int tid = req.readInt();
            String uid = subj.extractSubjectLevel(2);
            String appid = subj.extractSubjectLevel(3);
            Message rep = new Message();
            try {
                this.m_reg.getTransactionMgr().resumeTxn(uid, appid, xid, tid);
                rep.writeShort(0);
            }
            catch (EXAThereIsNoXidException e) {
                rep.writeShort(12);
            }
            catch (ETxnNotFound e) {
                rep.writeShort(2);
            }
            catch (ETxnSequenceError e) {
                rep.writeShort(3);
            }
            s.reply(rep, env);
        }
        catch (IOException e) {
            if (!Broker.isInShutdown()) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        catch (ClassNotFoundException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

