/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerJob;
import progress.message.broker.Config;
import progress.message.broker.DurableManager;
import progress.message.broker.IMonitoredObject;
import progress.message.broker.INeighbor;
import progress.message.broker.durable.DurableBrokerJobReplyQueue;
import progress.message.broker.durable.DurableBrowseOp;
import progress.message.broker.durable.DurableBrowseReplyOp;
import progress.message.broker.durable.EDurableOperationException;
import progress.message.broker.durable.IDurableHeaderInfo;
import progress.message.interbroker.Interbroker;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class DurableBrowser
extends DebugObject
implements IMonitoredObject {
    private boolean m_isLocal;
    private long m_clientId;
    private DurableManager m_manager;
    private long m_trkNum = -1L;
    private boolean m_isEnd = false;
    private INeighbor[] m_neighbors;
    private int m_currentNeighbor;
    private String m_tracking;
    private boolean m_browseCancelled = false;
    private static final int DEFAULT_TIMEOUT = 900000;
    private int m_timeoutTime = 900000;
    private long m_inactivityTime = System.currentTimeMillis() + 900000L;
    private boolean m_inBrowse = false;
    private boolean m_timedOut = false;
    private Object m_timeoutSyncObj = new Object();

    public DurableBrowser(long clientId, String tracking, boolean isLocal) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DurableBrowser" : null);
        this.m_isLocal = isLocal;
        this.m_clientId = clientId;
        this.m_tracking = tracking;
        this.m_manager = AgentRegistrar.getAgentRegistrar().getDurableManager();
        AgentRegistrar.getAgentRegistrar().getWatchDogThread().register(this);
        if (!this.m_isLocal) {
            this.m_neighbors = Interbroker.getInterbroker().getAllNeighbors();
            this.m_currentNeighbor = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInactivityTimeout(int timeout) throws EDurableOperationException {
        Object object = this.m_timeoutSyncObj;
        synchronized (object) {
            if (this.m_timedOut) {
                throw new EDurableOperationException(5);
            }
            this.m_timeoutTime = timeout;
            if (timeout > 0) {
                this.m_inactivityTime = System.currentTimeMillis() + (long)timeout;
            } else {
                this.m_inactivityTime = -1L;
                AgentRegistrar.getAgentRegistrar().getWatchDogThread().unregister(this);
            }
            if (this.DEBUG) {
                if (this.m_inactivityTime != -1L) {
                    this.debug("Timeout Time is now: " + new Date(this.m_inactivityTime));
                } else {
                    this.debug("Timeout Time is now infinite");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection browse(int maxReplies) throws EDurableOperationException, InterruptedException {
        Collection result;
        boolean throwTimeout = false;
        Object object = this.m_timeoutSyncObj;
        synchronized (object) {
            this.m_inBrowse = true;
            this.m_inactivityTime = System.currentTimeMillis() + (long)this.m_timeoutTime;
        }
        try {
            if (this.m_isEnd) {
                if (this.m_browseCancelled) {
                    throw new EDurableOperationException(1);
                }
                result = null;
            } else {
                result = this.m_isLocal ? this.browseLocal(maxReplies) : this.browseCluster(maxReplies);
            }
        }
        finally {
            object = this.m_timeoutSyncObj;
            synchronized (object) {
                this.m_inBrowse = false;
                this.m_inactivityTime = System.currentTimeMillis() + (long)this.m_timeoutTime;
                if (this.m_timedOut) {
                    throwTimeout = true;
                }
            }
        }
        if (throwTimeout) {
            throw new EDurableOperationException(5);
        }
        return result;
    }

    private Collection browseLocal(int maxReplies) throws EDurableOperationException, InterruptedException {
        BrokerJob job = new BrokerJob(maxReplies);
        Collection reply = this.m_manager.performLocalDurableRequest(new DurableBrowseOp(new DurableBrokerJobReplyQueue(job), this.m_clientId, this.m_trkNum, maxReplies), job);
        ArrayList<IDurableHeaderInfo> result = null;
        for (DurableBrowseReplyOp replyOp : reply) {
            if (replyOp.hasError()) {
                throw new EDurableOperationException(replyOp.getErrorCode());
            }
            if (replyOp.isEnd()) {
                this.m_isEnd = true;
                return result;
            }
            if (result == null) {
                result = new ArrayList<IDurableHeaderInfo>();
            }
            result.add(replyOp.getReplyInformation());
            this.m_trkNum = replyOp.getTrkNum();
        }
        return result;
    }

    private Collection browseCluster(int maxReplies) throws EDurableOperationException, InterruptedException {
        ArrayList<IDurableHeaderInfo> result = new ArrayList<IDurableHeaderInfo>();
        boolean cancelled = false;
        if (this.m_currentNeighbor == -1) {
            BrokerJob job = new BrokerJob(maxReplies);
            Collection reply = this.m_manager.performLocalDurableRequest(new DurableBrowseOp(new DurableBrokerJobReplyQueue(job), this.m_clientId, this.m_trkNum, maxReplies), job);
            for (DurableBrowseReplyOp replyOp : reply) {
                if (replyOp.hasError()) {
                    throw new EDurableOperationException(replyOp.getErrorCode());
                }
                if (replyOp.isEnd()) {
                    this.m_currentNeighbor = 0;
                    this.m_trkNum = -1L;
                    continue;
                }
                result.add(replyOp.getReplyInformation());
                this.m_trkNum = replyOp.getTrkNum();
                if (result.size() != maxReplies) continue;
                return result;
            }
        }
        while (this.m_neighbors != null && this.m_currentNeighbor < this.m_neighbors.length && result.size() < maxReplies) {
            if (this.m_neighbors[this.m_currentNeighbor].getName().equals(Config.BROKER_NAME)) {
                ++this.m_currentNeighbor;
                continue;
            }
            int repliesLeft = maxReplies - result.size();
            BrokerJob job = new BrokerJob(repliesLeft);
            Collection reply = this.m_manager.performRemoteDurableRequest(this.m_neighbors[this.m_currentNeighbor], DurableBrowseOp.getMgram(null, this.m_clientId, this.m_trkNum, repliesLeft), job);
            if (job.wasCancelled()) {
                this.m_browseCancelled = true;
                cancelled = true;
                ++this.m_currentNeighbor;
            }
            for (DurableBrowseReplyOp replyOp : reply) {
                if (replyOp.hasError()) {
                    throw new EDurableOperationException(replyOp.getErrorCode());
                }
                if (replyOp.isEnd()) {
                    if (!cancelled) {
                        ++this.m_currentNeighbor;
                    }
                    this.m_trkNum = -1L;
                    if (this.m_currentNeighbor != this.m_neighbors.length) continue;
                    this.m_isEnd = true;
                    return result;
                }
                result.add(replyOp.getReplyInformation());
                this.m_trkNum = replyOp.getTrkNum();
                if (result.size() != maxReplies) continue;
                return result;
            }
            cancelled = false;
        }
        if (this.m_neighbors != null && this.m_currentNeighbor >= this.m_neighbors.length) {
            this.m_isEnd = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getExpirationTime() {
        Object object = this.m_timeoutSyncObj;
        synchronized (object) {
            if (this.m_inBrowse && this.m_inactivityTime != -1L) {
                this.m_inactivityTime = System.currentTimeMillis() + (long)this.m_timeoutTime;
            } else if (this.m_inactivityTime == -1L) {
                return System.currentTimeMillis() + 900000L;
            }
            return this.m_inactivityTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeOutExpired() throws InterruptedException {
        try {
            Object object = this.m_timeoutSyncObj;
            synchronized (object) {
                this.m_timedOut = true;
                if (this.DEBUG) {
                    this.debug("DurableBrowser timed out: " + new Date(System.currentTimeMillis()));
                }
                AgentRegistrar.getAgentRegistrar().getDurableManager().unreserveBrowser(this.m_tracking, this.m_clientId);
            }
        }
        catch (EDurableOperationException eDurableOperationException) {
            // empty catch block
        }
    }
}

