/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.text.MessageFormat;
import progress.message.crypto.CryptoError;
import progress.message.crypto.prAccessor;

public abstract class BlockCipher {
    public final void encrypt(byte[] text) {
        this.encrypt(text, 0, text, 0);
    }

    public final void decrypt(byte[] text) {
        this.decrypt(text, 0, text, 0);
    }

    public final void encrypt(byte[] in, byte[] out) {
        if (in.length != out.length) {
            String mf56 = prAccessor.getString("STR001");
            Object[] ob56 = new Object[]{this.getClass().getName()};
            throw new CryptoError(MessageFormat.format(mf56, ob56));
        }
        this.encrypt(in, 0, out, 0);
    }

    public final void decrypt(byte[] in, byte[] out) {
        if (in.length != out.length) {
            String mf71 = prAccessor.getString("STR002");
            Object[] ob71 = new Object[]{this.getClass().getName()};
            throw new CryptoError(MessageFormat.format(mf71, ob71));
        }
        this.decrypt(in, 0, out, 0);
    }

    public final void encrypt(byte[] in, int in_offset, byte[] out, int out_offset) {
        int blkLength = this.blockLength();
        if (in_offset < 0 || out_offset < 0) {
            String mf90 = prAccessor.getString("STR003");
            Object[] ob90 = new Object[]{this.getClass().getName()};
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format(mf90, ob90));
        }
        if (in_offset + blkLength > in.length || out_offset + blkLength > out.length) {
            String mf93 = prAccessor.getString("STR004");
            Object[] ob93 = new Object[]{this.getClass().getName()};
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format(mf93, ob93));
        }
        this.blockEncrypt(in, in_offset, out, out_offset);
    }

    public final void decrypt(byte[] in, int in_offset, byte[] out, int out_offset) {
        int blkLength = this.blockLength();
        if (in_offset < 0 || out_offset < 0) {
            String mf117 = prAccessor.getString("STR005");
            Object[] ob117 = new Object[]{this.getClass().getName()};
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format(mf117, ob117));
        }
        if (in_offset + blkLength > in.length || out_offset + blkLength > out.length) {
            String mf120 = prAccessor.getString("STR006");
            Object[] ob120 = new Object[]{this.getClass().getName()};
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format(mf120, ob120));
        }
        this.blockDecrypt(in, in_offset, out, out_offset);
    }

    protected abstract void blockEncrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void blockDecrypt(byte[] var1, int var2, byte[] var3, int var4);

    public abstract int blockLength();

    public abstract int keyLength();
}

