/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.pubsub.v2;

import com.odi.ClassInfo;
import com.odi.Database;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.Placement;
import com.odi.imp.ObjectReference;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import progress.message.broker.MgramSerializer;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.dbsc.pse.pc.PSEByteArrayWrapper;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessage;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.util.server.ByteBufferInputStream;
import progress.message.zclient.EMgramFormatError;

public class PSEMessage2
implements IPSEMessage,
IPersistent,
IPersistentHooks {
    private long _MessageId;
    private long _SequenceNumber;
    private int _MessageSize;
    private long _Expiration;
    private String _JMSMessageId;
    private long _Timestamp;
    private PSEByteArrayWrapper _MessageBody;
    private long[] _Recips;
    private transient HashSet _RecipsSet;
    private transient boolean _RecipsChange;
    private long _ARecip;
    private transient boolean deleted;
    protected transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = PSEMessage2.getClassInfoInstance();

    public PSEMessage2(long mid, long seq, int size, Date exp, Date timestamp, String jmsId, byte[] msgBody) {
        this._RecipsSet = null;
        this._MessageId = mid;
        this._SequenceNumber = seq;
        this._MessageSize = size;
        if (jmsId != null) {
            this._JMSMessageId = new String(jmsId);
        }
        this._Expiration = exp == null ? PSEBrokerDb.PSE_NULL_DATE : exp.getTime();
        if (msgBody != null) {
            this._MessageBody = new PSEByteArrayWrapper(msgBody);
        }
        this._Timestamp = timestamp == null ? PSEBrokerDb.PSE_NULL_DATE : timestamp.getTime();
        if (msgBody != null) {
            this._MessageBody = new PSEByteArrayWrapper(msgBody);
        }
    }

    @Override
    public boolean isExpired(long time) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._Expiration == PSEBrokerDb.PSE_NULL_DATE) {
            return false;
        }
        return this._Expiration < time;
    }

    @Override
    public boolean addRecipient(long id) {
        boolean added = false;
        this.initRecipsSet();
        added = this._RecipsSet.add(new Long(id));
        return this.setReceipschangeAndDirty(added);
    }

    @Override
    public boolean removeRecipient(long id) {
        this.initRecipsSet();
        boolean removed = this._RecipsSet.remove(new Long(id));
        return this.setReceipschangeAndDirty(removed);
    }

    private boolean setReceipschangeAndDirty(boolean added) {
        if (added) {
            this._RecipsChange = true;
            ObjectStore.dirty((Object)this);
        }
        return added;
    }

    @Override
    public int removeAllRecipients() {
        this.initRecipsSet();
        int size = this._RecipsSet.size();
        this._RecipsSet.clear();
        if (size > 0) {
            this._RecipsChange = true;
            ObjectStore.dirty((Object)this);
        }
        return size;
    }

    @Override
    public long getMessageId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageId;
    }

    @Override
    public long getSequenceNumber() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._SequenceNumber;
    }

    @Override
    public int getMessageSize() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageSize;
    }

    @Override
    public Date getExpiration() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._Expiration == PSEBrokerDb.PSE_NULL_DATE) {
            return null;
        }
        return new Date(this._Expiration);
    }

    @Override
    public Date getTimestamp() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._Timestamp == PSEBrokerDb.PSE_NULL_DATE) {
            return null;
        }
        return new Date(this._Timestamp);
    }

    @Override
    public String getJMSMessageId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._JMSMessageId;
    }

    @Override
    public Iterator getRecipients() {
        this.initRecipsSet();
        return this._RecipsSet.iterator();
    }

    @Override
    public long[] getRecipsArray() {
        long[] lArray = null;
        this.initRecipsSet();
        int size = this._RecipsSet.size();
        long[] result = new long[size];
        Iterator it = this.getRecipients();
        int i = 0;
        while (it.hasNext()) {
            long[] lArray2 = result;
            if (result != lArray) {
                ObjectStore.dirty((Object)lArray2);
                lArray2 = lArray = lArray2;
            }
            lArray2[i] = (Long)it.next();
            ++i;
        }
        return result;
    }

    @Override
    public boolean hasBody() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageBody != null;
    }

    @Override
    public boolean hasJMSMessageId() {
        return this.getJMSMessageId() != null;
    }

    @Override
    public boolean hasRecipients() {
        this.initRecipsSet();
        return this._RecipsSet.size() > 0;
    }

    @Override
    public int getRecipientCount() {
        this.initRecipsSet();
        return this._RecipsSet.size();
    }

    @Override
    public synchronized IMgram getMgram() {
        if (this.deleted) {
            return null;
        }
        if (ObjectStore.isDestroyed((Object)this)) {
            return null;
        }
        return this.getMgramInternal();
    }

    private IMgram getMgramInternal() {
        byte[] body;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        IMgram mgram = null;
        if (this._MessageBody == null) {
            new EAssertFailure("PSEMessage2.getMgramInternal: _MessageBody is null; mid= " + this._MessageId + " ctrecips= " + this.getRecipientCount()).printStackTrace();
            return null;
        }
        byte[] byArray = body = this._MessageBody.getBytes();
        if (body != null) {
            byArray = byArray;
            ObjectStore.fetch((byte[])byArray);
        }
        ByteBufferInputStream bis = new ByteBufferInputStream(byArray);
        try {
            mgram = MgramSerializer.getMgramSerializer().unserialize(bis, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EMgramFormatError ex) {
            ex.printStackTrace();
        }
        ObjectStore.evict((Object)this._MessageBody, (int)2);
        return mgram;
    }

    @Override
    public boolean setMessageBodyIfNull(byte[] msgBody) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        boolean added = false;
        if (msgBody != null && this._MessageBody == null) {
            PSEMessage2 pSEMessage2;
            if (((pSEMessage2 = this).ODIObjectState & 2) != 0) {
                pSEMessage2 = pSEMessage2;
                ObjectStore.dirty((IPersistent)pSEMessage2);
            }
            pSEMessage2._MessageBody = new PSEByteArrayWrapper(msgBody);
            added = true;
        }
        return added;
    }

    @Override
    public void setJMSMessageId(String jmsId) {
        PSEMessage2 pSEMessage2;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String oldS = this.getJMSMessageId();
        String newS = jmsId;
        if (oldS != null) {
            if (oldS.equals(newS)) {
                return;
            }
            ObjectStore.destroy((Object)oldS);
        }
        if (((pSEMessage2 = this).ODIObjectState & 2) != 0) {
            pSEMessage2 = pSEMessage2;
            ObjectStore.dirty((IPersistent)pSEMessage2);
        }
        pSEMessage2._JMSMessageId = new String(jmsId);
    }

    public void preFlushContents() {
        if (!ObjectStore.isPersistent((Object)this)) {
            return;
        }
        if (this._MessageBody != null && !ObjectStore.isPersistent((Object)this._MessageBody)) {
            ObjectStore.migrate((Object)this._MessageBody, (Placement)Database.of((Object)this), (boolean)false);
        }
        if (this._MessageBody != null) {
            ObjectStore.evict((Object)this._MessageBody, (int)2);
        }
        if (this._RecipsChange) {
            this._ARecip = 0L;
            if (this._Recips != null && ObjectStore.isPersistent((Object)this._Recips) && !ObjectStore.isDestroyed((Object)this._Recips)) {
                ObjectStore.destroy((Object)this._Recips);
            }
            this._Recips = null;
            if (this._RecipsSet != null && !this._RecipsSet.isEmpty()) {
                Iterator it = this._RecipsSet.iterator();
                int i = 0;
                boolean first = true;
                while (it.hasNext()) {
                    if (first) {
                        this._ARecip = (Long)it.next();
                        first = false;
                        continue;
                    }
                    if (this._Recips == null) {
                        this._Recips = new long[this._RecipsSet.size() - 1];
                    }
                    this._Recips[i] = (Long)it.next();
                    ++i;
                }
            }
        }
        this._RecipsChange = false;
    }

    public synchronized void preDestroyPersistent() {
        PSEMessage2 pSEMessage2;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._RecipsSet != null && !this._RecipsSet.isEmpty()) {
            new EAssertFailure("Destroying message that has recipients; id= " + this.getMessageId() + " CountRecips= " + this._RecipsSet.size()).printStackTrace();
        }
        ObjectStore.destroy((Object)this._Recips);
        ObjectStore.destroy((Object)this._MessageBody);
        ObjectStore.destroy((Object)this._JMSMessageId);
        this._RecipsSet = null;
        if (((pSEMessage2 = this).ODIObjectState & 2) != 0) {
            pSEMessage2 = pSEMessage2;
            ObjectStore.dirty((IPersistent)pSEMessage2);
        }
        pSEMessage2._ARecip = 0L;
        this._Recips = null;
        this._RecipsChange = false;
        this.deleted = true;
        this._MessageBody = null;
        this._JMSMessageId = null;
    }

    @Override
    public String toStringAll() {
        StringBuffer buf = new StringBuffer("PSEMessage2: ");
        buf.append("\tMid: " + this.getMessageId());
        buf.append("\tSeq: " + this.getSequenceNumber());
        buf.append("\tSize: " + this.getMessageSize());
        buf.append("\tExp: " + this.getExpiration());
        buf.append("\tTimestamp: " + this.getTimestamp());
        buf.append("\tJMSId: " + this.getJMSMessageId());
        buf.append("\thasBody: " + this.hasBody());
        buf.append("\tcountRecips: " + this.getRecipientCount());
        return buf.toString();
    }

    public String toString() {
        return "PSEMessage2: mid= " + this.getMessageId() + " size= " + this.getMessageSize();
    }

    private void initRecipsSet() {
        long[] lArray = null;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._RecipsSet != null) {
            return;
        }
        this._RecipsSet = new HashSet();
        if (this._ARecip != 0L) {
            this._RecipsSet.add(new Long(this._ARecip));
        }
        if (this._Recips != null && this._Recips.length > 0) {
            for (int i = 0; i < this._Recips.length; ++i) {
                long[] lArray2 = this._Recips;
                if (this._Recips != lArray) {
                    ObjectStore.fetch((long[])lArray2);
                    lArray2 = lArray = lArray2;
                }
                this._RecipsSet.add(new Long(lArray2[i]));
            }
        }
    }

    @Override
    public void setMessageBodyNullNoDestroy() {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._MessageBody = null;
    }

    @Override
    public PSEByteArrayWrapper getMessageBody() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._MessageBody;
    }

    @Override
    public void setMessageBody(PSEByteArrayWrapper m) {
        PSEMessage2 pSEMessage2;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._MessageBody != null) {
            new EAssertFailure("PSEMessage.setMessageBody: existing message body is not null").printStackTrace();
        }
        if (((pSEMessage2 = this).ODIObjectState & 2) != 0) {
            pSEMessage2 = pSEMessage2;
            ObjectStore.dirty((IPersistent)pSEMessage2);
        }
        pSEMessage2._MessageBody = m;
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSEMessage2)super.clone()).ODIref = null;
        ((PSEMessage2)super.clone()).ODIObjectState = 0;
        return (PSEMessage2)super.clone();
    }

    public void postInitializeContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._MessageId = genericObject.getLongField(1, classInfo);
        this._SequenceNumber = genericObject.getLongField(2, classInfo);
        this._MessageSize = genericObject.getIntField(3, classInfo);
        this._Expiration = genericObject.getLongField(4, classInfo);
        this._JMSMessageId = genericObject.getStringField(5, classInfo);
        this._Timestamp = genericObject.getLongField(6, classInfo);
        this._MessageBody = (PSEByteArrayWrapper)genericObject.getClassField(7, classInfo);
        this._Recips = (long[])genericObject.getArrayField(8, classInfo);
        this._ARecip = genericObject.getLongField(9, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setLongField(1, this._MessageId, classInfo);
        genericObject.setLongField(2, this._SequenceNumber, classInfo);
        genericObject.setIntField(3, this._MessageSize, classInfo);
        genericObject.setLongField(4, this._Expiration, classInfo);
        genericObject.setStringField(5, this._JMSMessageId, classInfo);
        genericObject.setLongField(6, this._Timestamp, classInfo);
        genericObject.setClassField(7, (Object)this._MessageBody, classInfo);
        genericObject.setArrayField(8, (Object)this._Recips, classInfo);
        genericObject.setLongField(9, this._ARecip, classInfo);
    }

    public void clearContents() {
        this._MessageId = 0L;
        this._SequenceNumber = 0L;
        this._MessageSize = 0;
        this._Expiration = 0L;
        this._JMSMessageId = null;
        this._Timestamp = 0L;
        this._MessageBody = null;
        this._Recips = null;
        this._ARecip = 0L;
    }

    public PSEMessage2(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        return ClassInfo.get(PSEMessage2.class);
    }
}

