/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import progress.message.jclient.JMSConsumer;
import progress.message.jclient.JMSExceptionUtils;
import progress.message.jclient.JMSProducer;
import progress.message.jimpl.ConnectionMetaData;

public abstract class AbstractJMSContext
implements JMSContext {
    private static final boolean DEFAULT_AUTO_START = true;
    protected int sessionMode;
    private boolean autoStart = true;
    protected boolean closed;
    private Message lastMessagesWaitingAck;

    public AbstractJMSContext(int sessionMode) {
        this.sessionMode = sessionMode;
    }

    protected abstract Connection getConnection();

    protected abstract Session getSession();

    protected abstract void checkSession();

    @Override
    public JMSProducer createProducer() {
        this.checkSession();
        try {
            return new JMSProducer(this, this.getSession().createProducer(null));
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public String getClientID() {
        try {
            return this.getConnection().getClientID();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void setClientID(String clientID) {
        try {
            this.getConnection().setClientID(clientID);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public ConnectionMetaData getMetaData() {
        return new ConnectionMetaData();
    }

    @Override
    public ExceptionListener getExceptionListener() {
        try {
            return this.getConnection().getExceptionListener();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.getConnection().setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void start() {
        try {
            this.getConnection().start();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.getConnection().stop();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public boolean getAutoStart() {
        return this.autoStart;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            Session session = this.getSession();
            if (session != null) {
                session.close();
            }
            this.getConnection().close();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public BytesMessage createBytesMessage() {
        this.checkSession();
        try {
            return this.getSession().createBytesMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public MapMessage createMapMessage() {
        this.checkSession();
        try {
            return this.getSession().createMapMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message createMessage() {
        this.checkSession();
        try {
            return this.getSession().createMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public ObjectMessage createObjectMessage() {
        this.checkSession();
        try {
            return this.getSession().createObjectMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) {
        this.checkSession();
        try {
            return this.getSession().createObjectMessage(object);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public StreamMessage createStreamMessage() {
        this.checkSession();
        try {
            return this.getSession().createStreamMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public TextMessage createTextMessage() {
        this.checkSession();
        try {
            return this.getSession().createTextMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public TextMessage createTextMessage(String text) {
        this.checkSession();
        try {
            return this.getSession().createTextMessage(text);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public boolean getTransacted() {
        this.checkSession();
        try {
            return this.getSession().getTransacted();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public int getSessionMode() {
        return this.sessionMode;
    }

    @Override
    public void commit() {
        this.checkSession();
        try {
            this.getSession().commit();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void rollback() {
        this.checkSession();
        try {
            this.getSession().rollback();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void recover() {
        this.checkSession();
        try {
            this.getSession().recover();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createConsumer(destination));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createConsumer(destination, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createConsumer(destination, messageSelector, noLocal));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Queue createQueue(String queueName) {
        this.checkSession();
        try {
            return this.getSession().createQueue(queueName);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Topic createTopic(String topicName) {
        this.checkSession();
        try {
            return this.getSession().createTopic(topicName);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createDurableConsumer(topic, name));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createDurableConsumer(topic, name, messageSelector, noLocal));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createSharedDurableConsumer(topic, name));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createSharedDurableConsumer(topic, name, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createSharedConsumer(topic, sharedSubscriptionName));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.checkSession();
        try {
            JMSConsumer consumer = new JMSConsumer(this, this.getSession().createSharedConsumer(topic, sharedSubscriptionName, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) {
        this.checkSession();
        try {
            QueueBrowser browser = this.getSession().createBrowser(queue);
            this.checkAutoStart();
            return browser;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        this.checkSession();
        try {
            QueueBrowser browser = this.getSession().createBrowser(queue, messageSelector);
            this.checkAutoStart();
            return browser;
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public TemporaryQueue createTemporaryQueue() {
        this.checkSession();
        try {
            return this.getSession().createTemporaryQueue();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() {
        this.checkSession();
        try {
            return this.getSession().createTemporaryTopic();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void unsubscribe(String name) {
        this.checkSession();
        try {
            this.getSession().unsubscribe(name);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    protected void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
    }

    @Override
    public void acknowledge() {
        this.checkSession();
        try {
            if (this.lastMessagesWaitingAck != null) {
                this.lastMessagesWaitingAck.acknowledge();
            }
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    public Message setLastMessage(Message lastMessageReceived) {
        if (this.sessionMode == 2) {
            this.lastMessagesWaitingAck = lastMessageReceived;
        }
        return lastMessageReceived;
    }

    private void checkAutoStart() throws JMSException {
        this.checkNotClosed();
        if (this.autoStart) {
            this.getConnection().start();
        }
    }
}

