/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import com.sonicsw.security.pass.broker.ConnectionException;
import com.sonicsw.security.pass.broker.IAuthentication;
import com.sonicsw.security.pass.broker.UnauthenticatedException;
import com.sonicsw.security.pass.client.IPasswordUser;
import com.sonicsw.security.pcs.CipherSuiteInfo;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EInauthenticBroker;
import progress.message.client.EInauthenticClient;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.util.StringUtil;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.BrokerConnectParms;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.ConnectData;
import progress.message.zclient.ConnectHandshaker;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.ExtendedClientData;
import progress.message.zclient.IDES;
import progress.message.zclient.ISHA;
import progress.message.zclient.IUser;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

public final class BrokerConnectHandshaker
extends ConnectHandshaker {
    private IAuthentication m_authenticationSPI = null;
    private boolean m_isAuthenticationSPIEnabled = false;

    public BrokerConnectHandshaker(BaseConnection con) {
        super(con);
    }

    public static final IMgram buildBrokerRedirectedReply(String newBrokerURL) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(9);
        DataOutputStream dos = new DataOutputStream(bos);
        if (newBrokerURL != null) {
            dos.writeUTF(newBrokerURL);
        }
        dos.flush();
        return MgramFactory.getMgramFactory().buildConnectMgram(bos.toByteArray(), 0);
    }

    @Override
    public void handleConnectMgram(IMgram m) throws EInauthenticClient, EInauthenticBroker, EUnexpectedMgram, EMgramFormatError, EInvalidCipherSuiteException {
        switch (this.m_state) {
            case 6: {
                if (BrokerConnectHandshaker.compareSubtype(m, 11)) {
                    if (!this.m_isAuthenticationSPIEnabled || this.m_authenticationSPI == null || this.m_user != null && this.m_user.isInternalPrincipal()) break;
                    ByteArrayInputStream bis = new ByteArrayInputStream(m.getRawBody(), 1, m.getBodyLength() - 1);
                    DataInputStream dis = new DataInputStream(bis);
                    try {
                        int i = dis.readInt();
                        byte[] psw = new byte[i];
                        dis.read(psw, 0, i);
                        if (psw != null) {
                            this.m_transformedPassword = psw;
                        }
                    }
                    catch (IOException ex) {
                        this.m_transformedPassword = null;
                        throw new EInauthenticClient(ex.getMessage());
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        this.m_transformedPassword = null;
                        throw new EInauthenticClient(ex.getMessage());
                    }
                    String uid = this.m_uid.replace('$', '.');
                    try {
                        int credentialSize = this.m_transformedPassword.length - 20;
                        byte[] credential = new byte[credentialSize];
                        System.arraycopy(this.m_transformedPassword, 20, credential, 0, credential.length);
                        IPasswordUser passwordUser = this.m_authenticationSPI.authenticate(uid, credential, this.m_peerCertChain);
                        ArrayList newExternalGroups = BrokerConnectHandshaker.retrieveNewExternalGroups(passwordUser);
                        if (passwordUser != null) {
                            this.m_uid = passwordUser.getName();
                        }
                        this.m_uid = this.m_uid.replace('.', '$');
                        this.initMUser(newExternalGroups);
                        break;
                    }
                    catch (ConnectionException e) {
                        throw new EInauthenticClient(e.getMessage());
                    }
                    catch (UnauthenticatedException e) {
                        throw new EInauthenticClient(e.getMessage());
                    }
                    catch (Exception e) {
                        throw new EInauthenticClient(e.getMessage());
                    }
                    catch (Throwable e) {
                        throw new EInauthenticClient(e.getMessage());
                    }
                }
                if (BrokerConnectHandshaker.compareSubtype(m, 13)) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(m.getRawBody(), 1, m.getBodyLength() - 1);
                    DataInputStream dis = new DataInputStream(bis);
                    String errorMsg = null;
                    try {
                        errorMsg = dis.readUTF();
                    }
                    catch (IOException ex) {
                        throw new EInauthenticClient(ex.getMessage());
                    }
                    this.m_state = 8;
                    throw new EInauthenticClient(errorMsg);
                }
                super.handleConnectMgram(m);
                break;
            }
            case 1: {
                BrokerConnectHandshaker.verifySubtype(m, 3);
                this.readClientInfo(m);
                this.m_pwKey = new byte[8];
                if (this.m_user == null && !this.m_isAuthenticationSPIEnabled) {
                    String s = prAccessor.getString("STR121");
                    s = s + ". " + prAccessor.getString("STR192");
                    throw new EInauthenticClient(s);
                }
                if (this.m_user != null && this.m_user.isInternalPrincipal()) {
                    byte[] testPattern = this.m_user.getTestPattern();
                    System.arraycopy(testPattern, 6, this.m_pwKey, 0, 8);
                } else if (this.m_user != null && this.m_isAuthenticationSPIEnabled) {
                    this.m_user = null;
                }
                if (this.m_active) {
                    this.m_state = 2;
                    break;
                }
                if (this.m_securityEnabled) {
                    this.processSecurity();
                    break;
                }
                this.m_sender.send(this.buildSecDisabledMgram());
                this.setDoneState();
                break;
            }
            default: {
                super.handleConnectMgram(m);
            }
        }
    }

    public static final IMgram buildBrokerHello(byte sessionVer) {
        byte[] payload = new byte[]{2, sessionVer};
        return MgramFactory.getMgramFactory().buildConnectMgram(payload, 0);
    }

    public final IMgram buildSuccessMgram(ConnectData cd) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(7);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(SessionConfig.getKeyBits());
        cd.writeToStream(dos, (short)-1);
        if (this.m_incomingClientVer >= 27) {
            this.m_brokerParameters.serialize(dos);
        }
        dos.flush();
        return MgramFactory.getMgramFactory().buildConnectMgram(bos.toByteArray(), 0);
    }

    public ClientConnectParms getClientConnectParms() {
        return this.m_clientParameters;
    }

    public void setBrokerConnectParms(BrokerConnectParms parms) {
        this.m_brokerParameters = parms;
    }

    public BrokerConnectParms getBrokerConnectParms() {
        return this.m_brokerParameters;
    }

    public final String getAppid() {
        return this.m_appid;
    }

    public final String getClientData() {
        return this.m_clientData;
    }

    public final ExtendedClientData getExtendedClientData() {
        return this.m_extendedClientData;
    }

    public final boolean isClientHello(IMgram m) throws EBrokerVersionMismatch, EMgramFormatError {
        if (BrokerConnectHandshaker.compareSubtype(m, 1)) {
            try {
                this.m_incomingClientVer = m.getRawBody()[1];
                if (!SessionConfig.isClientSessionVersionSupported(this.m_incomingClientVer)) {
                    throw new EBrokerVersionMismatch(32, (int)m.getRawBody()[1]);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EBrokerVersionMismatch(32, 23);
            }
            if (m.getBodyLength() > 2) {
                ObjectInput dis = m.getPayloadInputStreamHandle();
                try {
                    boolean extendedDataPresented;
                    dis.readByte();
                    dis.readByte();
                    short lflags = dis.readShort();
                    this.m_loadBalancingRequested = (lflags & 1) > 0;
                    this.m_faultToleranceRequested = (lflags & 2) > 0;
                    this.m_resumedJMSConnection = (lflags & 4) > 0;
                    boolean clientParametersPresented = (lflags & 0x10) > 0;
                    boolean clientDataPresented = (lflags & 8) > 0;
                    boolean bl = extendedDataPresented = (lflags & 0x20) > 0;
                    if (this.m_incomingClientVer < 27) {
                        try {
                            this.m_clientData = dis.readUTF();
                        }
                        catch (IOException iOException) {}
                    } else {
                        if (clientDataPresented) {
                            this.m_clientData = dis.readUTF();
                        }
                        if (clientParametersPresented) {
                            this.m_clientParameters = ClientConnectParms.unserialize(dis);
                        }
                        if (extendedDataPresented) {
                            try {
                                this.m_extendedClientData = ExtendedClientData.unserialize(dis);
                            }
                            catch (Exception e) {
                                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR184"), new Object[]{e.toString()}));
                }
            }
            return true;
        }
        return false;
    }

    public final boolean isFaultToleranceRequested() {
        return this.m_faultToleranceRequested;
    }

    public final boolean isLoadBalancingRequested() {
        return this.m_loadBalancingRequested;
    }

    public final byte[] getMasterSecret() {
        return this.m_masterSecret;
    }

    public final String getNewBrokerURL() {
        return this.m_newBrokerURL;
    }

    public final boolean isResumedConnection() {
        return this.m_resumedJMSConnection;
    }

    public void setAuthenticationSPI(boolean isAuthenticationSPIEnabled, IAuthentication authenticationSPI) {
        this.m_isAuthenticationSPIEnabled = isAuthenticationSPIEnabled;
        if (this.m_isAuthenticationSPIEnabled) {
            this.m_authenticationSPI = authenticationSPI;
        }
    }

    public void setCipherSuite(IPluggableCipherSuite cipherSuite) {
        this.m_brokerCipherSuite = cipherSuite;
    }

    public final String getUid() {
        return this.m_uid;
    }

    public final ProgressPasswordUser getUser() {
        return this.m_user;
    }

    public final void connectBroker(IUser secbean, boolean active, boolean securityEnabled) {
        this.m_iuser = secbean;
        this.m_active = active;
        this.m_sender = this.m_connection.getSender();
        this.m_client = false;
        this.m_securityEnabled = securityEnabled;
        this.m_cert = this.m_connection.getSocket().getCertificate();
        this.m_state = 1;
    }

    private final void processSecurity() throws EInauthenticClient, EInauthenticBroker, EUnexpectedMgram, EMgramFormatError {
        if (this.m_authenticated) {
            this.m_sender.send(this.buildResponse2());
            this.setDoneState();
        } else if (this.m_user == null && this.m_isAuthenticationSPIEnabled) {
            boolean aquireClientCredentials = true;
            if (this.m_isAuthenticationSPIEnabled && this.m_authenticationSPI != null) {
                try {
                    aquireClientCredentials = this.m_authenticationSPI.aquireClientCredentials();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!(aquireClientCredentials || this.m_user != null && this.m_user.isInternalPrincipal())) {
                String uid = this.m_uid.replace('$', '.');
                try {
                    IPasswordUser passwordUser = this.m_authenticationSPI.authenticate(uid, null, this.m_peerCertChain);
                    ArrayList newExternalGroups = BrokerConnectHandshaker.retrieveNewExternalGroups(passwordUser);
                    if (passwordUser != null) {
                        this.m_uid = passwordUser.getName();
                        this.m_uid = this.m_uid.replace('.', '$');
                        byte[] psw = passwordUser.getPassword();
                        if (psw != null) {
                            this.m_transformedPassword = psw;
                        } else if (psw == null && this.m_transformedPassword == null) {
                            this.m_transformedPassword = new byte[0];
                        }
                    }
                    this.initMUser(newExternalGroups);
                }
                catch (ConnectionException e) {
                    throw new EInauthenticClient(e.getMessage());
                }
                catch (UnauthenticatedException e) {
                    throw new EInauthenticClient(e.getMessage());
                }
                catch (Exception e) {
                    throw new EInauthenticClient(e.getMessage());
                }
                catch (Throwable e) {
                    throw new EInauthenticClient(e.getMessage());
                }
            } else {
                this.m_state = 6;
                this.m_sender.send(this.buildRequestPassword());
            }
        } else {
            this.m_state = 3;
            this.m_sender.send(this.buildChallenge1());
        }
    }

    private void setDoneState() {
        this.m_state = 5;
    }

    private static ArrayList retrieveNewExternalGroups(IPasswordUser passwordUser) {
        String[] externalGroups = null;
        if (passwordUser != null) {
            externalGroups = passwordUser.getGroups();
        }
        ArrayList<String> newExternalGroups = new ArrayList<String>();
        if (externalGroups != null && externalGroups.length > 0) {
            for (int i = 0; i < externalGroups.length; ++i) {
                newExternalGroups.add(externalGroups[i]);
            }
        }
        return newExternalGroups;
    }

    private void initMUser(ArrayList newExternalGroups) throws EInauthenticBroker, EInauthenticClient, EInvalidCipherSuiteException, EMgramFormatError {
        this.m_user = new ProgressPasswordUser(this.m_uid, this.m_transformedPassword);
        this.m_user.setInternalPrincipal(false);
        this.m_user.setExternalGroups(newExternalGroups);
        this.m_sender.send(this.sendMasterSecret(this.m_transformedPassword));
        this.m_state = 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readClientInfo(IMgram m) throws EInauthenticClient, EMgramFormatError {
        block11: {
            try {
                this.m_uid = StringUtil.UTFToString(m.getRawBody(), 1);
                this.m_appid = StringUtil.UTFToString(m.getRawBody(), 1 + StringUtil.lengthUTF(this.m_uid));
                this.traceUid();
                if (this.m_appid.equals(SessionConfig.REQUEST_TMP_APPID)) {
                    Class<ConnectHandshaker> clazz = ConnectHandshaker.class;
                    // MONITORENTER : progress.message.zclient.ConnectHandshaker.class
                    this.m_appid = SessionConfig.TMP_APPID_PREFIX + s_tmpAppIdCnt++ + "$";
                    // MONITOREXIT : clazz
                    break block11;
                }
                if (this.m_appid.equals("$CONNECTION$")) {
                    Class<ConnectHandshaker> clazz = ConnectHandshaker.class;
                    // MONITORENTER : progress.message.zclient.ConnectHandshaker.class
                    this.m_appid = SessionConfig.TMP_APPID_PREFIX + s_tmpAppIdCnt++ + "$" + this.m_appid;
                    // MONITOREXIT : clazz
                }
            }
            catch (Exception e) {
                throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR010"), new Object[]{e.toString()}));
            }
        }
        if (!this.m_securityEnabled) {
            this.m_user = new ProgressPasswordUser(this.m_uid, "");
            return;
        }
        this.traceUid();
        if (!this.m_uid.equals("AUTHENTICATED")) {
            this.m_user = this.m_iuser.getUser(this.m_uid);
            return;
        }
        if (this.m_peerCert == null) return;
        this.m_uid = this.m_peerCert.getSubjectCommonName();
        this.m_uid = this.m_uid.replace('.', '$');
        if (this.m_iuser.getUser(this.m_uid) != null) {
            this.m_user = new ProgressPasswordUser(this.m_uid, "");
            this.m_authenticated = true;
            return;
        }
        if (this.m_isAuthenticationSPIEnabled) return;
        throw new EInauthenticClient();
    }

    private void traceUid() {
    }

    private final IMgram buildRequestPassword() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(10);
        return MgramFactory.getMgramFactory().buildConnectMgram(bos.toByteArray(), 0);
    }

    private IMgram buildResponse2() throws EInauthenticClient, EInauthenticBroker, EMgramFormatError {
        try {
            this.m_masterSecret = new byte[48];
            ProgressSecureRandom.theSecureRandom().nextBytes(this.m_masterSecret);
            this.m_responseData = new byte[48 + PADDED_HASH_LENGTH];
            System.arraycopy(this.m_masterSecret, 0, this.m_responseData, 0, 48);
            byte[] hash = this.getHash(20);
            System.arraycopy(hash, 0, this.m_responseData, 48, hash.length);
            byte[] payload = new byte[this.m_responseData.length + 1];
            payload[0] = 6;
            this.DESEncrypt(this.m_responseData, 0, payload, 1, this.m_responseData.length);
            return MgramFactory.getMgramFactory().buildConnectMgram(payload, 0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EMgramFormatError(prAccessor.getString("STR013"));
        }
    }

    private IMgram sendMasterSecret(byte[] key) throws EInauthenticClient, EInauthenticBroker, EMgramFormatError, EInvalidCipherSuiteException {
        if (this.m_user == null) {
            throw new EInauthenticClient();
        }
        byte[] paddedKey = new byte[key.length + BrokerConnectHandshaker.computePad(key.length)];
        System.arraycopy(key, 0, paddedKey, 0, key.length);
        key = null;
        try {
            this.m_masterSecret = new byte[48];
            ProgressSecureRandom.theSecureRandom().nextBytes(this.m_masterSecret);
            byte[] cipherSuiteInfoInBytes = null;
            if (this.m_brokerCipherSuite.isSonicCipherSuite()) {
                this.m_responseData = new byte[48 + PADDED_HASH_LENGTH];
            } else {
                try {
                    CipherSuiteInfo cipherInfo = this.m_brokerCipherSuite.getCipherSuiteInfo();
                    byte[] byteData = null;
                    byteData = this.m_incomingClientVer < 32 ? cipherInfo.writeBytesWithoutKeySize() : cipherInfo.writeBytes();
                    int size = byteData.length + BrokerConnectHandshaker.computePad(byteData.length);
                    cipherSuiteInfoInBytes = new byte[size];
                    System.arraycopy(byteData, 0, cipherSuiteInfoInBytes, 0, byteData.length);
                }
                catch (IOException ex) {
                    SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                    throw new EInvalidCipherSuiteException("Unable to get Broker side cipher information");
                }
                this.m_responseData = new byte[48 + PADDED_HASH_LENGTH + cipherSuiteInfoInBytes.length];
            }
            System.arraycopy(this.m_masterSecret, 0, this.m_responseData, 0, 48);
            byte[] hash = new byte[20];
            try {
                Class<?> c = Class.forName("progress.message.crypto.SHA");
                ISHA sha = (ISHA)c.newInstance();
                sha.add(this.m_masterSecret);
                sha.add(paddedKey);
                hash = sha.digest();
            }
            catch (Exception e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
            System.arraycopy(hash, 0, this.m_responseData, 48, 20);
            int destPos = 48 + PADDED_HASH_LENGTH;
            if (this.m_responseData.length > destPos) {
                if (cipherSuiteInfoInBytes == null) {
                    throw new NullPointerException("'cipherSuiteInfoInBytes' in " + this.getClass().getName() + ".sendMasterSecret(byte[] key) cannot be null.");
                }
                System.arraycopy(cipherSuiteInfoInBytes, 0, this.m_responseData, destPos, cipherSuiteInfoInBytes.length);
            }
            byte[] payload = new byte[this.m_responseData.length + 1];
            payload[0] = 12;
            this.DESEncrypt(this.m_responseData, 0, payload, 1, this.m_responseData.length, paddedKey);
            return MgramFactory.getMgramFactory().buildConnectMgram(payload, 0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EMgramFormatError(prAccessor.getString("STR013"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyRecoveredTemporaryAppid(long appid) {
        Class<ConnectHandshaker> clazz = ConnectHandshaker.class;
        synchronized (ConnectHandshaker.class) {
            if (s_tmpAppIdCnt <= appid) {
                s_tmpAppIdCnt = appid + 1L;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    private final void DESEncrypt(byte[] src, int srcOffset, byte[] dest, int destOffset, int length, byte[] key) throws EInauthenticClient {
        IDES des = (IDES)this.newInstance("progress.message.crypto.DES");
        des.init(1, key);
        des.doFinal(src, srcOffset, length, dest, destOffset);
    }
}

