/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mf.common.IXMLFragment;
import com.sonicsw.mq.common.runtime.IDurableSubscriptionData;
import com.sonicsw.mq.common.runtime.JMSObjectFactory;
import com.sonicsw.mq.common.runtime.impl.Destination;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DurableSubscriptionData
implements IDurableSubscriptionData,
IXMLFragment,
Serializable {
    static final long serialVersionUID = -1946989810585556025L;
    private static final short CURRENT_VERSION = 1;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        }
    };
    private transient short m_version = 1;
    private String m_clientID;
    private String m_subscriptionName;
    private String m_topicName;
    private String m_user;
    private String m_selector;
    private boolean m_selectorAtBroker;
    private long m_messageCount;
    private long m_messageSize;
    private long m_lastConnectedTime;
    private boolean m_isConnectionConsumer;
    private transient Destination m_destination;

    public DurableSubscriptionData() {
    }

    public DurableSubscriptionData(String user, String clientID, String subscriptionName, byte[] subject, String selector, boolean isSelectorAtBroker, boolean isConnectionConsumer, long messageCount, long messageSize, long lastConnectedTime) {
        this.m_clientID = clientID;
        this.m_subscriptionName = subscriptionName;
        this.m_destination = new Destination(null, subject);
        this.m_messageCount = messageCount;
        this.m_messageSize = messageSize;
        this.m_isConnectionConsumer = isConnectionConsumer;
        this.m_user = user;
        this.m_lastConnectedTime = lastConnectedTime;
        this.m_selector = selector;
        this.m_selectorAtBroker = isSelectorAtBroker;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[user=").append(this.m_user).append(']');
        sb.append("subscriptionName=").append(this.m_subscriptionName);
        sb.append(",topic=").append(this.m_topicName);
        sb.append(",clientID=").append(this.m_clientID);
        sb.append(",selector=").append(this.m_selector);
        sb.append(",selectorAtBroker=").append(this.m_selectorAtBroker);
        sb.append(",messageCount=").append(this.m_messageCount);
        sb.append(",messageSize=").append(this.m_messageSize);
        sb.append(",lastConnectedTime=").append(this.m_lastConnectedTime == -1L ? "Connected" : DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.m_lastConnectedTime)));
        sb.append(",isConnectionConsumer=").append(this.m_isConnectionConsumer);
        return sb.toString();
    }

    public String toXMLFragment() {
        StringBuffer sb = new StringBuffer();
        sb.append("<durableSubscriptionData>");
        sb.append("<user>").append(this.m_user).append("</user>");
        sb.append("<subscriptionName>").append(this.m_subscriptionName).append("</subscriptionName>");
        sb.append("<topic>").append(this.getTopicName()).append("</topic>");
        sb.append("<clientID>").append(this.m_clientID).append("</clientID>");
        sb.append("<selector>").append(this.m_selector).append("</selector>");
        sb.append("<selectorAtBroker>").append(this.m_selectorAtBroker).append("</selectorAtBroker>");
        sb.append("<messageCount>").append(this.m_messageCount).append("</messageCount>");
        sb.append("<messageSize>").append(this.m_messageSize).append("</messageSize>");
        sb.append("<lastConnectedTime>").append(this.m_lastConnectedTime == -1L ? "Connected" : DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.m_lastConnectedTime))).append("</lastConnectedTime>");
        sb.append("<isConnectionConsumer>").append(this.m_isConnectionConsumer).append("</isConnectionConsumer>");
        sb.append("</durableSubscriptionData>");
        return sb.toString();
    }

    @Override
    public String getClientID() {
        return this.m_clientID;
    }

    @Override
    public String getSubscriptionName() {
        return this.m_subscriptionName;
    }

    @Override
    public String getUser() {
        return this.m_user;
    }

    @Override
    public long getMessageCount() {
        return this.m_messageCount;
    }

    @Override
    public long getMessageSize() {
        return this.m_messageSize;
    }

    @Override
    public long getLastConnectedTime() {
        return this.m_lastConnectedTime;
    }

    @Override
    public boolean isConnectionConsumer() {
        return this.m_isConnectionConsumer;
    }

    @Override
    public String getSelector() {
        return this.m_selector;
    }

    @Override
    public boolean isSelectorAtBroker() {
        return this.m_selectorAtBroker;
    }

    @Override
    public String getTopicName() {
        progress.message.jimpl.Destination dest = (progress.message.jimpl.Destination)JMSObjectFactory.createJMSDestination(this.m_destination);
        if (dest == null) {
            return null;
        }
        return dest.getFullName();
    }

    public Destination getDestination() {
        return this.m_destination;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(this.m_version);
        stream.writeUTF(this.m_clientID);
        stream.writeUTF(this.m_subscriptionName);
        if (this.m_version <= 0) {
            stream.writeUTF(this.getTopicName());
        } else {
            stream.writeObject(this.m_destination);
        }
        stream.writeUTF(this.m_user);
        stream.writeBoolean(this.m_isConnectionConsumer);
        stream.writeLong(this.m_messageCount);
        stream.writeLong(this.m_messageSize);
        stream.writeLong(this.m_lastConnectedTime);
        stream.writeBoolean(this.m_selectorAtBroker);
        if (this.m_selector != null) {
            stream.writeBoolean(true);
            stream.writeUTF(this.m_selector);
        } else {
            stream.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.m_version = stream.readShort();
        this.m_clientID = stream.readUTF();
        this.m_subscriptionName = stream.readUTF();
        this.m_destination = this.m_version <= 0 ? new Destination(stream.readUTF()) : (Destination)stream.readObject();
        this.m_topicName = null;
        this.m_user = stream.readUTF();
        this.m_isConnectionConsumer = stream.readBoolean();
        this.m_messageCount = stream.readLong();
        this.m_messageSize = stream.readLong();
        this.m_lastConnectedTime = stream.readLong();
        this.m_selectorAtBroker = stream.readBoolean();
        boolean hasSelector = stream.readBoolean();
        this.m_selector = hasSelector ? stream.readUTF() : null;
    }
}

