/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.IClientContext;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EUserAlreadyConnected;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SubjectUtil;

final class CheckUnsubscribeDurable
implements IMessageHandler {
    private AgentRegistrar m_reg;

    CheckUnsubscribeDurable(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message req = env.getMessage();
            long uid = (long)AddrUtil.getUidFromAdmin(req.getSubject()) & 0xFFFFFFFFL;
            String name = req.readUTF();
            String clientId = req.readUTF();
            IClientContext cc = CheckUnsubscribeDurable.findDurableClient(uid, clientId, name);
            if (cc.isConnected()) {
                throw new EUserAlreadyConnected(clientId);
            }
            if (cc.getDurableBrokerSubscription() == null) {
                throw new EClientNotRegistered(cc.getId());
            }
            CheckUnsubscribeDurable.sendReply(env, 0);
        }
        catch (EInvalidApplicationId e) {
            CheckUnsubscribeDurable.sendReply(env, e.getErrorId());
        }
        catch (EClientNotRegistered ecnr) {
            CheckUnsubscribeDurable.sendReply(env, 157);
        }
        catch (EUserAlreadyConnected euac) {
            CheckUnsubscribeDurable.sendReply(env, euac.getErrorId());
        }
        catch (EInvalidAdminAddress eiaa) {
            CheckUnsubscribeDurable.sendReply(env, eiaa.getErrorId());
        }
        catch (EGeneralException e) {
            CheckUnsubscribeDurable.sendReply(env, e.getErrorId());
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (IOException e) {
            CheckUnsubscribeDurable.sendReply(env, -40);
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    static final IClientContext findDurableClient(long uid, String clientId, String name) throws EClientNotRegistered {
        String appid = SessionConfig.createDurableAppid(clientId, name, false);
        try {
            return CheckUnsubscribeDurable.getClient(uid, SessionConfig.createDurableAppid(clientId, name, false));
        }
        catch (EClientNotRegistered ecnr) {
            return CheckUnsubscribeDurable.getClient(uid, SessionConfig.createDurableAppid(clientId, name, true));
        }
    }

    private static final IClientContext getClient(long uid, String appid) throws EClientNotRegistered {
        long aid = SubjectUtil.computeSCode(appid, 0, appid.length());
        long id = aid << 32 | uid;
        return AgentRegistrar.getAgentRegistrar().getClient(id);
    }

    static void sendReply(Envelope req, int response) {
        block2: {
            try {
                Message rep = new Message();
                rep.write(response);
                AgentRegistrar.getAgentRegistrar().getAdminSession().reply(rep, req, false);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block2;
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR271") + e.getMessage(), (Throwable)e, 2);
            }
        }
    }
}

