/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.broker.durable.ICWADSInfo;
import progress.message.util.WrappedDataInputStream;
import progress.message.util.WrappedDataOutputStream;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.Subject;

public class CWADSInfo
implements ICWADSInfo {
    protected long m_cid = -1L;
    protected boolean m_isConnected;
    protected String m_active_uid = "$INACTIVE";
    protected String m_active_appid = "$INACTIVE";
    protected String m_previous_uid = "$INACTIVE";
    protected String m_previous_appid = "$INACTIVE";
    protected long m_restoringBrokerCID = -1L;
    protected String m_sender_uid;
    protected String m_sender_appid;
    protected long m_timestamp = -1L;
    protected String m_uid = null;
    protected String m_appid = null;
    protected ISubject m_subject = null;
    protected String m_selector = null;
    protected boolean m_selectorAtBroker = false;
    protected Label m_label = null;
    protected long m_TTE = -1L;
    protected boolean m_durableSMO = false;
    protected long m_rootClientId = -1L;
    protected int m_type = 100;
    private boolean m_isResumable;

    public final void loadFromRequest(Message req) throws IOException {
        this.deserializeInfo(req);
    }

    public CWADSInfo() {
    }

    public CWADSInfo(IClientContext durcc) throws ESubscriptionNotFound {
        this.loadFromLocalInfo(durcc, null);
    }

    public CWADSInfo(IClientContext cc, BrokerSubscription bs) throws ESubscriptionNotFound {
        this.loadFromLocalInfo(cc, bs);
    }

    protected final void loadFromLocalInfo(IClientContext cc, BrokerSubscription bsParam) throws ESubscriptionNotFound {
        BrokerSubscription bs = bsParam;
        if (bs == null && (bs = cc.getDurableBrokerSubscription()) == null) {
            throw new ESubscriptionNotFound("Null subscription loading CWADSInfo for " + cc);
        }
        this.m_cid = cc.getId();
        this.m_isConnected = cc.isConnected();
        IClientContext activecc = cc.getCWADSActiveBroker();
        String activeuid = "$INACTIVE";
        String activeappid = "$INACTIVE";
        if (activecc != null) {
            if (activecc.isInterbroker()) {
                activeuid = activecc.getUid();
                activeappid = activecc.getAppid();
            } else {
                activeuid = Config.BROKER_UID;
                activeappid = "Broker";
            }
        }
        this.m_active_uid = activeuid;
        this.m_active_appid = activeappid;
        long previousCID = -1L;
        IClientContext previouscc = cc.getCWADSPreviousBroker();
        if (previouscc != null) {
            if (previouscc.isInterbroker()) {
                this.m_previous_uid = previouscc.getUid();
                this.m_previous_appid = previouscc.getAppid();
            } else {
                this.m_previous_uid = Config.BROKER_UID;
                this.m_previous_appid = "Broker";
            }
        } else {
            this.m_previous_uid = "$INACTIVE";
            this.m_previous_appid = "$INACTIVE";
        }
        IClientContext restoringBrokercc = cc.getCWADSRestoringBroker();
        if (restoringBrokercc != null) {
            this.m_restoringBrokerCID = restoringBrokercc.getId() == cc.getId() ? AddrUtil.stringToClientId(Config.BROKER_UID, "Broker") : restoringBrokercc.getId();
        }
        this.m_timestamp = bs.getCreationTime();
        this.m_uid = cc.getUid();
        this.m_appid = cc.getAppid();
        this.m_subject = bs.getSubject();
        this.m_selector = bs.getSelectorString();
        this.m_selectorAtBroker = bs.getSelectorAtBroker();
        this.m_label = bs.getLabel();
        this.m_TTE = bs.getTTE();
        this.m_sender_uid = Config.BROKER_UID;
        this.m_sender_appid = "Broker";
        this.m_durableSMO = bs.getDurableStrictMessageOrder();
        this.m_isResumable = cc.isResumable();
        try {
            this.m_rootClientId = cc.getRootId();
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    public final void setType(int type) {
        this.m_type = type;
    }

    public void serializeInfo(DataOutput doutput) throws IOException {
        WrappedDataOutputStream dos = new WrappedDataOutputStream(doutput);
        doutput.writeLong(this.m_cid);
        doutput.writeInt(this.m_type);
        doutput.writeBoolean(this.m_isConnected);
        doutput.writeUTF(this.m_active_uid);
        doutput.writeUTF(this.m_active_appid);
        doutput.writeUTF(this.m_previous_uid);
        doutput.writeUTF(this.m_previous_appid);
        doutput.writeLong(this.m_restoringBrokerCID);
        doutput.writeUTF(this.m_sender_uid);
        doutput.writeUTF(this.m_sender_appid);
        doutput.writeLong(this.m_timestamp);
        doutput.writeUTF(this.m_uid);
        doutput.writeUTF(this.m_appid);
        this.m_subject.writeToStream(dos);
        if (this.m_selector == null) {
            doutput.writeUTF("$NULL$");
        } else {
            doutput.writeUTF(this.m_selector);
        }
        doutput.writeBoolean(this.m_selectorAtBroker);
        doutput.writeBoolean(this.m_durableSMO);
        this.m_label.serialize(doutput);
        doutput.writeLong(this.m_TTE);
        doutput.writeBoolean(this.m_isResumable);
        doutput.writeLong(this.m_rootClientId);
    }

    protected void deserializeInfo(DataInput dinput) throws IOException {
        WrappedDataInputStream dis = new WrappedDataInputStream(dinput);
        this.m_cid = dinput.readLong();
        this.m_type = dinput.readInt();
        this.m_isConnected = dinput.readBoolean();
        this.m_active_uid = dinput.readUTF();
        this.m_active_appid = dinput.readUTF();
        this.m_previous_uid = dinput.readUTF();
        this.m_previous_appid = dinput.readUTF();
        this.m_restoringBrokerCID = dinput.readLong();
        this.m_sender_uid = dinput.readUTF();
        this.m_sender_appid = dinput.readUTF();
        this.m_timestamp = dinput.readLong();
        this.m_uid = dinput.readUTF();
        this.m_appid = dinput.readUTF();
        this.m_subject = Subject.createFromStream(dis);
        this.m_selector = dinput.readUTF();
        if (this.m_selector.equals("$NULL$")) {
            this.m_selector = null;
        }
        this.m_selectorAtBroker = dinput.readBoolean();
        this.m_durableSMO = dinput.readBoolean();
        this.m_label = Label.unserialize(dinput);
        this.m_TTE = dinput.readLong();
        this.m_isResumable = dinput.readBoolean();
        this.m_rootClientId = dinput.readLong();
    }

    @Override
    public final long getId() {
        return this.m_cid;
    }

    @Override
    public final boolean getIsConnected() {
        return this.m_isConnected;
    }

    @Override
    public final boolean getIsResumable() {
        return this.m_isResumable;
    }

    @Override
    public final String getActiveUid() {
        return this.m_active_uid;
    }

    @Override
    public final String getActiveAppid() {
        return this.m_active_appid;
    }

    @Override
    public final boolean getDurableSMO() {
        return this.m_durableSMO;
    }

    @Override
    public final String getPreviousUid() {
        return this.m_previous_uid;
    }

    @Override
    public final String getPreviousAppid() {
        return this.m_previous_appid;
    }

    @Override
    public final long getRestoringBrokerId() {
        return this.m_restoringBrokerCID;
    }

    @Override
    public final long getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public final String getUid() {
        return this.m_uid;
    }

    @Override
    public final String getAppid() {
        return this.m_appid;
    }

    @Override
    public final ISubject getSubject() {
        return this.m_subject;
    }

    @Override
    public final String getSelector() {
        return this.m_selector;
    }

    @Override
    public final boolean getSelectorAtBroker() {
        return this.m_selectorAtBroker;
    }

    @Override
    public final Label getLabel() {
        return this.m_label;
    }

    @Override
    public final long getTTE() {
        return this.m_TTE;
    }

    @Override
    public final String getSenderUid() {
        return this.m_sender_uid;
    }

    @Override
    public final String getSenderAppid() {
        return this.m_sender_appid;
    }

    @Override
    public final long getRootClientId() {
        return this.m_rootClientId;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public final long calcSenderClientId() {
        return AddrUtil.stringToClientId(this.getSenderUid(), this.getSenderAppid());
    }

    public final long calcTargetClientId() {
        return AddrUtil.stringToClientId(this.getUid(), this.getAppid());
    }

    public final long calcPreviousClientId() {
        return AddrUtil.stringToClientId(this.getPreviousUid(), this.getPreviousAppid());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String expectedIdStr = this.m_uid + "/" + this.m_appid;
        String localIdStr = CWADSInfo.getClientString(this.m_cid, expectedIdStr);
        sb.append(" id=").append(localIdStr);
        if (!expectedIdStr.endsWith(localIdStr)) {
            sb.append(" (ERROR: expected=").append(expectedIdStr).append(')');
        }
        sb.append(" sender_uid/appid=").append(this.m_sender_uid).append('/').append(this.m_sender_appid);
        sb.append(" active_uid/appid=").append(this.m_active_uid).append('/').append(this.m_active_appid);
        sb.append(" previous_uid/appid=").append(this.m_previous_uid).append('/').append(this.m_previous_appid);
        sb.append(" restoringBroker_cid=").append(CWADSInfo.getClientString(this.m_restoringBrokerCID, "" + this.m_restoringBrokerCID));
        sb.append(" timestamp=").append(this.m_timestamp);
        sb.append(" subject=").append(this.m_subject);
        sb.append(" selector=").append(this.m_selector);
        sb.append(" selectorAtBroker=").append(this.m_selectorAtBroker);
        sb.append(" durableSMO=").append(this.m_durableSMO);
        sb.append(" tte=").append(this.m_TTE);
        sb.append(" isConnected=").append(this.m_isConnected);
        sb.append(" rootClientId=").append(this.m_rootClientId);
        sb.append(" isResumable=").append(this.m_isResumable);
        sb.append(" type=").append(CWADSInfo.getTypeString(this.m_type));
        return sb.toString();
    }

    static final String getTypeString(int type) {
        switch (type) {
            case 103: {
                return "DISCONNECT";
            }
            case 104: {
                return "NEW_PREVIOUS_NOTIFICATION";
            }
            case 111: {
                return "STARTDELIVERY";
            }
            case 113: {
                return "STOPDELIVERY";
            }
            case 102: {
                return "UNSUBSCRIBE";
            }
            case 100: {
                return "CWADS_UPDATE";
            }
        }
        return "UNKNOWN";
    }

    static final String getClientString(long clientid, String defaultString) {
        if (clientid == -1L) {
            return "NO_PARENT";
        }
        try {
            IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(clientid);
            return cc.getUid() + "/" + cc.getAppid();
        }
        catch (EClientNotRegistered ex) {
            return "UNREGISTERED:" + defaultString;
        }
    }
}

