/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import java.io.EOFException;
import java.nio.charset.StandardCharsets;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttMessage;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.util.server.ByteBuffer;
import progress.message.util.server.IByteBuffer;

public class MqttCodecUtils {
    private static final int MAX_STRING_LEN = 65536;

    public static byte readMessageType(IByteBuffer in) throws EOFException {
        if (in.countUnread() < 1) {
            return 0;
        }
        in.markRead();
        byte h1 = in.readByte();
        byte messageType = (byte)((h1 & 0xF0) >> 4);
        in.gotoMarkedRead();
        return messageType;
    }

    public static boolean checkHeaderAvailability(IByteBuffer in) throws EOFException {
        if (in.countUnread() < 1) {
            return false;
        }
        in.markRead();
        in.skipBytes(1);
        int remainingLength = MqttCodecUtils.decodeRemainingLenght(in);
        if (remainingLength == -1) {
            in.gotoMarkedRead();
            return false;
        }
        if (in.countUnread() < remainingLength) {
            in.gotoMarkedRead();
            return false;
        }
        in.gotoMarkedRead();
        return true;
    }

    public static int decodeRemainingLenght(IByteBuffer in) throws EOFException {
        byte digit;
        int multiplier = 1;
        int value = 0;
        do {
            if (in.countUnread() < 1) {
                return -1;
            }
            digit = in.readByte();
            value += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0);
        return value;
    }

    public static IByteBuffer encodeRemainingLength(int valueParam) {
        int value = valueParam;
        ByteBuffer encoded = new ByteBuffer(2);
        do {
            byte digit = (byte)(value % 128);
            if ((value /= 128) > 0) {
                digit = (byte)(digit | 0x80);
            }
            encoded.writeByte(digit);
        } while (value > 0);
        return encoded;
    }

    public static String decodeString(IByteBuffer in) throws EOFException, MqttException {
        if (in.countUnread() < 2) {
            return null;
        }
        int strLen = in.readUnsignedShort();
        if (strLen < 0) {
            throw new MqttException("Invalid string length = " + strLen);
        }
        if (in.countUnread() < strLen) {
            return null;
        }
        byte[] strRaw = new byte[strLen];
        in.read(strRaw);
        return new String(strRaw, StandardCharsets.UTF_8);
    }

    public static IByteBuffer encodeString(String str) throws MqttException {
        byte[] raw = str.getBytes(StandardCharsets.UTF_8);
        if (raw.length > 65536) {
            throw new MqttException("Invalid string length = " + raw.length);
        }
        ByteBuffer out = new ByteBuffer(2 + raw.length);
        out.writeUnsignedShort(raw.length);
        out.write(raw);
        return out;
    }

    public static int numBytesToEncode(int len) {
        if (0 <= len && len <= 127) {
            return 1;
        }
        if (128 <= len && len <= 16383) {
            return 2;
        }
        if (16384 <= len && len <= 0x1FFFFF) {
            return 3;
        }
        if (0x200000 <= len && len <= 0xFFFFFFF) {
            return 4;
        }
        throw new IllegalArgumentException("value shoul be in the range [0..268435455]");
    }

    public static byte encodeFlags(MqttMessage message) {
        MqttQoS qos;
        byte flags = 0;
        if (message.isDupFlag()) {
            flags = (byte)(flags | 8);
        }
        if (message.isRetainFlag()) {
            flags = (byte)(flags | 1);
        }
        if ((qos = message.getQos()) != null) {
            int qosOrdinal = qos.ordinal();
            flags = (byte)(flags | (qosOrdinal & 3) << 1);
        }
        return flags;
    }
}

