/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.LogEvent;
import progress.message.broker.LogManager;
import progress.message.ft.IFTEventProcessor;
import progress.message.ft.ReplicationDemultiplexer;
import progress.message.ft.ReplicationManager;
import progress.message.ft.StateEventNullExec;
import progress.message.util.DebugState;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IStateEvent;

public class DynamicSyncRecoveryController
extends DebugObject
implements IFTEventProcessor {
    private ReplicationDemultiplexer.EventQueue m_eventQueue;
    private ReplicationManager m_replMgr;
    private LogManager m_logMgr;
    private LongHashTable<LinkedList<IStateEvent>> m_eventBuffer = new LongHashTable();
    private boolean m_clientRegistrySyncComplete = false;
    private boolean m_subscriptionSyncComplete = false;

    public DynamicSyncRecoveryController(ReplicationDemultiplexer.EventQueue queue, ReplicationManager mgr) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DynamicSyncRecoveryController" : null);
        this.m_eventQueue = queue;
        this.m_replMgr = mgr;
        this.m_logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
    }

    @Override
    public void addEventNoLog(IStateEvent e) throws InterruptedException {
        boolean buffered = this.buffer(e);
        if (!buffered) {
            if (this.DEBUG) {
                this.debug("NOT buffering: " + e);
            }
            LogEvent evt = (LogEvent)e;
            this.m_eventQueue.enqueue(evt);
        } else if (this.DEBUG) {
            this.debug("Buffering: " + e);
        }
    }

    @Override
    public void addEvent(IStateEvent e, long trackingNum) throws InterruptedException {
        boolean buffered = this.buffer(e);
        if (!buffered) {
            LogEvent evt = (LogEvent)e;
            this.m_eventQueue.enqueue(evt);
        }
        StateEventNullExec logEvt = new StateEventNullExec(e);
        this.m_logMgr.addReplicatedEvent(logEvt, true);
        this.m_replMgr.acknowledge(trackingNum);
    }

    private synchronized boolean buffer(IStateEvent e) {
        boolean usesClientRegistry = e.usesClientRegistry();
        boolean usesSubsciptionTable = e.usesSubscriptionTable();
        if (usesSubsciptionTable && !this.m_subscriptionSyncComplete || usesClientRegistry && !this.m_clientRegistrySyncComplete) {
            long clientId = e.getClientID();
            LinkedList<IStateEvent> bufferList = this.m_eventBuffer.get(clientId);
            if (bufferList == null) {
                if (!e.mustBeBuffered()) {
                    return false;
                }
                bufferList = new LinkedList();
                this.m_eventBuffer.put(clientId, bufferList);
            }
            bufferList.addLast(e);
            return true;
        }
        return false;
    }

    private void enqueueCompletedEvents() {
        if (!this.m_eventBuffer.isEmpty()) {
            Enumeration entries = ((LongHashTable)this.m_eventBuffer.clone()).elements();
            block0: while (entries.hasMoreElements()) {
                LinkedList events = (LinkedList)entries.nextElement();
                Iterator iter = events.iterator();
                while (iter.hasNext()) {
                    IStateEvent evt = (IStateEvent)iter.next();
                    boolean usesClientRegistry = evt.usesClientRegistry();
                    boolean usesSubscriptiontable = evt.usesSubscriptionTable();
                    if (usesClientRegistry && !this.m_clientRegistrySyncComplete || usesSubscriptiontable && !this.m_subscriptionSyncComplete) continue block0;
                    iter.remove();
                    if (events.isEmpty()) {
                        this.m_eventBuffer.remove(evt.getClientID());
                    }
                    if (this.DEBUG) {
                        this.debug("Submitting: " + evt + " Cid: " + evt.getClientID());
                    }
                    this.m_eventQueue.forceEnqueue((LogEvent)evt);
                }
            }
        }
    }

    public synchronized void setClientRegistrySyncComplete() {
        if (this.DEBUG) {
            this.debug("setClientRegistrySyncComplete called");
        }
        this.m_clientRegistrySyncComplete = true;
        this.enqueueCompletedEvents();
    }

    public synchronized void setSubscriptionSyncComplete() {
        if (this.DEBUG) {
            this.debug("setSubscriptionSyncComplete called");
        }
        this.m_subscriptionSyncComplete = true;
        this.enqueueCompletedEvents();
    }

    public synchronized void reset() {
        this.m_clientRegistrySyncComplete = false;
        this.m_subscriptionSyncComplete = false;
        this.m_eventBuffer.clear();
    }
}

