/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.BinaryRefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import progress.message.client.EInvalidSubjectOperation;
import progress.message.client.prAccessor;
import progress.message.jclient.AdministeredObjectFactory;
import progress.message.jclient.DestinationFactory;
import progress.message.jclient.MultiDestination;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.Destination;
import progress.message.jimpl.TemporaryTopic;
import progress.message.jimpl.Topic;
import progress.message.jimpl.api.IMultiTopic;
import progress.message.zclient.ISubject;
import progress.message.zclient.Subject;

public class MultiTopic
implements progress.message.jclient.MultiTopic,
javax.jms.Topic,
Destination,
Cloneable,
IMultiTopic {
    private static final byte ROUTING_MASK = 1;
    private transient Subject m_subject = null;
    private transient String m_routing = null;
    private transient HashMap m_localTempTopics = null;
    private transient boolean m_validatedForSend = false;

    public MultiTopic() {
        this.m_subject = new Subject();
    }

    public MultiTopic(String group, String routing) throws InvalidDestinationException {
        this.m_subject = new Subject();
        if (group != null && group.trim().length() > 0) {
            DestUtil.validateGroupPrefix(group);
            this.m_subject.setGroupName(group);
        }
        DestUtil.validateRoutingName(routing);
        this.setRouting(routing);
    }

    MultiTopic(String routing, ISubject subject) {
        this.m_subject = (Subject)subject;
        this.setRouting(routing);
    }

    MultiTopic(MultiTopic t) {
        this.m_routing = t.m_routing;
        this.m_subject = (Subject)t.m_subject.protectedClone();
        if (t.m_localTempTopics != null) {
            this.m_localTempTopics = (HashMap)t.m_localTempTopics.clone();
        }
        this.m_validatedForSend = t.m_validatedForSend;
    }

    MultiTopic protectedClone() {
        return new MultiTopic(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return new MultiTopic(this);
    }

    public void add(javax.jms.Destination dest) throws JMSException {
        if (dest instanceof Destination) {
            this.addInternal((Destination)dest);
        } else if (dest instanceof javax.jms.Topic) {
            this.addInternal((Destination)DestinationFactory.createSonicDestination(dest));
        }
    }

    public final void remove(javax.jms.Destination dest) throws JMSException {
        if (dest instanceof Destination) {
            this.removeInternal((Destination)dest);
        } else if (dest instanceof javax.jms.Topic) {
            this.removeInternal((Destination)DestinationFactory.createSonicDestination(dest));
        }
    }

    private final void addInternal(Destination dest) throws JMSException {
        if (!(dest instanceof javax.jms.Topic)) {
            throw new JMSException("Unable to add destination, javax.jms.Topic required: " + dest);
        }
        boolean firstAdd = true;
        if (this.m_subject.isSubjectSet()) {
            firstAdd = false;
            if (!this.matchRouting(dest.getRouting())) {
                throw new JMSException("Routing mismatch.");
            }
            if (!this.matchGroup(dest)) {
                throw new JMSException("Cannot add destination with mismatched Shared Subscription Group prefix: this: " + this.m_subject.getGroupName() + " dest: " + dest.getGroupName());
            }
        }
        if (dest.isTemporary() && dest instanceof TemporaryTopic) {
            if (this.m_localTempTopics == null) {
                this.m_localTempTopics = new HashMap();
            }
            if (this.m_localTempTopics.containsKey(dest.getSubject())) {
                return;
            }
            this.m_localTempTopics.put(dest.getSubject(), dest);
        }
        if (dest.getSubject().isMultiSubject()) {
            Iterator<ISubject> it = dest.getSubject().getMultiSubjects();
            while (it.hasNext()) {
                this.m_subject.addSubject(it.next());
            }
        } else {
            if (dest.getSubject().getSubjectString().indexOf("|") != -1 || dest.hasRouting() && dest.getRouting().indexOf("|") != -1) {
                throw new InvalidDestinationException("'|' cannot be used in a component destination name: " + dest);
            }
            this.m_subject.addSubject(dest.getSubject());
        }
        if (firstAdd) {
            this.setRouting(dest.getRouting());
            this.m_subject.setGroupName(dest.getGroupName());
        }
        this.m_validatedForSend = false;
    }

    private final void removeInternal(Destination d) throws JMSException {
        ISubject s;
        if (!this.matchRouting(d.getRouting())) {
            return;
        }
        if (d.isTemporary()) {
            if (this.m_localTempTopics == null) {
                return;
            }
            javax.jms.Destination temp = (javax.jms.Destination)this.m_localTempTopics.remove(d.getSubject());
            if (temp == null) {
                return;
            }
        }
        if ((s = d.getSubject()).isQueue()) {
            return;
        }
        if (s.isMultiSubject()) {
            Iterator<ISubject> i = s.getMultiSubjects();
            while (i.hasNext()) {
                this.m_subject.removeSubject(i.next());
            }
        } else {
            this.m_subject.removeSubject(s);
        }
        if (!this.m_subject.isMultiSubject()) {
            this.m_routing = null;
        }
    }

    public boolean contains(javax.jms.Destination dest) throws JMSException {
        if (dest instanceof MultiDestination) {
            Iterator i = ((MultiDestination)dest).iterator();
            while (i.hasNext()) {
                if (this.contains((javax.jms.Destination)i.next())) continue;
                return false;
            }
            return true;
        }
        if (dest instanceof javax.jms.Topic) {
            Destination d = (Destination)DestinationFactory.createSonicDestination(dest);
            if (this.m_subject == null || this.m_subject.getMultiSubjectCount() == 0) {
                return false;
            }
            if (d.getSubject() == null) {
                return false;
            }
            if (!this.matchRouting(d.getRouting())) {
                return false;
            }
            if (!this.matchGroup(d)) {
                return false;
            }
            return this.m_subject.intersect(d.getSubject(), false) != null;
        }
        return false;
    }

    public final Iterator iterator() throws JMSException {
        return new Iterator(){
            Iterator subIterator;
            ISubject current;
            {
                this.subIterator = MultiTopic.this.m_subject.getMultiSubjects();
                this.current = null;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException("Remove called with no curent element");
                }
                if (this.subIterator == null) {
                    return;
                }
                this.subIterator.remove();
                if (MultiTopic.this.m_localTempTopics != null && this.current.isTemporary()) {
                    MultiTopic.this.m_localTempTopics.remove(this.current);
                }
                if (!MultiTopic.this.m_subject.isMultiSubject()) {
                    MultiTopic.this.m_routing = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.subIterator != null && this.subIterator.hasNext();
            }

            public Object next() {
                Object o;
                if (this.subIterator == null || (this.current = (ISubject)this.subIterator.next()) == null) {
                    throw new NoSuchElementException();
                }
                if (this.current.isTemporary() && MultiTopic.this.m_localTempTopics != null && (o = MultiTopic.this.m_localTempTopics.get(this.current)) != null) {
                    return o;
                }
                String jmsName = this.current.getJMSName();
                if (MultiTopic.this.m_routing != null) {
                    jmsName = MultiTopic.this.m_routing + "::" + jmsName;
                }
                try {
                    return new Topic(jmsName);
                }
                catch (JMSException ex) {
                    throw new EInvalidSubjectOperation("Invalid Topic Name: " + jmsName, ex);
                }
            }
        };
    }

    public void clear() {
        this.m_routing = null;
        this.m_subject = new Subject();
    }

    private final boolean matchRouting(String routing) {
        if (routing == this.m_routing) {
            return true;
        }
        if (routing != null) {
            if (routing.trim().length() == 0 && this.m_routing == null) {
                return true;
            }
            if (routing.equals(this.m_routing)) {
                return true;
            }
        }
        return false;
    }

    private final boolean matchGroup(Destination dest) throws JMSException {
        if (dest.hasGroup() != this.m_subject.hasGroup()) {
            return false;
        }
        return !dest.hasGroup() || this.m_subject.getGroupName().equalsIgnoreCase(dest.getGroupName());
    }

    @Override
    public String getTopicName() {
        if (this.hasRouting()) {
            return this.m_routing + "::" + this.m_subject.getSubjectString();
        }
        if (this.m_subject.isSubjectSet()) {
            return this.m_subject.getJMSName();
        }
        return "MULTITOPIC:";
    }

    @Override
    public String getFullName() {
        return this.getTopicName();
    }

    @Override
    public String getDestinationName() throws JMSException {
        return this.getTopicName();
    }

    @Override
    public final ISubject getSubject() {
        return this.m_subject;
    }

    @Override
    public final boolean hasGroup() {
        return this.m_subject.hasGroup();
    }

    @Override
    public final String getGroupName() {
        return this.m_subject.getGroupName();
    }

    @Override
    public final boolean hasRouting() {
        return this.m_routing != null;
    }

    @Override
    public final String getRouting() {
        return this.m_routing;
    }

    private final void setRouting(String routing) {
        this.m_routing = routing != null && routing.trim().length() > 0 ? routing : null;
    }

    @Override
    public final boolean isTemporary() {
        return false;
    }

    @Override
    public boolean isDeleted() throws JMSException {
        return false;
    }

    @Override
    public boolean isQueue() throws JMSException {
        return false;
    }

    @Override
    public boolean isTopic() throws JMSException {
        return true;
    }

    @Override
    public boolean isMultiDestination() throws JMSException {
        return true;
    }

    @Override
    public void validateForSend(Message message) throws JMSException {
        this.checkIsSubjectSet();
        if (this.m_validatedForSend && this.m_localTempTopics != null && !this.m_localTempTopics.isEmpty()) {
            for (Destination d : this.m_localTempTopics.values()) {
                if (!d.isDeleted()) continue;
                throw new InvalidDestinationException(prAccessor.getString("TOP_PUB_DELETED_TEMPORARY_TOPIC"));
            }
        }
        if (this.m_validatedForSend && (message == null || !message.propertyExists("X-HTTP-DestinationURL"))) {
            return;
        }
        if (this.m_subject.hasGroup()) {
            throw new InvalidDestinationException(prAccessor.getString("TOP_PUB_INVALID_GROUP_PREFIX"));
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ((Destination)i.next()).validateForSend(message);
        }
        this.m_validatedForSend = true;
    }

    public Reference getReference() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.m_subject.getSerializedLength());
        try {
            ObjectOutputStream os = new ObjectOutputStream(baos);
            this.writeObject(os);
            os.close();
        }
        catch (IOException os) {
            // empty catch block
        }
        Reference ref = new Reference(MultiTopic.class.getName(), new BinaryRefAddr("subject", baos.toByteArray()), AdministeredObjectFactory.class.getName(), null);
        ref.add(new StringRefAddr("versionID", "14.0"));
        return ref;
    }

    @Override
    public int hashCode() {
        int hashCode = this.m_subject.hashCode();
        if (this.m_routing != null) {
            hashCode += this.m_routing.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTopic t = (MultiTopic)o;
        if (t.m_routing == this.m_routing || this.m_routing != null && this.m_routing.equals(t.m_routing)) {
            return this.m_subject.equals(t.m_subject);
        }
        return false;
    }

    private final void writeObject(ObjectOutputStream os) throws IOException {
        os.writeUTF("14.0");
        ISubject toWrite = this.m_subject.filterTemporarySubjects().clearSubjectTracking();
        int flags = this.hasRouting() && toWrite.isSubjectSet() ? 1 : 0;
        os.writeByte(flags);
        if ((flags & 1) != 0) {
            os.writeUTF(this.m_routing);
        }
        toWrite.writeToStream(os);
    }

    private final void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.initFromStream(is);
    }

    public final void initFromStream(ObjectInputStream is) throws IOException {
        String strVersion = is.readUTF();
        byte flags = is.readByte();
        if ((flags & 1) != 0) {
            this.setRouting(is.readUTF());
        }
        Subject s = new Subject();
        s.initFromStream(is);
        this.m_subject = s;
    }

    @Override
    public void validateForConsume(Connection connection) throws JMSException {
        this.checkIsSubjectSet();
        if (!this.getSubject().hasTemporary()) {
            return;
        }
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Destination d = (Destination)i.next();
            d.validateForConsume(connection);
        }
    }

    private void checkIsSubjectSet() throws InvalidDestinationException {
        if (!this.m_subject.isSubjectSet()) {
            throw new InvalidDestinationException(prAccessor.getString("EMPTY_MULTI_TOPIC"));
        }
    }

    @Override
    public String toString() {
        return this.getTopicName();
    }
}

