/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.parser;

import java.io.StringReader;
import javax.jms.InvalidSelectorException;
import progress.message.jimpl.IMessageSelector;
import progress.message.jimpl.ISelectorFactory;
import progress.message.jimpl.parser.MessageSelector;
import progress.message.jimpl.parser.ParseException;
import progress.message.jimpl.parser.Selector;
import progress.message.jimpl.parser.TokenMgrError;

public class SelectorFactory
implements ISelectorFactory {
    @Override
    public IMessageSelector createMessageSelector(String selectorString) throws InvalidSelectorException {
        MessageSelector messageSelector = null;
        try {
            StringReader fs = new StringReader(selectorString);
            Selector parser = new Selector(fs);
            messageSelector = parser.MessageSelector();
        }
        catch (ParseException pe) {
            InvalidSelectorException exc = new InvalidSelectorException(pe.getMessage());
            exc.setLinkedException(pe);
            throw exc;
        }
        catch (TokenMgrError tme) {
            InvalidSelectorException exc = new InvalidSelectorException(tme.getMessage());
            throw exc;
        }
        return messageSelector;
    }
}

