/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpConfigInfo {
    private String m_name = null;
    private String[] m_names = null;
    private Element m_parent = null;
    private Object m_instance = null;
    private Hashtable m_contentMaps = null;
    private Object m_factoryInstance = null;
    private Properties m_properties = null;

    public HttpConfigInfo(String name, Properties properties) {
        this.m_name = name;
        this.m_properties = properties;
        this.indexUrl();
    }

    public HttpConfigInfo(String name, Element parent) {
        this.m_name = name;
        this.m_parent = parent;
        this.indexUrl();
    }

    private void indexUrl() {
        if (this.m_name == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.m_name, "/\\");
        int count = st.countTokens();
        this.m_names = new String[count];
        for (int i = 0; i < count; ++i) {
            this.m_names[i] = st.nextToken();
        }
    }

    void resetUrl(String newURL) {
        this.m_name = newURL;
        this.indexUrl();
    }

    public boolean getBooleanElement(String key, boolean defVal) {
        Boolean val = this.getBooleanElement(key, new Boolean(defVal));
        if (val != null) {
            return val;
        }
        return defVal;
    }

    public Boolean getBooleanElement(String key) {
        return this.getBooleanElement(key, null);
    }

    public Boolean getBooleanElement(String key, Boolean defVal) {
        String val = this.getStringValue(key);
        if (val == null) {
            return defVal;
        }
        return Boolean.valueOf(val);
    }

    public int getIntElement(String key) {
        return this.getIntElement(key, -1);
    }

    public int getIntElement(String key, int defVal) {
        String val = this.getStringValue(key);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defVal;
    }

    public long getLongElement(String key) {
        return this.getLongElement(key, -1L);
    }

    public long getLongElement(String key, long defVal) {
        String val = this.getStringValue(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defVal;
    }

    public String getStringElement(String key) {
        return this.getStringElement(key, null);
    }

    public String getStringElement(String key, String defVal) {
        String val = this.getStringValue(key);
        if (val == null) {
            val = defVal;
        }
        return val;
    }

    public String getName() {
        return this.m_name;
    }

    public Object getInstance() {
        return this.m_instance;
    }

    public void setInstance(Object instance) {
        this.m_instance = instance;
    }

    public String toString() {
        return this.m_name;
    }

    private Element findElement(Element parent, String name) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(name)) continue;
            return (Element)node;
        }
        return null;
    }

    private String getStringValue(String key) {
        if (this.m_parent == null) {
            if (this.m_properties != null) {
                return (String)this.m_properties.get(key);
            }
        } else {
            Element elem = this.findElement(this.m_parent, key);
            if (elem != null) {
                Node node = elem.getFirstChild();
                if (node != null && node.getNodeType() == 3) {
                    return node.getNodeValue();
                }
                System.out.println("Failed to get value for XML element " + key);
            }
        }
        return null;
    }

    protected int checkBestMatch(String[] names) {
        if (this.m_names.length > names.length) {
            return 0;
        }
        int numElementsToMatch = this.m_names.length;
        for (int i = 0; i < numElementsToMatch; ++i) {
            if (this.m_names[i].equalsIgnoreCase(names[i])) continue;
            String inputName = names[i];
            int index = inputName.indexOf(":");
            if (index > 0) {
                inputName = inputName.substring(0, index);
            }
            if (this.m_names[i].equalsIgnoreCase(inputName)) continue;
            return 0;
        }
        return numElementsToMatch;
    }

    public Hashtable getContentMappings() {
        return this.m_contentMaps;
    }

    public void setContentMappings(Hashtable maps) {
        this.m_contentMaps = maps;
    }

    public Object getFactoryInstance() {
        return this.m_factoryInstance;
    }

    public void setFactoryInstance(Object instance) {
        this.m_factoryInstance = instance;
    }

    public int getUrlLength() {
        return this.m_names.length;
    }

    public boolean isBestMatch(String urlPath) {
        StringTokenizer st = new StringTokenizer(urlPath, "/\\");
        int count = st.countTokens();
        return this.getUrlLength() == count;
    }
}

