/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Vector;

public class CertUtil {
    private static boolean DEBUG = false;
    private static X509Certificate[] CerticateArray = new X509Certificate[0];

    public static X509Certificate loadX509Certificate(String cert) throws FileNotFoundException, CertificateException {
        return CertUtil.loadX509Certificate(new FileInputStream(cert));
    }

    public static X509Certificate loadX509Certificate(InputStream is) throws CertificateException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cf.generateCertificate(is);
        }
        catch (CertificateException ex) {
            throw CertUtil.printStackTrace(ex);
        }
    }

    public static X509Certificate[] loadX509CertificateChain(String chain) throws FileNotFoundException, CertificateException {
        return CertUtil.loadX509CertificateChain(new FileInputStream(chain));
    }

    public static X509Certificate[] loadX509CertificateChain(InputStream is) throws CertificateException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(is);
            return certs.toArray(CerticateArray);
        }
        catch (CertificateException ex) {
            throw CertUtil.printStackTrace(ex);
        }
    }

    private static CertificateException printStackTrace(CertificateException ex) {
        if (DEBUG) {
            ex.printStackTrace();
        }
        return ex;
    }

    public static X509Certificate[] loadX509Certificates(String path) {
        if (path == null || path.trim().length() <= 0) {
            return null;
        }
        File dir = new File(path.trim());
        if (!dir.isDirectory()) {
            if (DEBUG) {
                System.out.println("Invalid directory path: " + path);
            }
            return null;
        }
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            if (DEBUG) {
                ce.printStackTrace();
            }
            return null;
        }
        if (DEBUG) {
            System.out.println("Loading X.509 certificate(s) from directory " + path);
        }
        Object[] certs = null;
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            Vector<X509Certificate> certVec = new Vector<X509Certificate>();
            for (int i = 0; i < files.length; ++i) {
                try {
                    FileInputStream fis = new FileInputStream(files[i]);
                    certVec.addElement((X509Certificate)cf.generateCertificate(fis));
                    fis.close();
                    continue;
                }
                catch (Exception ex) {
                    if (!DEBUG) continue;
                    System.out.println(ex + " : Unable to load X.509 certificate from " + files[i].getName());
                }
            }
            certs = new X509Certificate[certVec.size()];
            certVec.copyInto(certs);
        }
        return certs;
    }

    public static void main(String[] argv) {
        String baseDir = "C:/sandboxMQ8.0/sonic/MQ8.0";
        if (argv != null && argv.length > 0) {
            baseDir = argv[0];
        }
        String serverp7c = baseDir + "/certs/server.p7c";
        String caDir = baseDir + "/certs/CA";
        String caCert = baseDir + "/certs/CA/SonicMQCA.der";
        try {
            int i;
            System.out.println(CertUtil.loadX509Certificate(caCert));
            X509Certificate[] certs = CertUtil.loadX509CertificateChain(serverp7c);
            for (i = 0; i < certs.length; ++i) {
                System.out.println(certs[i]);
            }
            certs = CertUtil.loadX509Certificates(caDir);
            for (i = 0; i < certs.length; ++i) {
                System.out.println(certs[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }
}

