/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.protocol;

import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.IElement;
import com.sonicsw.ws.rm.protocol.Identifier;
import com.sonicsw.ws.rm.protocol.LastMessage;
import com.sonicsw.ws.rm.protocol.MessageNumber;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;

public class Sequence
extends MessageElement
implements IElement {
    private Constants RMConstants;
    private MessageElement seqElement;
    private Identifier identifier;
    private MessageNumber messageNumber;
    private LastMessage lastMessage;

    public Sequence(Constants constants) {
        this.RMConstants = constants;
        this.seqElement = new MessageElement(this.RMConstants.getNSURI(), "Sequence");
    }

    public Sequence(SOAPHeaderElement headerElement) {
        this.seqElement = headerElement;
        Iterator iterator = headerElement.getChildElements();
        while (iterator.hasNext()) {
            MessageElement childElement = (MessageElement)iterator.next();
            if (childElement.getName().equals("Identifier")) {
                this.identifier = new Identifier(childElement);
            }
            if (childElement.getName().equals("MessageNumber")) {
                this.messageNumber = new MessageNumber(childElement);
            }
            if (!childElement.getName().equals("LastMessage")) continue;
            this.lastMessage = new LastMessage(childElement);
        }
    }

    @Override
    public MessageElement getSoapElement() throws SOAPException {
        this.seqElement.detachAllChildren();
        if (this.lastMessage != null) {
            this.seqElement.addChildElement((SOAPElement)this.lastMessage.getSoapElement());
        }
        this.seqElement.addChildElement((SOAPElement)this.identifier.getSoapElement());
        this.seqElement.addChildElement((SOAPElement)this.messageNumber.getSoapElement());
        return this.seqElement;
    }

    public SOAPEnvelope toSOAPEnvelope(SOAPEnvelope envelope) throws Exception {
        SOAPEnvelope env = envelope;
        if (env.getHeader() == null) {
            env.addHeader();
        }
        Name name = env.createName("Sequence", "wsrm", this.RMConstants.getNSURI());
        SOAPHeaderElement headerElement = (SOAPHeaderElement)env.getHeader().addHeaderElement(name);
        headerElement.setActor(null);
        headerElement.setMustUnderstand(true);
        if (this.identifier != null) {
            this.identifier.toSOAPEnvelope((MessageElement)headerElement);
        }
        if (this.messageNumber != null) {
            this.messageNumber.toSOAPEnvelope((MessageElement)headerElement);
        }
        if (this.lastMessage != null) {
            this.lastMessage.toSOAPEnvelope((MessageElement)headerElement);
        }
        return env;
    }

    @Override
    public void addChildElement(MessageElement element) throws SOAPException {
        this.seqElement.addChildElement((SOAPElement)element);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public LastMessage getLastMessage() {
        return this.lastMessage;
    }

    public MessageNumber getMessageNumber() {
        return this.messageNumber;
    }

    public void setIdentifier(Identifier identifer) {
        this.identifier = identifer;
    }

    public void setLastMessage(LastMessage message) {
        this.lastMessage = message;
    }

    public void setMessageNumber(MessageNumber number) {
        this.messageNumber = number;
    }
}

