/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.Broker;
import progress.message.broker.StatsManager;
import progress.message.broker.StatsMetrics;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.util.EAssertFailure;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public class GetStats
implements IMessageHandler {
    public static final int METRIC_CURRENT_MEMORY = 257;
    public static final int METRIC_PHYSICAL_CONNECTIONS = 258;
    public static final int METRIC_CONN_CLIENTS = 259;
    public static final int METRIC_MSGSRECD = 260;
    public static final int METRIC_AVG_MSGSRECD = 261;
    public static final int METRIC_AVG_BYTESRECD = 262;
    public static final int METRIC_MSGSDELIV = 263;
    public static final int METRIC_AVG_MSGSDELIV = 264;
    public static final int NUM_SYSTEM_METRICS = 8;
    public static final int METRIC_PUBSUB_PUB_MSGS = 1025;
    public static final int METRIC_PUBSUB_PUB_MSGPERSEC = 1026;
    public static final int METRIC_PUBSUB_DELIV_MSGS = 1027;
    public static final int METRIC_PUBSUB_DELIV_MSGPERSEC = 1028;
    public static final int METRIC_PUBSUB_MSGRESTORED = 1029;
    public static final int NUM_PUBSUB_METRICS = 5;
    public static final int METRIC_PTP_PUB_MSGS = 1281;
    public static final int METRIC_PTP_PUB_MSGPERSEC = 1282;
    public static final int METRIC_PTP_DELIV_MSGS = 1283;
    public static final int METRIC_PTP_DELIV_MSGPERSEC = 1284;
    public static final int METRIC_PTP_FRWRD_MSGS = 1285;
    public static final int METRIC_PTP_FRWRD_MSGPERSEC = 1286;
    public static final int NUM_PTP_METRICS = 6;
    public static final int METRIC_COMMIT_TXNS = 1537;
    public static final int METRIC_ABORT_TXNS = 1538;
    public static final int NUM_TRANSACTION_METRICS = 2;
    public static final int METRIC_LOG_FILE_SIZE = 513;
    public static final int METRIC_SYNC_POINTS = 514;
    public static final int NUM_LOG_METRICS = 2;
    public static final int NUM_DATABASE_METRICS = 0;
    public static final int NUM_FLOW_CONTROL_METRICS = 0;
    public static final int METRIC_PEAK_SAVED_MSGS = 1;
    public static final int METRIC_CURR_SAVED_MSGS = 2;
    public static final int NUM_MISC_METRICS = 2;
    public static final Hashtable metricCaptions = new Hashtable();
    public static final Hashtable metricTypes = new Hashtable();
    public static final Hashtable metricKeys = new Hashtable();
    private StatsManager m_statsMgr;

    GetStats(StatsManager statsMgr) {
        this.m_statsMgr = statsMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addMetric(String description, int facility, int type) {
        int newId;
        Hashtable hashtable = metricCaptions;
        synchronized (hashtable) {
            newId = StatsMetrics.getNewMetricIdForFacility(facility);
            if (newId > 255) {
                throw new EAssertFailure("Can't register metric - limit reached for facility " + StatsMetrics.facilityDisplayNames.get(facility));
            }
            metricCaptions.put(new Integer(newId |= facility << 8), description);
            metricTypes.put(new Integer(newId), new Integer(type));
        }
        return newId;
    }

    public static void addType(int metricId, int metricType) {
        metricTypes.put(new Integer(metricId), new Integer(metricType));
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message req = env.getMessage();
            Message reply = new Message();
            if (req.readBoolean()) {
                Enumeration keys = metricCaptions.keys();
                Enumeration elements = metricCaptions.elements();
                reply.writeInt(metricCaptions.size());
                while (keys.hasMoreElements()) {
                    reply.writeInt((Integer)keys.nextElement());
                    reply.writeUTF((String)elements.nextElement());
                }
            }
            Message rep = this.m_statsMgr.getStats(reply);
            s.reply(rep, env);
        }
        catch (EGeneralException e) {
            if (!Broker.isInShutdown()) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    static int getMetricId(String s) {
        Integer mid = (Integer)metricKeys.get(s);
        if (mid != null) {
            return mid;
        }
        return -1;
    }

    static Hashtable getMetricKeys() {
        return metricKeys;
    }

    static {
        metricCaptions.put(new Integer(513), prAccessor.getString("STR301"));
        metricCaptions.put(new Integer(514), prAccessor.getString("STR302"));
        metricCaptions.put(new Integer(2), prAccessor.getString("STR303"));
        metricCaptions.put(new Integer(1), prAccessor.getString("STR304"));
        metricCaptions.put(new Integer(1537), prAccessor.getString("STR305"));
        metricCaptions.put(new Integer(1538), prAccessor.getString("STR306"));
        metricCaptions.put(new Integer(259), prAccessor.getString("STR307"));
        metricCaptions.put(new Integer(1025), prAccessor.getString("STR309"));
        metricCaptions.put(new Integer(1026), prAccessor.getString("STR310"));
        metricCaptions.put(new Integer(1281), prAccessor.getString("STR311"));
        metricCaptions.put(new Integer(1285), prAccessor.getString("STR351"));
        metricCaptions.put(new Integer(1282), prAccessor.getString("STR312"));
        metricCaptions.put(new Integer(1286), prAccessor.getString("STR352"));
        metricCaptions.put(new Integer(1029), prAccessor.getString("STR313"));
        metricCaptions.put(new Integer(257), prAccessor.getString("STR315"));
        metricCaptions.put(new Integer(258), prAccessor.getString("STR316"));
        metricCaptions.put(new Integer(260), prAccessor.getString("STR317"));
        metricCaptions.put(new Integer(263), prAccessor.getString("STR318"));
        metricCaptions.put(new Integer(261), prAccessor.getString("STR319"));
        metricCaptions.put(new Integer(264), prAccessor.getString("STR320"));
        metricCaptions.put(new Integer(262), prAccessor.getString("STR321"));
        metricCaptions.put(new Integer(1027), prAccessor.getString("STR322"));
        metricCaptions.put(new Integer(1028), prAccessor.getString("STR323"));
        metricCaptions.put(new Integer(1283), prAccessor.getString("STR324"));
        metricCaptions.put(new Integer(1284), prAccessor.getString("STR325"));
        metricKeys.put("CONN_CLIENTS", new Integer(259));
        metricKeys.put("PUBSUB_PUB_MSGPERSEC", new Integer(1026));
        metricKeys.put("PTP_PUB_MSGPERSEC", new Integer(1282));
        metricKeys.put("PTP_FRWRD_MSGPERSEC", new Integer(1286));
        metricKeys.put("CURRENT_MEMORY", new Integer(257));
        metricKeys.put("PHYSICAL_CONNECTIONS", new Integer(258));
        metricKeys.put("AVG_MSGSRECD", new Integer(261));
        metricKeys.put("AVG_MSGSDELIV", new Integer(264));
        metricKeys.put("AVG_BYTESRECD", new Integer(262));
        metricKeys.put("PUBSUB_DELIV_MSGPERSEC", new Integer(1028));
        metricKeys.put("PTP_DELIV_MSGPERSEC", new Integer(1284));
    }
}

