/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.net.MalformedURLException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.RoutingConfiguration;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.msg.IMgram;
import progress.message.util.DraDestUtil;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

public class MgramURLHelper {
    private static final String DEBUG_NAME = "MgrmURLHelper";
    private static AgentRegistrar m_reg = AgentRegistrar.getAgentRegistrar();

    static String getEffectiveRNN(String routingNode, String urlDestination) {
        if (routingNode != null && routingNode.equalsIgnoreCase(SessionConfig.SONIC_HTTP) && DraDestUtil.isHttpOrHttps(urlDestination)) {
            String rnn = MgramURLHelper.routingNodeReverseLookup(urlDestination);
            DebugObject.class_debug(DEBUG_NAME, "getEffectiveRNN() for: " + urlDestination + " result is " + rnn);
            if (rnn != null) {
                return rnn;
            }
        }
        return routingNode;
    }

    static String routingNodeReverseLookup(String destination) {
        RoutingConnectionInfo node = m_reg.routingNodeReverseLookup(destination);
        if (node != null) {
            return node.getRoutingNodeName();
        }
        return null;
    }

    static String getHttpOverrideDestination(IMgram mgram, String routingNodeName) {
        if (!MgramURLHelper.isValidRemoteHttpNode(routingNodeName)) {
            return null;
        }
        return MgramURLHelper.getHttpOverrideDestination(mgram);
    }

    static String getHttpOverrideDestination(IMgram mgram) {
        Object urlProperty = MgramURLHelper.getSidebandDataProperty(mgram, "X-HTTP-DestinationURL");
        String httpURL = null;
        if (urlProperty instanceof String) {
            httpURL = (String)urlProperty;
        }
        DebugObject.class_debug(DEBUG_NAME, "getHttpOverrideDestination() : " + httpURL);
        return httpURL;
    }

    static ISubject getHttpOverrideSubject(String httpURL, String routingNodeName) throws MalformedURLException {
        String httpRemoteSubject = DraDestUtil.httpUrlToSecSubject(routingNodeName, httpURL);
        DebugObject.class_debug(DEBUG_NAME, "getHttpOverrideSubject() for url: " + httpURL + " rnn: " + routingNodeName + " result is " + httpRemoteSubject);
        if (httpRemoteSubject == null) {
            throw new MalformedURLException();
        }
        return new Subject(httpRemoteSubject);
    }

    static boolean isValidNodeForURLDestination(ISubject subject, String remoteNode) {
        if (!DraDestUtil.isSubjectURL(subject)) {
            return true;
        }
        boolean is = MgramURLHelper.isValidRemoteHttpNode(remoteNode);
        return is;
    }

    public static boolean isValidRemoteHttpNode(String routingNodeName) {
        RoutingConfiguration rc;
        RoutingConnectionInfo rci;
        return routingNodeName != null && !routingNodeName.equals("") && (rci = (rc = m_reg.getRoutingConfig()).getRoutingConnection(routingNodeName)) != null && rci.getRouteType() != RoutingConnectionInfo.ROUTE_TYPE_SONIC;
    }

    static String getHttpNodeURL(String routingNodeName) {
        RoutingConfiguration rc;
        RoutingConnectionInfo rci;
        String url = null;
        if (routingNodeName != null && !routingNodeName.equals("") && (rci = (rc = m_reg.getRoutingConfig()).getRoutingConnection(routingNodeName)) != null) {
            url = rci.getConnectionURLs();
        }
        DebugObject.class_debug(DEBUG_NAME, "getHttpNodeURL() for rnn : " + routingNodeName + " result : " + url);
        return url;
    }

    public static String getEffectiveURLDestination(IMgram mgram) {
        String httpURL = mgram.getSubject().getJMSName();
        if (DraDestUtil.getUrlHostName(httpURL) != null) {
            DebugObject.class_debug(DEBUG_NAME, "getEffectiveURLDestination() returning subject : " + httpURL);
            return httpURL;
        }
        Object urlProperty = MgramURLHelper.getSidebandDataProperty(mgram, "X-HTTP-DestinationURL");
        if (urlProperty instanceof String && DraDestUtil.isHttpOrHttps(httpURL = (String)urlProperty)) {
            DebugObject.class_debug(DEBUG_NAME, "getEffectiveURLDestination() returning X-prop " + httpURL);
            return httpURL;
        }
        DebugObject.class_debug(DEBUG_NAME, "getEffectiveURLDestination() returning null");
        return null;
    }

    private static Object getSidebandDataProperty(IMgram mgram, String key) {
        ISidebandData data = mgram.getSidebandData();
        return data == null ? null : data.getProperty(key);
    }
}

