/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class MsgRestoreEndEvt
extends LogEvent {
    private long m_cid;
    private long m_rid;

    MsgRestoreEndEvt(long cid, long rid) {
        this.m_cid = cid;
        this.m_rid = rid;
    }

    MsgRestoreEndEvt() {
    }

    @Override
    public short type() {
        return 153;
    }

    public long getCid() {
        return this.m_cid;
    }

    public long getRestoreId() {
        return this.m_rid;
    }

    @Override
    protected int memSizeBody() {
        return 8;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return this.memSizeBody();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_cid, os);
        StreamUtil.writeLong(this.m_rid, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_cid = StreamUtil.readLong(in);
        this.m_rid = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        AgentRegistrar.getAgentRegistrar().getMsgRestoreMgr().redoMsgRestoreEndEvt(this);
    }

    @Override
    public String toString() {
        return super.toString() + " cid: " + this.m_cid + " rid: " + this.m_rid;
    }
}

