/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.UnsubscribeAll;
import progress.message.util.StreamUtil;
import progress.message.zclient.Envelope;

class UnsubscribeAllEvt
extends LogEvent {
    private long m_id;
    private Envelope m_request = null;

    UnsubscribeAllEvt(long id, Envelope request) {
        this.m_id = id;
        this.m_request = request;
    }

    UnsubscribeAllEvt() {
    }

    @Override
    public short type() {
        return 4;
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public void onFlush() {
        this.localUnsubscribeDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void localUnsubscribeDone() {
        Envelope request = null;
        UnsubscribeAllEvt unsubscribeAllEvt = this;
        synchronized (unsubscribeAllEvt) {
            if (this.m_request == null) {
                return;
            }
            request = this.m_request;
            this.m_request = null;
        }
        UnsubscribeAll.sendReply(request, 0);
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }

    @Override
    protected int memSizeBody() {
        return 8;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        return 8;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeLong(this.m_id, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoUnsubscribeAll(this.m_id);
        AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().redoUnsubscribeAllEvt(this.m_id, this.getSeqNo(), this.isReplicateOnly());
    }

    @Override
    public String toString() {
        return super.toString() + "Client " + this.m_id + " unsubscribe all";
    }
}

