/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.durable.DurableInfoDelegator;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class DurableSearchReplyOp
extends DurableInfoDelegator
implements IDurableReplyOperation {
    private static final byte CURRENT_VERSION = 0;
    private boolean m_containsError = false;
    private int m_errorCode = 0;

    public DurableSearchReplyOp(String brokerName) {
        this.setBrokerName(brokerName);
    }

    public DurableSearchReplyOp(IMgram mg) {
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 5) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        ObjectInput dinput = mg.getPayloadInputStreamHandle();
        try {
            dinput.readByte();
            this.unserializeInfo(dinput);
            this.m_containsError = dinput.readBoolean();
            if (this.m_containsError) {
                this.m_errorCode = dinput.readInt();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean wasMessageFound() {
        return this.hasInfo();
    }

    @Override
    public boolean isComplete() {
        return this.hasInfo();
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.m_errorCode = errorCode;
        this.m_containsError = true;
    }

    @Override
    public IMgram getMgram() {
        IMgram mg = MgramFactory.getMgramFactory().buildOperationMgram(5);
        try {
            ObjectOutput doutput = mg.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            this.serializeInfo(doutput);
            doutput.writeBoolean(this.m_containsError);
            if (this.m_containsError) {
                doutput.writeInt(this.m_errorCode);
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return mg;
    }
}

