/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.stats;

import progress.message.broker.stats.StatsObj;

class LongDataCollector {
    long[] data;
    int nextIndx;

    protected LongDataCollector() {
    }

    protected void setNumDataValues(int num) {
        this.data = new long[num];
        this.nextIndx = 0;
    }

    protected void resetDataValues(long value) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = value;
        }
    }

    protected void setNextDataValue(long value) {
        this.data[this.nextIndx] = value;
        this.nextIndx = (this.nextIndx + 1) % this.data.length;
    }

    protected long getLastDataValue() {
        int lastIndx = (this.nextIndx - 1 + this.data.length) % this.data.length;
        return this.data[lastIndx];
    }

    protected long getMin() {
        long result = 0L;
        for (int i = 0; i < this.data.length; ++i) {
            result = Math.min(result, this.data[i]);
        }
        return result;
    }

    protected long getMax() {
        long result = 0L;
        for (int i = 0; i < this.data.length; ++i) {
            result = Math.max(result, this.data[i]);
        }
        return result;
    }

    protected long getTotal() {
        long result = 0L;
        for (int i = 0; i < this.data.length; ++i) {
            result += this.data[i];
        }
        return result;
    }

    protected long getAvg() {
        long result = StatsObj.compute(this.getTotal(), this.data.length, 1);
        return result;
    }
}

